/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.title;

import com.kingdee.bos.ctrl.bibench.platform.ui.PaltformWorkBenchContext;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.title.ITitleModifyListener;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.title.TitleCellPanel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;

public class TitlePanel
extends KDPanel {
    private static final long serialVersionUID = -6482432757648107344L;
    private Map cellMap = new HashMap();
    private int maxRowIndex = 0;
    private int maxColIndex = 0;
    private boolean forDesign = false;
    private ITitleModifyListener listener;
    private PaltformWorkBenchContext ctx;
    private Map envMap = null;

    public TitlePanel() {
        this(false);
    }

    public TitlePanel(boolean forDesign) {
        this.forDesign = forDesign;
    }

    public void setEnvMap(Map env) {
        this.envMap = env;
    }

    public void setPaltformWorkBenchContext(PaltformWorkBenchContext ctx) {
        this.ctx = ctx;
    }

    public void setTitleModifyListener(ITitleModifyListener l) {
        this.listener = l;
    }

    public Cell setCell(int row, int col, Object value) {
        return this.setCell(row, col, value, 10);
    }

    public Cell setCell(int row, int col, Object value, int align) {
        Cell cell = new Cell(row, col, value, align);
        this.cellMap.put(cell.getKey(), cell);
        return cell;
    }

    public Object getCell(int row, int col) {
        Cell c = (Cell)this.cellMap.get(Cell.buildKey(row, col));
        return c == null ? null : c.value;
    }

    public Cell getCellObject(int row, int col) {
        return (Cell)this.cellMap.get(Cell.buildKey(row, col));
    }

    public String getCellText(int row, int col) {
        int i = row * (this.maxColIndex + 1) + col;
        if (i < this.getComponentCount()) {
            TitleCellPanel tc = (TitleCellPanel)((Object)this.getComponent(i));
            return tc.getText();
        }
        return null;
    }

    public void finishSetted() {
        this.removeAll();
        this.maxColIndex = -1;
        this.maxRowIndex = -1;
        for (Cell c : this.cellMap.values()) {
            this.maxRowIndex = Math.max(this.maxRowIndex, c.row);
            this.maxColIndex = Math.max(this.maxColIndex, c.col);
        }
        if (this.maxRowIndex >= 0 && this.maxColIndex >= 0) {
            GridLayout layout = new GridLayout(this.maxRowIndex + 1, this.maxColIndex + 1);
            this.setLayout(layout);
            for (int i = 0; i <= this.maxRowIndex; ++i) {
                for (int j = 0; j <= this.maxColIndex; ++j) {
                    Cell c;
                    TitleCellPanel cp = new TitleCellPanel(this.forDesign);
                    cp.setEnvMap(this.envMap);
                    cp.setPaltformWorkBenchContext(this.ctx);
                    if (this.forDesign) {
                        cp.setTitleModifyListener(this.listener);
                        cp.setCellPostion(i, j);
                    }
                    if ((c = this.getCellObject(i, j)) != null) {
                        cp.setCell(c);
                        Object v = c.value;
                        if (v != null) {
                            cp.setHorizontalAlignment(c.align);
                            cp.setCellFont(new Font(cp.getFont().getFamily(), c.fontBold ? 1 : 0, c.fontSize));
                            cp.setUseVar(c.useVar);
                            cp.setText(v.toString());
                            cp.updateUI();
                        }
                    }
                    this.add((Component)((Object)cp));
                }
            }
            this.setCustomInsets(new Insets(3, 10, 3, 10));
        }
        this.updateUI();
    }

    public int getMaxRowIndex() {
        return this.maxRowIndex;
    }

    public int getMaxColIndex() {
        return this.maxColIndex;
    }

    public void reLayout(int row, int col) {
        HashMap oldMap = new HashMap();
        oldMap.putAll(this.cellMap);
        this.cellMap.clear();
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                Cell oldCell = (Cell)oldMap.get(Cell.buildKey(i, j));
                if (oldCell != null) {
                    Cell c = this.setCell(i, j, oldCell.value, oldCell.align);
                    c.fontBold = oldCell.fontBold;
                    c.fontSize = oldCell.fontSize;
                    c.useVar = oldCell.useVar;
                    continue;
                }
                this.setCell(i, j, "");
            }
        }
        this.finishSetted();
        if (this.listener != null) {
            this.listener.modified();
        }
    }

    public String genAllScript() {
        Component[] cs = this.getComponents();
        int len = cs.length;
        if (len == 0) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            s.append(((TitleCellPanel)((Object)cs[i])).genScript());
        }
        s.append("title").append(".finishSetted();");
        return s.toString();
    }

    static class Cell {
        int row;
        int col;
        Object value;
        int align;
        boolean fontBold = false;
        int fontSize = 12;
        boolean useVar = false;

        Cell(int row, int col, Object value, int align) {
            this.row = row;
            this.col = col;
            this.value = value;
            this.align = align;
        }

        public void setFontBold(boolean b) {
            this.fontBold = b;
        }

        public void setFontSize(int size) {
            this.fontSize = size;
        }

        public void setUseVar(boolean b) {
            this.useVar = b;
        }

        public int hasCode() {
            return this.getKey().hashCode();
        }

        public String getKey() {
            return Cell.buildKey(this.row, this.col);
        }

        static String buildKey(int row, int col) {
            return row + "_" + col;
        }
    }
}

