/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.title;

import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import com.kingdee.bos.ctrl.bibench.platform.ui.PaltformWorkBenchContext;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.title.ITitleModifyListener;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.title.TitlePanel;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.title.TitleScriptExecutor;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.MsgBox;
import com.kingdee.bos.ctrl.common.ui.editor.DefaultEditorStyleModel;
import com.kingdee.bos.ctrl.common.ui.editor.EditorRowHeader;
import com.kingdee.bos.ctrl.common.ui.editor.styled.MiniScriptEditor;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.script.miniscript.MiniScriptParseException;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TitlePanelDesignUI
extends KDPanel
implements ITitleModifyListener {
    private TitlePanel panel = new TitlePanel(true);
    private MiniScriptEditor miniEditor = new MiniScriptEditor();
    private EditorRowHeader rh = new EditorRowHeader();
    private KDTextField txtRow = new KDTextField();
    private KDTextField txtCol = new KDTextField();
    private boolean hasInitListener = false;
    private PaltformWorkBenchContext ctx;

    public TitlePanelDesignUI() {
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        DefaultEditorStyleModel m = (DefaultEditorStyleModel)this.miniEditor.getStyleModel();
        m.addStyle(new String[]{"title", "result"}, m.createSimpleAttributeSet(Color.BLUE));
        m.addStyle(new String[]{"left", "right", "center"}, m.createSimpleAttributeSet(Color.GREEN.darker()));
        KDScrollPane sp = new KDScrollPane((Component)this.miniEditor);
        sp.setRowHeaderView((Component)this.rh);
        this.rh.setFont(this.miniEditor.getFont());
        this.rh.setForeground(Color.BLACK);
        this.miniEditor.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                TitlePanelDesignUI.this.rh.showMaxRowNumber(TitlePanelDesignUI.this.miniEditor.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TitlePanelDesignUI.this.rh.showMaxRowNumber(TitlePanelDesignUI.this.miniEditor.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.miniEditor.setEditable(false);
        KDTabbedPane tabbedPanel = new KDTabbedPane(1);
        this.rh.setBackground(tabbedPanel.getBackground());
        KDPanel p = new KDPanel();
        p.setLayout((LayoutManager)new BorderLayout());
        KDPanel northP = new KDPanel();
        northP.add((Component)new KDLabel("\u884c\u6570: "));
        northP.add((Component)this.txtRow);
        northP.add((Component)new KDLabel("\u5217\u6570: "));
        northP.add((Component)this.txtCol);
        this.txtRow.setColumns(10);
        this.txtCol.setColumns(10);
        p.add((Component)northP, (Object)"North");
        p.add((Component)((Object)this.panel), (Object)"Center");
        tabbedPanel.add("\u754c\u9762\u8bbe\u8ba1", (Component)p);
        tabbedPanel.add("\u754c\u9762\u8bbe\u8ba1\u811a\u672c", (Component)sp);
        this.add((Component)tabbedPanel, "Center");
        this.setPreferredSize(new Dimension(100, 100));
        this.panel.setTitleModifyListener(this);
    }

    public void setWorkBenchContext(PaltformWorkBenchContext workBenchContext) {
        this.ctx = workBenchContext;
        this.panel.setPaltformWorkBenchContext(this.ctx);
    }

    public TitlePanel getTitlePanel() {
        return this.panel;
    }

    public void setScript(String script) {
        this.miniEditor.setText(script);
        this.refreshUI(StringUtil.isEmptyString((String)script));
    }

    public String getScript() {
        return this.miniEditor.getText();
    }

    public void addDocumentListener(DocumentListener l) {
        this.miniEditor.getDocument().addDocumentListener(l);
    }

    public void removeDocumentListener(DocumentListener l) {
        this.miniEditor.getDocument().removeDocumentListener(l);
    }

    private void refreshUI(boolean emptyScript) {
        this.panel.removeAll();
        TitleScriptExecutor e = new TitleScriptExecutor(this.ctx);
        e.setTitlePanel(this.panel);
        e.setRowSet(new RDRowSet());
        try {
            e.executeTitleScript(this.miniEditor.getText());
        }
        catch (MiniScriptParseException e1) {
            e1.printStackTrace();
            MsgBox.error("\u5237\u65b0\u754c\u9762", (Exception)((Object)e1), (Component)((Object)this));
        }
        if (emptyScript) {
            this.txtRow.setText("0");
            this.txtCol.setText("0");
        } else {
            this.txtRow.setText(String.valueOf(this.panel.getMaxRowIndex() + 1));
            this.txtCol.setText(String.valueOf(this.panel.getMaxColIndex() + 1));
        }
        if (!this.hasInitListener) {
            this.hasInitListener = true;
            this.hookReLayoutEvent();
        }
    }

    private void hookReLayoutEvent() {
        DocumentListener dl = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TitlePanelDesignUI.this.handReLayout();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TitlePanelDesignUI.this.handReLayout();
            }
        };
        this.txtRow.getDocument().addDocumentListener(dl);
        this.txtCol.getDocument().addDocumentListener(dl);
    }

    private void handReLayout() {
        try {
            int row = Integer.parseInt(this.txtRow.getText().trim());
            int col = Integer.parseInt(this.txtCol.getText().trim());
            if (row >= 0 && row < 10 && col >= 0 && col < 10) {
                this.panel.reLayout(row, col);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public void modified() {
        String script = this.panel.genAllScript();
        this.miniEditor.setText(script);
        this.miniEditor.setCaretPosition(0);
    }
}

