/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.util;

import com.kingdee.bos.ctrl.analysis.mdxw.MdxwContext;
import com.kingdee.bos.ctrl.swing.KDContainer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JFrame;
import javax.swing.UIManager;

public class FaceUtil {
    public static void setFont(Component cc) {
        cc.setFont(MdxwContext.font);
        if (cc instanceof Container) {
            Container c = (Container)cc;
            for (int i = 0; i < c.getComponentCount(); ++i) {
                FaceUtil.setFont(c.getComponent(i));
            }
        }
    }

    public static void center(Window w) {
        Dimension dd = Toolkit.getDefaultToolkit().getScreenSize();
        w.setLocation((dd.width - w.getWidth()) / 2, (dd.height - w.getHeight()) / 2);
    }

    public static String getException(Exception ex, int limit) {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        String msg = sw.toString();
        if (msg.length() > limit) {
            msg = msg.substring(0, limit) + "...";
        }
        return msg;
    }

    public static String getSmartException(Exception ex) {
        String msg = ex.getMessage();
        if (msg == null || msg.trim().length() == 0) {
            msg = FaceUtil.getException(ex, 500);
        }
        return msg;
    }

    public static String getException(Exception ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        return sw.toString();
    }

    public static String getSplitPartException(Exception ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("\u9519\u8bef\u4fe1\u606f\uff1a\r\n" + ex.getMessage());
        pw.println("\r\n==\u5806\u6808\u4fe1\u606f==");
        StackTraceElement[] trace = ex.getStackTrace();
        for (int i = 0; i < trace.length; ++i) {
            pw.println("\tat " + trace[i]);
        }
        Throwable ourCause = ex.getCause();
        if (ourCause != null) {
            FaceUtil.printStackTraceAsCause(pw, trace, ourCause);
        }
        return sw.toString();
    }

    private static void printStackTraceAsCause(PrintWriter s, StackTraceElement[] causedTrace, Throwable ex) {
        Throwable ourCause;
        StackTraceElement[] trace = ex.getStackTrace();
        int m = trace.length - 1;
        for (int n = causedTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(causedTrace[n]); --m, --n) {
        }
        int framesInCommon = trace.length - 1 - m;
        s.println("Caused by: " + ex);
        for (int i = 0; i <= m; ++i) {
            s.println("\tat " + trace[i]);
        }
        if (framesInCommon != 0) {
            s.println("\t... " + framesInCommon + " more");
        }
        if ((ourCause = ex.getCause()) != null) {
            FaceUtil.printStackTraceAsCause(s, trace, ourCause);
        }
    }

    public static KDContainer createContainer(String title, Component comp) {
        KDContainer c = new KDContainer();
        c.setTitleStyle(1);
        c.setEnableActive(false);
        c.setTitle(title);
        c.getContentPane().setLayout(new BorderLayout(0, 0));
        c.getContentPane().add(comp, "Center");
        return c;
    }

    public static JFrame preview(Component c, String title, Dimension size) {
        JFrame f = new JFrame();
        f.getContentPane().setLayout(new BorderLayout());
        f.getContentPane().add(c, "Center");
        f.setSize(size);
        FaceUtil.center(f);
        f.setTitle(title);
        f.setDefaultCloseOperation(2);
        f.setVisible(true);
        return f;
    }

    public static JFrame run(Component c) {
        try {
            UIManager.setLookAndFeel("com.kingdee.bos.ctrl.swing.plaf.KingdeeLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame f = new JFrame();
        f.getContentPane().setLayout(new BorderLayout());
        f.getContentPane().add(c, "Center");
        f.setSize(800, 600);
        FaceUtil.center(f);
        f.setDefaultCloseOperation(2);
        f.setVisible(true);
        return f;
    }

    public static Frame peekFrame(Component c) {
        Component p = c;
        while (!(p instanceof Frame)) {
            if ((p = p.getParent()) != null) continue;
            return null;
        }
        return (Frame)p;
    }

    public static Dialog peekDialog(Component c) {
        Component p = c;
        while (!(p instanceof Dialog)) {
            if ((p = p.getParent()) != null) continue;
            return null;
        }
        return (Dialog)p;
    }
}

