/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.ui;

import com.kingdee.bos.ctrl.common.util.LangUtil;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class MultiLangUI {
    public static final Locale[] LOCALES = new Locale[]{Locale.ENGLISH, Locale.SIMPLIFIED_CHINESE, Locale.TRADITIONAL_CHINESE};

    public static final KDMultiLangBox newKDMultiLangBox() {
        KDMultiLangBox mlb = new KDMultiLangBox();
        for (int i = 0; i < LOCALES.length; ++i) {
            mlb.addItem(new LanguageInfo(LOCALES[i]), (Object)"");
        }
        mlb.setSelectedLanguage(new LanguageInfo(Locale.getDefault()));
        return mlb;
    }

    public static final void toKDMultiLangBox(KDMultiLangBox mlb, Map ps, String name) {
        MultiLangItem[] items = MultiLangUI.toMultiLangItems(ps, name);
        for (int i = 0; i < items.length; ++i) {
            mlb.addItem(items[i]);
        }
    }

    private static MultiLangItem[] getMultiLangItems(KDMultiLangBox mlb) {
        int z = mlb.getItemCount();
        MultiLangItem[] items = new MultiLangItem[z];
        for (int i = 0; i < z; ++i) {
            items[i] = (MultiLangItem)mlb.getItemAt(i);
        }
        return items;
    }

    public static final void fromKDMultiLangBox(KDMultiLangBox mlb, Map ps, String name) {
        MultiLangUI.fromMultiLangItems(MultiLangUI.getMultiLangItems(mlb), ps, name);
    }

    public static final String getDefaultLangString(KDMultiLangBox mlb) {
        Locale loc = Locale.getDefault();
        int z = mlb.getItemCount();
        for (int i = 0; i < z; ++i) {
            MultiLangItem mli = (MultiLangItem)mlb.getItemAt(i);
            if (!loc.equals(mli.getLang().getLocale())) continue;
            return (String)mli.getData();
        }
        return null;
    }

    public static final HashMap fromKDMultiLangBox(KDMultiLangBox mlb) {
        HashMap<String, String> ps = new HashMap<String, String>();
        int z = mlb.getItemCount();
        for (int i = 0; i < z; ++i) {
            MultiLangItem mli = (MultiLangItem)mlb.getItemAt(i);
            String key = LangUtil.makeLang((Locale)mli.getLang().getLocale());
            String val = (String)mli.getData();
            ps.put(key, val);
        }
        return ps;
    }

    public static final void toKDMultiLangBox(KDMultiLangBox mlb, HashMap ps) {
        if (ps == null) {
            int z = mlb.getItemCount();
            for (int i = 0; i < z; ++i) {
                MultiLangItem mli = (MultiLangItem)mlb.getItemAt(i);
                mli.setData(null);
            }
            return;
        }
        for (Map.Entry ent : ps.entrySet()) {
            Locale loc;
            Object key = ent.getKey();
            if (key instanceof Locale) {
                loc = (Locale)key;
            } else {
                if (!(key instanceof String)) continue;
                loc = LangUtil.parseLang((String)((String)key));
            }
            mlb.addItem(new LanguageInfo(loc), (Object)((String)ent.getValue()));
        }
    }

    public static MultiLangItem[] toMultiLangItems(Map ps, String name) {
        MultiLangItem[] items = new MultiLangItem[LOCALES.length];
        for (int i = 0; i < LOCALES.length; ++i) {
            Locale l = LOCALES[i];
            items[i] = new MultiLangItem(new LanguageInfo(l), (Object)((String)LangUtil.getProperty((Map)ps, (String)name, (Locale)l)));
        }
        return items;
    }

    public static void fromMultiLangItems(MultiLangItem[] items, Map ps, String name) {
        for (int i = 0; i < items.length; ++i) {
            MultiLangItem mli = items[i];
            Locale l = mli.getLang().getLocale();
            String val = (String)mli.getData();
            LangUtil.setProperty((Map)ps, (String)name, (Locale)l, (Object)val);
        }
    }
}

