/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.ui.editor;

public class Lexer {
    public static final String ALL_SPECIAL_CHAR = "~`!@#$%^&*()-=_+[]{};':\",./<>?\\|";
    public static final String ALL_STRING_QUOTE = "'\"";
    private StringBuffer s;
    private int i;
    private int e;
    private String specialChar;
    private String quotes = "'\"";

    public Lexer(String ss) {
        this(ss, ALL_SPECIAL_CHAR);
    }

    public Lexer(String ss, String specialChar) {
        this.specialChar = specialChar;
        this.s = new StringBuffer(ss.replaceAll("\\r", ""));
        this.i = 0;
        this.e = this.s.length() - 1;
    }

    public void setStringQuote(String chs) {
        this.quotes = chs;
    }

    public String getStringQuote() {
        return this.quotes;
    }

    public void setSpecialChar(String specialChar) {
        this.specialChar = specialChar;
    }

    public String getSpecialChar() {
        return this.specialChar;
    }

    public void addSpecialChar(char ch) {
        if (this.specialChar.indexOf(ch) == -1) {
            this.specialChar = this.specialChar + ch;
        }
    }

    public void addSpecialChar(String chs) {
        for (char ch : chs.toCharArray()) {
            if (this.specialChar.indexOf(ch) != -1) continue;
            this.specialChar = this.specialChar + ch;
        }
    }

    public void delSpecialChar(String chs) {
        int n = chs.length();
        for (int i = 0; i < n; ++i) {
            this.delSpecialChar(chs.charAt(i));
        }
    }

    public boolean delSpecialChar(char ch) {
        boolean deleted;
        StringBuffer s = new StringBuffer();
        int n = this.specialChar.length();
        for (int i = 0; i < n; ++i) {
            if (this.specialChar.charAt(i) == ch) continue;
            s.append(this.specialChar.charAt(i));
        }
        boolean bl = deleted = this.specialChar.length() > s.length();
        if (deleted) {
            this.specialChar = s.toString();
        }
        return deleted;
    }

    public void reset() {
        this.i = 0;
    }

    public boolean eof() {
        return this.i > this.e;
    }

    public int pos() {
        return this.i;
    }

    public char next() {
        return this.s.charAt(this.i++);
    }

    public void back() {
        --this.i;
    }

    private String spaceToken() {
        int from = this.pos();
        int len = 0;
        block3: while (!this.eof()) {
            char ch = this.next();
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++len;
                    continue block3;
                }
            }
            this.back();
            return this.s.substring(from, from + len);
        }
        return this.s.substring(from, from + len);
    }

    public String nextToken() {
        boolean inQuote = false;
        char quote = '\u0000';
        int from = this.pos();
        int len = 0;
        block3: while (!this.eof()) {
            char ch = this.next();
            if (this.quotes.indexOf(ch) != -1) {
                if (len == 0) {
                    quote = ch;
                    inQuote = true;
                    ++len;
                    continue;
                }
                if (inQuote) {
                    ++len;
                    if (quote != ch) continue;
                    inQuote = false;
                    return this.s.substring(from, from + len);
                }
                ++len;
                continue;
            }
            if (this.specialChar.indexOf(ch) != -1) {
                if (inQuote) {
                    ++len;
                    continue;
                }
                if (len == 0) {
                    return String.valueOf(ch);
                }
                this.back();
                return this.s.substring(from, from + len);
            }
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (inQuote) {
                        ++len;
                        continue block3;
                    }
                    this.back();
                    if (len == 0) {
                        return this.spaceToken();
                    }
                    return this.s.substring(from, from + len);
                }
            }
            ++len;
        }
        return this.s.substring(from, from + len);
    }
}

