/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.ui.joineditor;

import com.kingdee.bos.ctrl.common.ui.joineditor.AbstractModelObject;
import com.kingdee.bos.ctrl.common.ui.joineditor.JoinConstant;
import com.kingdee.bos.ctrl.common.ui.joineditor.ModelField;
import com.kingdee.bos.ctrl.common.ui.joineditor.ModelTable;
import java.awt.Color;

public class ModelLine
extends AbstractModelObject {
    private String id;
    private ModelTable fromTable;
    private ModelField fromField;
    private ModelTable toTable;
    private ModelField toField;
    private int index;
    private int type = 1;
    private int relation = 16;
    private Color color = Color.BLACK;

    public ModelLine() {
        this.objType = 2;
    }

    public ModelLine(String id) {
        this.objType = 2;
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getToolTipText() {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        sb.append(this.getIndex());
        sb.append(") ");
        sb.append(this.getTypeString());
        sb.append(" : ");
        sb.append(this.fromTable);
        sb.append(".");
        sb.append(this.fromField);
        sb.append(this.getRelationString());
        sb.append(this.toTable);
        sb.append(".");
        sb.append(this.toField);
        return sb.toString();
    }

    public String getTypeString() {
        return JoinConstant.getTypeString(this.type);
    }

    public String getRelationString() {
        return JoinConstant.getRelationString(this.relation);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.fromTable);
        sb.append(" . ");
        sb.append(this.fromField);
        sb.append("  -->  ");
        sb.append(this.toTable);
        sb.append(" . ");
        sb.append(this.toField);
        return sb.toString();
    }

    public ModelField getFromField() {
        return this.fromField;
    }

    public void setFromField(ModelField fromField) {
        this.fromField = fromField;
    }

    public ModelTable getFromTable() {
        return this.fromTable;
    }

    public void setFromTable(ModelTable fromTable) {
        this.fromTable = fromTable;
    }

    public ModelField getToField() {
        return this.toField;
    }

    public void setToField(ModelField toField) {
        this.toField = toField;
    }

    public ModelTable getToTable() {
        return this.toTable;
    }

    public void setToTable(ModelTable toTable) {
        this.toTable = toTable;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getRelation() {
        return this.relation;
    }

    public void setRelation(int relation) {
        this.relation = relation;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    protected Color getColor() {
        return this.color;
    }

    protected void setColor(Color color) {
        this.color = color;
    }

    public static String builtFieldRelation(ModelLine line) {
        StringBuffer sb = new StringBuffer();
        sb.append(ModelLine.addBracket(line.getFromTable().getId()));
        sb.append(".");
        sb.append(ModelLine.addBracket(line.getFromField().getId()));
        sb.append(line.getRelationString());
        sb.append(ModelLine.addBracket(line.getToTable().getId()));
        sb.append(".");
        sb.append(ModelLine.addBracket(line.getToField().getId()));
        return sb.toString();
    }

    private static String addBracket(String value) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(value);
        sb.append("]");
        return sb.toString();
    }
}

