/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.ui.pompon;

import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.Timer;

public class KDPompon
extends KDPanel {
    private static final long serialVersionUID = 1L;
    private static final String CTRLTEAM = "ctrlteam";
    private static final int PICWIDTH = 96;
    private static final int PICHEIGHT = 72;
    private boolean _showCtrl;
    private String _inputBuffer = "";
    private static final int TIMES = 20;
    private static Hashtable _urls = new Hashtable();
    private Image[] _allImages;
    private int _picCount;
    private Timer _timer;
    private int _curPicIndex = -1;
    private double _tx;
    private double _ty;
    private double _scalex;
    private double _scaley;
    private double _tranp;
    private int _times;
    private double _dtx;
    private double _dty;
    private double _dsx;
    private double _dsy;

    private Composite getComposite() {
        return AlphaComposite.getInstance(3, (float)this._tranp);
    }

    public KDPompon() {
        this.addKeyListener(new KeyHandler());
        this.addMouseListener(new MouseHandler());
        this.setFocusable(true);
        this._timer = new Timer(50, new ActionHandler());
        this.loadPics();
    }

    public void showCtrlTeam(boolean b) {
        if (this._showCtrl != b) {
            this._showCtrl = b;
            this._curPicIndex = -1;
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this._showCtrl) {
            this.paintCtrlTeam(g);
        } else {
            this.paintNormal(g);
        }
    }

    private void loadPics() {
        if (this._picCount == 0) {
            this._picCount = 5;
            this._allImages = new Image[this._picCount];
            this._allImages[0] = KDPompon.getBufferedImage("11.jpg");
            this._allImages[1] = KDPompon.getBufferedImage("12.jpg");
            this._allImages[2] = KDPompon.getBufferedImage("13.jpg");
            this._allImages[3] = KDPompon.getBufferedImage("14.jpg");
            this._allImages[4] = KDPompon.getBufferedImage("15.jpg");
        }
    }

    private int getMaxVcount() {
        return this.getHeight() / 72;
    }

    private int getPicX(int hindex) {
        return hindex * 98;
    }

    private int getPicY(int vindex) {
        return vindex * 74;
    }

    private int getPicW(int index) {
        return this._allImages[index].getWidth(null);
    }

    private int getPicH(int index) {
        return this._allImages[index].getHeight(null);
    }

    private void paintCtrlTeam(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        AlphaComposite cmp = AlphaComposite.getInstance(3, 0.5f);
        int vcount = this.getMaxVcount();
        for (int i = 0; i < this._picCount; ++i) {
            if (i == this._curPicIndex) continue;
            int vindex = i % vcount;
            int hindex = i / vcount;
            int dx = this.getPicX(hindex);
            int dy = this.getPicY(vindex);
            int pw = this.getPicW(i);
            int ph = this.getPicH(i);
            double sx = 96.0 / (double)pw;
            double sy = 72.0 / (double)ph;
            g2d.translate(dx, dy);
            g2d.scale(sx, sy);
            g2d.setComposite(cmp);
            g2d.drawImage(this._allImages[i], 0, 0, pw, ph, null);
            g2d.scale(1.0 / sx, 1.0 / sy);
            g2d.translate(-dx, -dy);
        }
        if (this._curPicIndex >= 0) {
            int pw = this._allImages[this._curPicIndex].getWidth(null);
            int ph = this._allImages[this._curPicIndex].getHeight(null);
            g2d.translate(this._tx, this._ty);
            g2d.scale(this._scalex, this._scaley);
            g2d.setComposite(this.getComposite());
            g2d.drawImage(this._allImages[this._curPicIndex], 0, 0, pw, ph, null);
        }
    }

    private void paintNormal(Graphics g) {
    }

    public static URL getResourceURL(String resName) {
        if (_urls.containsKey(resName)) {
            return (URL)_urls.get(resName);
        }
        URL url = KDPompon.class.getResource(resName);
        if (url != null) {
            _urls.put(resName, url);
        }
        return url;
    }

    public static Image getBufferedImage(String resName) {
        Image image = null;
        URL url = KDPompon.getResourceURL(resName);
        try {
            image = new ImageIcon(url).getImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return image;
    }

    public static void main(String[] args) {
        KDPompon kdp = new KDPompon();
        KDFrame kdf = new KDFrame();
        kdf.setDefaultCloseOperation(3);
        kdf.setExtendedState(6);
        kdf.setSize(400, 300);
        kdf.getContentPane().setLayout(new BorderLayout());
        kdf.getContentPane().add((Component)((Object)kdp), "Center");
        kdf.setVisible(true);
        kdp.requestFocus();
    }

    class KeyHandler
    implements KeyListener {
        KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            char c = e.getKeyChar();
            if (c == '\u001b') {
                KDPompon.this._inputBuffer = "";
                KDPompon.this.showCtrlTeam(false);
                return;
            }
            if (c != KDPompon.CTRLTEAM.charAt(KDPompon.this._inputBuffer.length())) {
                KDPompon.this._inputBuffer = "";
            } else {
                KDPompon.this._inputBuffer = KDPompon.this._inputBuffer + c;
                if (KDPompon.this._inputBuffer.equals(KDPompon.CTRLTEAM)) {
                    KDPompon.this._inputBuffer = "";
                    KDPompon.this.showCtrlTeam(true);
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (KDPompon.this._curPicIndex >= 0) {
                KDPompon.this._times++;
                if (KDPompon.this._times > 20) {
                    KDPompon.this._tx = KDPompon.this._tx + KDPompon.this._dtx;
                    KDPompon.this._ty = KDPompon.this._ty + KDPompon.this._dty;
                    KDPompon.this._scalex = KDPompon.this._scalex - KDPompon.this._dsx;
                    KDPompon.this._scaley = KDPompon.this._scaley - KDPompon.this._dsy;
                    KDPompon.this._tranp = KDPompon.this._tranp - 0.025;
                } else {
                    KDPompon.this._tx = KDPompon.this._tx - KDPompon.this._dtx;
                    KDPompon.this._ty = KDPompon.this._ty - KDPompon.this._dty;
                    KDPompon.this._scalex = KDPompon.this._scalex + KDPompon.this._dsx;
                    KDPompon.this._scaley = KDPompon.this._scaley + KDPompon.this._dsy;
                    KDPompon.this._tranp = KDPompon.this._tranp + 0.025;
                }
                KDPompon.this.repaint();
                if (KDPompon.this._times == 40) {
                    KDPompon.this._timer.stop();
                    KDPompon.this._curPicIndex = -1;
                    KDPompon.this.repaint();
                }
            }
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int vindex;
            Point p = e.getPoint();
            int x = p.x;
            int y = p.y;
            int hindex = x / 98;
            int vcount = KDPompon.this.getMaxVcount();
            int index = hindex * vcount + (vindex = y / 74);
            if (index < KDPompon.this._picCount) {
                KDPompon.this._curPicIndex = index;
                KDPompon.this._tx = KDPompon.this.getPicX(hindex);
                KDPompon.this._dtx = KDPompon.this._tx / 20.0;
                KDPompon.this._ty = KDPompon.this.getPicY(vindex);
                KDPompon.this._dty = KDPompon.this._ty / 20.0;
                int pw = KDPompon.this.getPicW(index);
                int ph = KDPompon.this.getPicH(index);
                KDPompon.this._scalex = 96.0 / (double)pw;
                KDPompon.this._dsx = (double)(KDPompon.this.getWidth() - 96) / (double)(pw * 20);
                KDPompon.this._scaley = 72.0 / (double)ph;
                KDPompon.this._dsy = (double)(KDPompon.this.getHeight() - 72) / (double)(ph * 20);
                KDPompon.this._tranp = 0.5;
                KDPompon.this._times = 0;
                KDPompon.this._timer.restart();
            }
        }
    }
}

