/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.engine.rows.impl;

import com.kingdee.bos.ctrl.common.util.ArrayWrapper;
import com.kingdee.bos.ctrl.common.util.ObjectUtil;
import com.kingdee.bos.ctrl.common.util.WrapableArray;
import com.kingdee.bos.ctrl.data.engine.rows.IRow;
import com.kingdee.bos.ctrl.data.engine.rows.impl.BasicCachableObject;
import com.kingdee.bos.ctrl.data.engine.rows.impl.ICachableObject;
import com.kingdee.bos.ctrl.data.engine.rows.impl.SimpleRowsMetaData;
import java.io.IOException;

public class Row
extends BasicCachableObject
implements ICachableObject,
IRow {
    private SimpleRowsMetaData meta;
    protected WrapableArray values;
    private byte[] bufferedBytes;
    private int row;

    protected Row() {
    }

    Row(SimpleRowsMetaData cis) {
        this.values = new WrapableArray();
        this.meta = cis;
    }

    @Override
    public Object getValue(int col) {
        return this.meta.getArrayWrapper().wrap(this.values).get(col);
    }

    @Override
    public void setValue(int col, Object obj) {
        this.meta.getArrayWrapper().wrap(this.values).set(col, obj);
        this.setModified(true);
    }

    public String toString() {
        String str = "";
        ArrayWrapper wrapper = this.meta.getArrayWrapper().wrap(this.values);
        for (int i = 1; i < wrapper.size(); ++i) {
            str = str + ":" + wrapper.get(i);
        }
        return str;
    }

    @Override
    public boolean loadByBytes(byte[] bytes) {
        try {
            this.values = (WrapableArray)ObjectUtil.bytesToObject((byte[])bytes);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public byte[] toBytes() {
        try {
            if (super.wasModified() || this.bufferedBytes == null) {
                this.bufferedBytes = ObjectUtil.objectToBytes((Object)this.values);
                super.setModified(false);
            }
            return this.bufferedBytes;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void clearCachedBytes() {
        this.bufferedBytes = null;
    }

    @Override
    public void setModified(boolean b) {
        super.setModified(b);
        if (b) {
            this.clearCachedBytes();
        }
    }
}

