/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.engine.script;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.engine.BindVariants;
import com.kingdee.bos.ctrl.data.invoke.DataContext;
import com.kingdee.bos.ctrl.data.modal.DataDef;
import com.kingdee.bos.ctrl.data.modal.types.IDataSetTypeProvider;
import com.kingdee.bos.ctrl.data.modal.types.rows.OutputColumns;
import com.kingdee.bos.ctrl.data.process.IDataProcessModel;
import com.kingdee.bos.ctrl.data.process.ProcessUtil;
import com.kingdee.bos.ctrl.data.process.dataset.WrappedResultSet;
import com.kingdee.bos.ctrl.data.process.dataset.crosstab.CrosstabInfo;
import com.kingdee.bos.ctrl.data.process.dataset.crosstab.SimpleCrosstabSpell;
import com.kingdee.bos.ctrl.data.process.dataset.crosstab.SimpleRotateAcross;
import com.kingdee.bos.ctrl.data.process.dataset.group.defs.GroupTotalDef;
import com.kingdee.bos.ctrl.data.process.dataset.group.defs.GroupTotalDefs;
import com.kingdee.bos.ctrl.data.process.dataset.group.defs.SimpleGroupsDef;
import com.kingdee.bos.ctrl.data.process.dataset.group.defs.TotalDef;
import com.kingdee.bos.ctrl.data.process.dataset.rowset.SimpleAddColumns;
import com.kingdee.bos.ctrl.data.process.dataset.rowset.SimpleColumnsMerger;
import com.kingdee.bos.ctrl.data.process.dataset.rowset.SimpleProjectionAcross;
import com.kingdee.bos.ctrl.data.process.dataset.rowset.SimpleRowSetAppending;
import com.kingdee.bos.ctrl.data.process.dataset.rowset.SimpleRowsSplitter;
import com.kingdee.bos.ctrl.data.process.dataset.rowset.SimpleUnitRows2;
import com.kingdee.bos.ctrl.kdf.expr.Parser;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;

public class BuiltInUtil {
    private DataContext ctx;

    public BuiltInUtil(DataContext ctx) {
        this.ctx = ctx;
    }

    public final Object executeImport(String name, HashMap params) throws Exception {
        throw new UnsupportedOperationException();
    }

    public final WrappedResultSet batchOutputColumns(ResultSet rs, int step) throws Exception {
        DataDef dataObj = (DataDef)this.ctx.getDataObject();
        IDataProcessModel model = ProcessUtil.getModelFromInfoes(dataObj.getDesignInfoes(), step);
        IDataSetTypeProvider output = model.getOutput();
        if (output instanceof OutputColumns) {
            return WrappedResultSet.resetMetaData(rs, (OutputColumns)output, null);
        }
        throw new UnsupportedOperationException("Bad call.");
    }

    public final WrappedResultSet wrapResultSet(ResultSet rs, String[] usedColumns) throws Exception {
        return WrappedResultSet.wrap(rs, usedColumns);
    }

    public final ResultSet addColumns(ResultSet rs, String[] cols, int[] types, String[] exprs) throws Exception {
        SimpleAddColumns fobj = new SimpleAddColumns(rs, cols, types, exprs);
        fobj.setParameters(this.ctx.getParameters());
        fobj.setEnvProvider(this.ctx.getEnvProvider());
        return (ResultSet)fobj.call();
    }

    public final ResultSet rowsAppending(ResultSet rs0, int[] columns0, ResultSet rs1, int[] columns1, String[] names) throws Exception {
        SimpleRowSetAppending fobj = new SimpleRowSetAppending();
        fobj.setColumnNames(names);
        fobj.setResultSet0(rs0, columns0);
        fobj.setResultSet1(rs1, columns1);
        return (ResultSet)fobj.call();
    }

    public final ResultSet rowsAppending(ResultSet rs0, String[] columns0, ResultSet rs1, String[] columns1, String[] names) throws Exception {
        int[] columns0_int = new int[columns0.length];
        for (int i = 0; i < columns0_int.length; ++i) {
            columns0_int[i] = rs0.findColumn(columns0[i]);
        }
        int[] columns1_int = new int[columns1.length];
        for (int i = 0; i < columns1_int.length; ++i) {
            columns1_int[i] = rs1.findColumn(columns1[i]);
        }
        return this.rowsAppending(rs0, columns0_int, rs1, columns1_int, names);
    }

    public final ResultSet columnsMerger(ResultSet rs, String[] columns, int colIndex, String columnName) throws Exception {
        SimpleColumnsMerger fobj = new SimpleColumnsMerger();
        fobj.setResultSet(rs);
        fobj.setMergerColumns(columns);
        fobj.setNewColumn(colIndex, columnName);
        return (ResultSet)fobj.call();
    }

    public final ResultSet rowsSplitter(ResultSet rs, String[] colNames, int rowFrom) throws Exception {
        SimpleRowsSplitter fobj = new SimpleRowsSplitter();
        fobj.setResultSet(rs);
        fobj.setNewColumns(colNames);
        fobj.setSplitFrom(rowFrom);
        return (ResultSet)fobj.call();
    }

    public final ResultSet projectionAcross(ResultSet rs, String[] columns, int columnFieldMap, String[] rows, int rowFieldMap, String newColName, int acrossField) throws Exception {
        SimpleProjectionAcross fobj = new SimpleProjectionAcross();
        fobj.setResultSet(rs);
        fobj.setAcrossColumn(acrossField);
        fobj.setXAxisInfo(columns, columnFieldMap);
        fobj.setYAxisInfo(rows, rowFieldMap, newColName);
        return (ResultSet)fobj.call();
    }

    public final ResultSet projectionAcross(ResultSet rs, String[] columns, String columnFieldMap, String[] rows, String rowFieldMap, String newColName, String acrossField) throws Exception {
        SimpleProjectionAcross fobj = new SimpleProjectionAcross();
        fobj.setResultSet(rs);
        fobj.setAcrossColumn(rs.findColumn(acrossField));
        fobj.setXAxisInfo(columns, rs.findColumn(columnFieldMap));
        fobj.setYAxisInfo(rows, rs.findColumn(rowFieldMap), newColName);
        return (ResultSet)fobj.call();
    }

    public final ResultSet unitRows(ResultSet rs0, ResultSet rs1, String[] pks0, String[] pks1, String prefix0, String prefix1, String joinType) throws Exception {
        SimpleUnitRows2 fobj = new SimpleUnitRows2();
        fobj.setEnvProvider(this.ctx.getEnvProvider());
        fobj.setRs0(rs0);
        fobj.setRs1(rs1);
        fobj.setPks0(pks0);
        fobj.setPks1(pks1);
        fobj.setPrefix0(prefix0);
        fobj.setPrefix1(prefix1);
        fobj.setJoinMethod(joinType);
        return (ResultSet)fobj.call();
    }

    public final CrosstabInfo spellCrosstab(CrosstabInfo info0, CrosstabInfo info1, boolean xAxis) throws Exception {
        SimpleCrosstabSpell fobj = new SimpleCrosstabSpell();
        fobj.setCrosstab0(info0);
        fobj.setCrosstab1(info1);
        fobj.setSpell(xAxis);
        return (CrosstabInfo)fobj.call();
    }

    public final Object compExprVal(String expr) throws Exception {
        Parser parser = this.ctx.getFormulaEngine();
        parser.prepare(null, expr);
        Variant var = parser.parse();
        if (var.getVt() != 16) {
            return var.getValue();
        }
        throw new Exception("Expresssion error. expr=" + expr);
    }

    public final Object compExprVal2(String expr) throws Exception {
        return BindVariants.replaceVariants(expr, this.ctx.getParameters(), true);
    }

    public final int compExprVal_int(String expr) throws Exception {
        Object v = this.compExprVal(expr);
        return ((Number)v).intValue();
    }

    public final SimpleGroupsDef makeSimpleGroupsDef(String groupFieldsStr) {
        int[] intArray = StringUtil.str2IntArray((String)groupFieldsStr, (String)",");
        return new SimpleGroupsDef(intArray);
    }

    public final CrosstabInfo makeCrosstab(ResultSet rs, String[] xAxis, String[] xOrderAscs, String[] yAxis, String[] yOrderAscs, String[] crossCols, String[] totalMethods, boolean putTotalColsToX, boolean totalAllX, boolean totalAllY) throws Exception {
        SimpleRotateAcross fobj = new SimpleRotateAcross();
        fobj.setResultSet(rs);
        fobj.setXCols(xAxis, xOrderAscs);
        fobj.setYCols(yAxis, yOrderAscs);
        fobj.setCrossColumns(crossCols, totalMethods, true, true, true);
        return (CrosstabInfo)fobj.call();
    }

    public static final String serializeTotalDef(TotalDef def) {
        if (def == null) {
            throw new IllegalArgumentException();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("function=" + def.getFunction() + ";");
        if (def.getTotalCol() != -1) {
            buffer.append("column=" + def.getTotalCol() + ";");
        } else {
            buffer.append("columnName='" + def.getTotalColName() + "';");
        }
        buffer.append("parameter=" + def.getParameter());
        return buffer.toString();
    }

    public static GroupTotalDef str2GroupTotalDef(String str) {
        GroupTotalDef gtDef = new GroupTotalDef();
        if (str.length() != 0) {
            String[] ss = str.split(",");
            for (int i = 0; i < ss.length; ++i) {
                String s = ss[i].substring(1, ss[i].length() - 1);
                gtDef.addTotalDef(BuiltInUtil.makeTotalDef(s));
            }
        }
        return gtDef;
    }

    public static GroupTotalDefs str2GroupTotalDefs(String str) {
        int start = 0;
        ArrayList<GroupTotalDef> list = new ArrayList<GroupTotalDef>();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '(') {
                start = i;
                continue;
            }
            if (ch != ')') continue;
            list.add(BuiltInUtil.str2GroupTotalDef(str.substring(start + 1, i)));
        }
        GroupTotalDefs gtDefs = new GroupTotalDefs(list.size() - 1);
        for (int i = 0; i < list.size(); ++i) {
            gtDefs.setGroupTotalDef(i, (GroupTotalDef)list.get(i));
        }
        return gtDefs;
    }

    public static String groupTotalDef2Str(GroupTotalDef gtDef) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < gtDef.totals(); ++i) {
            sb.append("{");
            sb.append(BuiltInUtil.serializeTotalDef(gtDef.getTotalDef(i)));
            sb.append("}");
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String groupTotalDefs2Str(GroupTotalDefs gtDefs) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < gtDefs.levels() + 1; ++i) {
            sb.append("(");
            sb.append(BuiltInUtil.groupTotalDef2Str(gtDefs.getGroupTotalDef(i)));
            sb.append(")");
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static final TotalDef makeTotalDef(String totalDefStr) {
        try {
            int column = 0;
            String function = null;
            String parameter = "";
            String columnName = null;
            String[] splits = totalDefStr.split(";");
            for (int i = 0; i < splits.length; ++i) {
                String part = splits[i];
                String[] part_splits = part.split("=");
                if (part_splits[0].equals("function")) {
                    function = part_splits[1];
                    continue;
                }
                if (part_splits[0].equals("column")) {
                    column = Integer.parseInt(part_splits[1]);
                    continue;
                }
                if (part_splits[0].equals("columnName")) {
                    columnName = part_splits[1].substring(1, part_splits[1].length() - 1);
                    continue;
                }
                if (!part_splits[0].equals("parameter")) continue;
                parameter = part_splits.length == 2 ? part_splits[1] : "";
            }
            if (columnName == null) {
                return new TotalDef(column, function, parameter);
            }
            return new TotalDef(columnName, function, parameter);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

