/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.engine.script.beanshell;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.TargetError;
import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.data.engine.script.BuiltInUtil;
import com.kingdee.bos.ctrl.data.engine.script.IScriptExecutor;
import com.kingdee.bos.ctrl.data.engine.script.ScriptException;
import com.kingdee.bos.ctrl.data.invoke.DataContext;
import com.kingdee.bos.ctrl.data.modal.CommonQuery;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BeanShellExecutor
implements IScriptExecutor {
    private static final Logger log = LogUtil.getLogger(BeanShellExecutor.class);
    public static final String CONTEXT_NAME = "context";
    public static final String QUERY_NAME = "query";
    public static final String BUILT_IN_UTIL_NAME = "builtInUtil";
    private BeanShellInterpreter bshInterpreter;
    private String initCodes;

    private void initArgs(Map keyVals) throws ScriptException {
        try {
            this.bshInterpreter = new BeanShellInterpreter();
            this.bshInterpreter.setDataContext((DataContext)keyVals.get(CONTEXT_NAME));
            for (Map.Entry ent : keyVals.entrySet()) {
                this.bshInterpreter.set(ent.getKey().toString(), ent.getValue());
            }
        }
        catch (EvalError ex) {
            throw new ScriptException(ex);
        }
    }

    @Override
    public void init(Object arg) throws ScriptException {
        DataContext ctx = (DataContext)arg;
        HashMap<String, Object> bshEnvs = new HashMap<String, Object>();
        bshEnvs.put(CONTEXT_NAME, ctx);
        bshEnvs.put(BUILT_IN_UTIL_NAME, new BuiltInUtil(ctx));
        if (ctx.getDataObject() instanceof CommonQuery) {
            bshEnvs.put(QUERY_NAME, ctx.getDataResult());
            InputStream input = null;
            try {
                input = CtrlUtil.Stream.loadResource(BeanShellExecutor.class, (String)"common_query_init.bsh");
                this.initCodes = new String(CtrlUtil.Stream.readInputStream((InputStream)input));
            }
            catch (Exception ex) {
                throw new ScriptException("\u521d\u59cb\u811a\u672c\u52a0\u8f7d\u9519\u8bef", ex);
            }
            finally {
                CtrlUtil.Stream.closeStream((InputStream)input);
            }
        }
        this.initArgs(bshEnvs);
    }

    @Override
    public void executeScript(String code) throws ScriptException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Execute BeanShell script:\r\n" + code));
        }
        if (code == null) {
            return;
        }
        try {
            NameSpace ns = this.bshInterpreter.getNameSpace();
            if (this.initCodes != null) {
                this.bshInterpreter.eval(new StringReader(this.initCodes), ns, "");
            }
            long l1 = System.currentTimeMillis();
            this.bshInterpreter.eval(new StringReader(code), ns, "");
            long l2 = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug((Object)("token:" + (l2 - l1)));
            }
        }
        catch (EvalError ex) {
            if (ex instanceof TargetError) {
                log.error((Object)"\u6267\u884c\u811a\u672c\u9519\u8bef", (Throwable)ex);
                throw new ScriptException(ex.getMessage(), ((TargetError)ex).getTarget());
            }
            throw new ScriptException(ex);
        }
    }

    public static class BeanShellInterpreter
    extends Interpreter {
        private DataContext dataContext;

        public DataContext getDataContext() {
            return this.dataContext;
        }

        public void setDataContext(DataContext dataContext) {
            this.dataContext = dataContext;
        }
    }
}

