/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.framework.connection;

import com.kingdee.bos.Context;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.ctrl.bizshare.AConnection;
import com.kingdee.bos.ctrl.bizshare.ConnectException;
import com.kingdee.bos.framework.session.ILoginModule;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.bos.framework.session.LoginModuleFactory;
import java.util.Locale;

public class BosConnection
extends AConnection {
    private String serviceUrl;
    private String solution;
    private String ais;
    private String user;
    private String password;
    private Locale locale;
    private String sessionId;

    public BosConnection(String serviceUrl, String solution, String ais, String user, String password, Locale locale) {
        this.serviceUrl = serviceUrl;
        this.solution = solution;
        this.ais = ais;
        this.user = user;
        this.password = password;
        this.locale = locale != null ? locale : Locale.getDefault();
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getSolution() {
        return this.solution;
    }

    public String getAis() {
        return this.ais;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    protected void pureOpen() throws ConnectException {
        ORMRPCServiceLocator.setCurrentServiceURL((String)this.serviceUrl);
        try {
            ILoginModule lm = LoginModuleFactory.getRemoteInstance();
            LoginContext ctx = new LoginContext(this.user, this.password, this.solution, this.ais, this.locale);
            this.sessionId = lm.login(ctx);
        }
        catch (Exception ex) {
            throw new ConnectException((Throwable)ex);
        }
    }

    protected void pureClose() throws ConnectException {
        try {
            ILoginModule lm = LoginModuleFactory.getRemoteInstance();
            if (lm.logout(this.sessionId)) {
                this.sessionId = null;
            }
        }
        catch (Exception ex) {
            throw new ConnectException((Throwable)ex);
        }
    }

    public static Context createContext(String bmdPath) {
        Context ctx = new Context();
        ctx.put((Object)"current_mode", (Object)"DEBUG");
        ctx.put((Object)"METADATAPATH", (Object)bmdPath);
        return ctx;
    }
}

