/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.meta.bmd;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StreamUtil;
import com.kingdee.bos.ctrl.data.meta.bmd.BmdMetaType;
import com.kingdee.bos.ctrl.data.meta.io.Bmd2Meta;
import com.kingdee.bos.util.BOSObjectType;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class BmdMetaEnv {
    private static final Logger log = LogUtil.getPackageLogger(BmdMetaEnv.class);
    private Context ctx;
    private String topPath;
    private BmdMetaType[] validTypes;

    public BmdMetaEnv(Context ctx) {
        this.ctx = ctx;
        this.topPath = (String)this.ctx.get((Object)"METADATAPATH");
    }

    public Context getBOSContext() {
        return this.ctx;
    }

    public BmdMetaType[] getValidTypes() {
        return this.validTypes;
    }

    public void setValidTypes(BmdMetaType[] filters) {
        this.validTypes = filters;
    }

    public boolean isValidType(BmdMetaType type) {
        if (this.validTypes == null) {
            return true;
        }
        for (int i = 0; i < this.validTypes.length; ++i) {
            if (type != this.validTypes[i]) continue;
            return true;
        }
        return false;
    }

    public String makeFilePath(String fileName) {
        return this.topPath + File.separator + fileName;
    }

    public String makeResPath(String path) {
        if (path == null) {
            return this.topPath;
        }
        return this.topPath + path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object loadMetaData(BOSObjectType bosType, String resPath) {
        Object object;
        FileInputStream in = null;
        try {
            in = new FileInputStream(resPath);
            object = Bmd2Meta.loadMetaData(this.getBOSContext(), bosType, in);
        }
        catch (Exception ex) {
            Object var5_6;
            try {
                log.error((Object)("\u52a0\u8f7dBOS\u5143\u6570\u636e\u5931\u8d25\uff1a" + resPath), (Throwable)ex);
                var5_6 = null;
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(in);
                throw throwable;
            }
            StreamUtil.closeStream((InputStream)in);
            return var5_6;
        }
        StreamUtil.closeStream((InputStream)in);
        return object;
    }
}

