/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.cache;

import com.kingdee.bos.ctrl.etl.exception.ETLEOFException;
import com.kingdee.bos.ctrl.etl.exception.ETLFileException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;

public class DBCacheEntry {
    public String dbname;
    public String sql;

    public DBCacheEntry(String dbname, String sql) {
        this.dbname = dbname;
        this.sql = sql;
    }

    public DBCacheEntry() {
        this(null, null);
    }

    public int hashCode() {
        int hashcode = this.dbname.hashCode() ^ this.sql.hashCode();
        return hashcode;
    }

    public boolean equals(Object o) {
        DBCacheEntry obj = (DBCacheEntry)o;
        boolean retval = this.dbname.equalsIgnoreCase(obj.dbname) && this.sql.equalsIgnoreCase(obj.sql);
        return retval;
    }

    public DBCacheEntry(DataInputStream dis) throws ETLFileException {
        try {
            this.dbname = dis.readUTF();
            this.sql = dis.readUTF();
        }
        catch (EOFException eof) {
            throw new ETLEOFException("End of file reached", eof);
        }
        catch (Exception e) {
            throw new ETLFileException("Unable to read cache entry from data input stream", e);
        }
    }

    public boolean write(DataOutputStream dos) {
        try {
            dos.writeUTF(this.dbname);
            dos.writeUTF(this.sql);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

