/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.graph;

import com.kingdee.bos.ctrl.etl.graph.GraphModel;
import com.kingdee.bos.ctrl.etl.graph.GraphUI;
import com.kingdee.bos.ctrl.etl.graph.MyCellViewFactory;
import com.kingdee.bos.ctrl.etl.graph.transformation.HopEdge;
import com.kingdee.bos.ctrl.etl.graph.transformation.StepNode;
import com.kingdee.bos.ctrl.etl.transformation.TransHopMeta;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import java.util.HashMap;
import org.jgraph.JGraph;
import org.jgraph.graph.CellViewFactory;

public class Graph
extends JGraph {
    private TransMeta transMeta;

    public Graph(TransMeta transMeta) {
        super((org.jgraph.graph.GraphModel)new GraphModel());
        this.transMeta = transMeta;
        this.init();
    }

    private void init() {
        this.getGraphLayoutCache().setFactory((CellViewFactory)new MyCellViewFactory());
        this.setJumpToDefaultPort(true);
        this.setCloneable(false);
        HashMap<StepMeta, StepNode> steps = new HashMap<StepMeta, StepNode>();
        StepMeta[] stepMetas = this.transMeta.getStepsArray();
        for (int i = 0; i < stepMetas.length; ++i) {
            StepNode stepNode = this.addStepNode(stepMetas[i]);
            steps.put(stepMetas[i], stepNode);
        }
        TransHopMeta[] hopMetas = this.transMeta.getTransHopsArray();
        for (int i = 0; i < hopMetas.length; ++i) {
            HopEdge hopEdge = this.addHopEdge(hopMetas[i]);
            StepMeta source = hopMetas[i].getFromStep();
            StepMeta target = hopMetas[i].getToStep();
            StepNode sourceNode = (StepNode)((Object)steps.get(source));
            StepNode targetNode = (StepNode)((Object)steps.get(target));
            hopEdge.setSource(sourceNode.getChildAt(0));
            hopEdge.setTarget(targetNode.getChildAt(0));
        }
        this.getGraphLayoutCache().reload();
    }

    private StepNode addStepNode(StepMeta stepMeta) {
        StepNode stepNode = new StepNode(this, this.transMeta, stepMeta);
        this.getGraphLayoutCache().insert((Object)stepNode);
        return stepNode;
    }

    private HopEdge addHopEdge(TransHopMeta hopMeta) {
        HopEdge hopEdge = new HopEdge(this.transMeta, hopMeta);
        this.getGraphLayoutCache().insert((Object)hopEdge);
        return hopEdge;
    }

    public void updateUI() {
        this.setUI((org.jgraph.plaf.GraphUI)new GraphUI());
        this.invalidate();
    }
}

