/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.job.entry;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.job.entry.JobEntryBase;
import com.kingdee.bos.ctrl.etl.job.entry.JobEntryInterface;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import com.kingdee.bos.ctrl.etl.util.Point;
import com.kingdee.bos.ctrl.etl.util.Util;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.util.XMLInterface;
import java.sql.Connection;
import java.util.List;
import org.w3c.dom.Node;

public class JobEntryCopy
implements Cloneable,
XMLInterface {
    private JobEntryInterface entry;
    private int nr;
    private boolean selected;
    private Point location;
    private boolean parallel;
    private boolean draw;
    private long id;

    public JobEntryCopy(LogWriter log) {
        this.clear();
    }

    public JobEntryCopy(LogWriter log, JobEntryInterface entry) {
        this.entry = entry;
    }

    @Override
    public String getXML() {
        String retval = "";
        retval = retval + "    <entry>" + Const.CR;
        retval = retval + this.entry.getXML();
        retval = retval + "      " + XMLHandler.addTagValue("parallel", this.parallel);
        retval = retval + "      " + XMLHandler.addTagValue("draw", this.draw);
        retval = retval + "      " + XMLHandler.addTagValue("nr", this.nr);
        retval = retval + "      " + XMLHandler.addTagValue("xloc", this.location.x);
        retval = retval + "      " + XMLHandler.addTagValue("yloc", this.location.y);
        retval = retval + "      </entry>" + Const.CR;
        return retval;
    }

    public JobEntryCopy(Node entrynode, List databases, Repository rep, Connection ctxConnection) throws ETLXMLException {
        try {
            String stype = XMLHandler.getTagValue(entrynode, "type");
            int type = JobEntryCopy.getType(stype);
            this.entry = JobEntryBase.newJobEntryInterface(type);
            if (this.entry != null) {
                this.entry.loadXML(entrynode, databases, ctxConnection);
                this.setNr(Const.toInt(XMLHandler.getTagValue(entrynode, "nr"), 0));
                this.setParallel("Y".equalsIgnoreCase(XMLHandler.getTagValue(entrynode, "parallel")));
                this.setDrawn("Y".equalsIgnoreCase(XMLHandler.getTagValue(entrynode, "draw")));
                int x = Const.toInt(XMLHandler.getTagValue(entrynode, "xloc"), 0);
                int y = Const.toInt(XMLHandler.getTagValue(entrynode, "yloc"), 0);
                this.setLocation(x, y);
            }
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to read Job Entry copy info from XML node", e);
        }
    }

    public JobEntryCopy(LogWriter log, Repository rep, long id_job, long id_jobentry_copy, List jobentries, List databases) throws ETLException {
        try {
            this.setID(id_jobentry_copy);
            Row r = rep.getJobEntryCopy(id_jobentry_copy);
            if (r != null) {
                long id_jobentry = r.searchValue("ID_JobEntry").getInteger();
                long id_jobentry_type = r.searchValue("ID_JobEntryType").getInteger();
                this.setNr((int)r.searchValue("Nr").getInteger());
                int locx = (int)r.searchValue("GUILocationX").getInteger();
                int locy = (int)r.searchValue("GUILocationY").getInteger();
                boolean isdrawn = r.searchValue("GUIDraw").getBoolean();
                this.entry = Util.findJobEntry(jobentries, id_jobentry);
                if (this.entry == null) {
                    Row rt = rep.getJobEntryType(id_jobentry_type);
                    if (rt != null) {
                        String jet_code = rt.searchValue("CODE").getString();
                        int jet_type = JobEntryBase.getType(jet_code);
                        this.entry = JobEntryBase.newJobEntryInterface(jet_type);
                        this.entry.loadRep(rep, id_jobentry, databases);
                        jobentries.add(this.entry);
                    } else {
                        throw new ETLException("Unable to find Job Entry Type with id=" + id_jobentry_type + " in the repository");
                    }
                }
                this.setLocation(locx, locy);
                this.setDrawn(isdrawn);
            }
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("Unable to load job entry copy from repository with id_jobentry_copy=" + id_jobentry_copy, dbe);
        }
    }

    public void saveRep(Repository rep, long id_job) throws ETLException {
        try {
            long id_jobentry_type;
            long id_jobentry = rep.getJobEntryID(this.getName(), id_job);
            if (id_jobentry <= 0L) {
                this.entry.saveRep(rep, id_job);
                id_jobentry = this.entry.getID();
            }
            if ((id_jobentry_type = rep.getJobEntryTypeID(this.entry.getTypeDesc())) < 0L) {
                rep.updateJobEntryTypes();
                id_jobentry_type = rep.getJobEntryTypeID(this.entry.getTypeDesc());
            }
            this.setID(rep.insertJobEntryCopy(id_job, id_jobentry, id_jobentry_type, this.getNr(), this.getLocation().x, this.getLocation().y, this.isDrawn()));
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("Unable to save job entry copy to the repository, id_job=" + id_job, dbe);
        }
    }

    public void clear() {
        this.location = null;
        this.entry = null;
        this.nr = 0;
        this.parallel = false;
        this.setID(-1L);
    }

    public Object clone() {
        JobEntryCopy ge = null;
        try {
            ge = (JobEntryCopy)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return ge;
    }

    public Object clone_deep() {
        JobEntryCopy ge = null;
        try {
            ge = (JobEntryCopy)super.clone();
            ge.entry = (JobEntryInterface)this.entry.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return ge;
    }

    public void setID(long id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        JobEntryCopy je = (JobEntryCopy)o;
        return je.entry.getName().equalsIgnoreCase(this.entry.getName()) && je.getNr() == this.getNr();
    }

    public long getID() {
        return this.id;
    }

    public void setEntry(JobEntryInterface je) {
        this.entry = je;
    }

    public JobEntryInterface getEntry() {
        return this.entry;
    }

    public int getType() {
        return this.entry.getType();
    }

    public String getTypeDesc() {
        return JobEntryCopy.getTypeDesc(this.entry.getType());
    }

    public void setLocation(int x, int y) {
        int ny;
        int nx = x >= 0 ? x : 0;
        Point loc = new Point(nx, ny = y >= 0 ? y : 0);
        if (!loc.equals(this.location)) {
            this.setChanged();
        }
        this.location = loc;
    }

    public void setLocation(Point loc) {
        if (loc != null && !loc.equals(this.location)) {
            this.setChanged();
        }
        this.location = loc;
    }

    public Point getLocation() {
        return this.location;
    }

    public void setChanged() {
        this.setChanged(true);
    }

    public void setChanged(boolean ch) {
        this.entry.setChanged(ch);
    }

    public boolean hasChanged() {
        return this.entry.hasChanged();
    }

    public int getNr() {
        return this.nr;
    }

    public void setNr(int n) {
        this.nr = n;
    }

    public void setParallel() {
        this.setParallel(true);
    }

    public void setParallel(boolean p) {
        this.parallel = p;
    }

    public boolean isDrawn() {
        return this.draw;
    }

    public void setDrawn() {
        this.setDrawn(true);
    }

    public void setDrawn(boolean d) {
        this.draw = d;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public static final int getType(String dsc) {
        int i;
        if (dsc != null) {
            for (i = 0; i < JobEntryInterface.type_desc.length; ++i) {
                if (!JobEntryInterface.type_desc[i].equalsIgnoreCase(dsc)) continue;
                return i;
            }
        }
        for (i = 0; i < JobEntryInterface.type_desc_long.length; ++i) {
            if (!JobEntryInterface.type_desc_long[i].equalsIgnoreCase(dsc)) continue;
            return i;
        }
        return 0;
    }

    public static final String getTypeDesc(int ty) {
        if (ty > 0 && ty < JobEntryInterface.type_desc.length) {
            return JobEntryInterface.type_desc[ty];
        }
        return JobEntryInterface.type_desc[0];
    }

    public void setSelected(boolean sel) {
        this.selected = sel;
    }

    public void flipSelected() {
        this.selected = !this.selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setDescription(String description) {
        this.entry.setDescription(description);
    }

    public String getDescription() {
        return this.entry.getDescription();
    }

    public boolean isStart() {
        return this.entry.isStart();
    }

    public boolean isDummy() {
        return this.entry.isDummy();
    }

    public boolean isTransformation() {
        return this.getType() == 1;
    }

    public boolean isJob() {
        return this.getType() == 2;
    }

    public boolean evaluates() {
        if (this.entry != null) {
            return this.entry.evaluates();
        }
        return false;
    }

    public boolean isUnconditional() {
        if (this.entry != null) {
            return this.entry.isUnconditional();
        }
        return true;
    }

    public boolean isEvaluation() {
        return this.getType() == 9;
    }

    public boolean isMail() {
        return this.getType() == 4;
    }

    public boolean isSQL() {
        return this.getType() == 4;
    }

    public boolean isSpecial() {
        return this.getType() == 10;
    }

    public String toString() {
        return this.entry.getName() + "." + this.getNr();
    }

    public String getName() {
        return this.entry.getName();
    }

    public void setName(String name) {
        this.entry.setName(name);
    }
}

