/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.logging;

import com.kingdee.bos.ctrl.etl.logging.Log4jMessage;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;

public class Log4jETLLayout
extends Layout {
    private boolean timeAdded;

    public Log4jETLLayout(boolean addTime) {
        this.timeAdded = addTime;
    }

    public String format(LoggingEvent event) {
        Object object;
        String line = "";
        if (this.timeAdded) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            line = line + df.format(new Date(event.getTimeStamp())) + " - ";
        }
        if ((object = event.getMessage()) instanceof Log4jMessage) {
            Log4jMessage message = (Log4jMessage)object;
            if (message.getSubject() != null) {
                line = line + message.getSubject() + " - ";
            }
            if (message.isError()) {
                line = line + "ERROR : ";
            }
            line = line + message.getMessage();
        } else {
            line = line + object.toString();
        }
        return line;
    }

    public boolean ignoresThrowable() {
        return false;
    }

    public void activateOptions() {
    }

    public boolean isTimeAdded() {
        return this.timeAdded;
    }

    public void setTimeAdded(boolean addTime) {
        this.timeAdded = addTime;
    }
}

