/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.repository;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;

public class PermissionMeta {
    private long id;
    private int type;
    public static final int TYPE_PERMISSION_NONE = 0;
    public static final int TYPE_PERMISSION_READ_ONLY = 1;
    public static final int TYPE_PERMISSION_ADMIN = 2;
    public static final int TYPE_PERMISSION_TRANSFORMATION = 3;
    public static final int TYPE_PERMISSION_JOB = 4;
    public static final int TYPE_PERMISSION_SCHEMA = 5;
    public static final String[] permission_type_desc = new String[]{"-", "READONLY", "ADMIN", "TRANS", "JOB", "SCHEMA"};
    public static final String[] permissionTypeLongDesc = new String[]{"-", "Read only access", "Administrator", "Use transformations", "Use jobs", "Use schema's"};

    public PermissionMeta(int type) {
        this.type = type;
    }

    public PermissionMeta(String stype) {
        this.type = PermissionMeta.getType(stype);
    }

    public PermissionMeta(Repository rep, long id_permission) throws ETLException {
        try {
            Row r = rep.getPermission(id_permission);
            this.setID(id_permission);
            String code = r.searchValue("CODE").getString();
            this.type = PermissionMeta.getType(code);
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("Unable to load permission information from the repository with id_premission=" + id_permission, dbe);
        }
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeDesc() {
        return PermissionMeta.getTypeDesc(this.type);
    }

    public static final String getTypeDesc(int i) {
        if (i < 0 || i >= permission_type_desc.length) {
            return null;
        }
        return permission_type_desc[i];
    }

    public static final int getType(String str) {
        int i;
        for (i = 0; i < permission_type_desc.length; ++i) {
            if (!permission_type_desc[i].equalsIgnoreCase(str)) continue;
            return i;
        }
        for (i = 0; i < permissionTypeLongDesc.length; ++i) {
            if (!permissionTypeLongDesc[i].equalsIgnoreCase(str)) continue;
            return i;
        }
        return 0;
    }

    public long getID() {
        return this.id;
    }

    public void setID(long id) {
        this.id = id;
    }

    public boolean isReadonly() {
        return this.type == 1;
    }

    public boolean isAdministrator() {
        return this.type == 2;
    }

    public boolean useTransformations() {
        return this.type == 3;
    }

    public boolean useJobs() {
        return this.type == 4;
    }

    public boolean useSchemas() {
        return this.type == 5;
    }

    public String toString() {
        return this.getTypeDesc();
    }
}

