/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.schedule.entry.cron.quartz;

import com.kingdee.bos.ctrl.etl.schedule.entry.cron.quartz.ETLQuartzJob;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import com.kingdee.bos.ctrl.etl.util.MethodInvoker;
import java.lang.reflect.InvocationTargetException;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.impl.JobDetailImpl;

public class ETLMethodInvokingJobDetailFactory
extends MethodInvoker {
    private String name;
    private String group = "DEFAULT";
    private String etlName;
    private JobDetail jobDetail;

    public void setName(String name) {
        this.name = name;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setETLName(String etlName) {
        this.etlName = etlName;
    }

    public void afterPropertiesSet() throws ClassNotFoundException, NoSuchMethodException {
        this.prepare();
        this.jobDetail = new JobDetailImpl(this.name != null ? this.name : this.etlName, this.group, MethodInvokingJob.class);
        this.jobDetail.getJobDataMap().put("methodInvoker", (Object)this);
    }

    public Object getObject() {
        return this.jobDetail;
    }

    public Class getObjectType() {
        return this.jobDetail != null ? this.jobDetail.getClass() : JobDetail.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public static class MethodInvokingJob
    extends ETLQuartzJob {
        protected final LogWriter logger = LogWriter.getInstance();
        private MethodInvoker methodInvoker;
        private String errorMessage;

        public void setMethodInvoker(MethodInvoker methodInvoker) {
            this.methodInvoker = methodInvoker;
            this.errorMessage = "Could not invoke method '" + this.methodInvoker.getTargetMethod() + "' on target object [" + this.methodInvoker.getTargetObject() + "]";
        }

        @Override
        protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
            try {
                if (this.methodInvoker == null) {
                    this.methodInvoker = (MethodInvoker)context.getJobDetail().getJobDataMap().get((Object)"methodInvoker");
                }
                this.methodInvoker.invoke();
            }
            catch (InvocationTargetException ex) {
                this.logger.logError(this.errorMessage, ex.getTargetException().getMessage());
                if (ex.getTargetException() instanceof JobExecutionException) {
                    throw (JobExecutionException)ex.getTargetException();
                }
                InvocationTargetException jobEx = ex.getTargetException() instanceof Exception ? (Exception)ex.getTargetException() : ex;
                throw new JobExecutionException(this.errorMessage, (Throwable)jobEx, false);
            }
            catch (Exception ex) {
                this.logger.logError(this.errorMessage, ex.getMessage());
                throw new JobExecutionException(this.errorMessage, (Throwable)ex, false);
            }
        }
    }
}

