/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation;

import com.kingdee.bos.ctrl.etl.base.Result;
import com.kingdee.bos.ctrl.etl.database.DatabaseMeta;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.transformation.StepLoader;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransHopMeta;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;

public class TransHelper {
    static TransHelper instance = new TransHelper();
    private Trans trans = null;
    private TransMeta transMeta = null;
    private DatabaseMeta databaseMeta = null;
    private Connection ctxConnection = null;

    public static TransHelper instance() {
        return instance;
    }

    public void setConnection(Connection con) {
        this.databaseMeta = new DatabaseMeta(con);
        this.ctxConnection = con;
    }

    public void setConnection(String dbMetaName, String dbType, String access, String host, String db, int port, String user, String password) {
        this.databaseMeta = new DatabaseMeta(dbMetaName, dbType, access, host, db, port, user, password);
    }

    public void init(Connection con, String logfilename) throws ETLException {
        this.setLogFilename(logfilename);
        this.setConnection(con);
        this.initStepLoader();
    }

    public void init(String dbMetaName, String dbType, String access, String host, String db, int port, String user, String password, String logfilename) throws ETLException {
        this.setLogFilename(logfilename);
        this.setConnection(dbMetaName, dbType, access, host, db, port, user, password);
        this.initStepLoader();
    }

    public void dispose() {
        this.closeCtxConnection();
    }

    private void closeCtxConnection() {
        if (this.ctxConnection != null) {
            try {
                this.ctxConnection.close();
                this.ctxConnection = null;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public Result execOneLineTrans(String name, List stepMetaList) {
        this.transMeta = new TransMeta();
        this.transMeta.setName(name);
        this.addTransMeta(this.transMeta, stepMetaList);
        LogWriter log = LogWriter.getInstance();
        this.trans = new Trans(log, this.transMeta);
        this.trans.execute(null);
        this.trans.waitUntilFinished();
        return this.trans.getResult();
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setLogFilename(String logfilename) {
        LogWriter.getInstance(logfilename, true, 4);
    }

    private void initStepLoader() throws ETLException {
        StepLoader stloader = StepLoader.getInstance();
        if (!stloader.read()) {
            throw new ETLException("Error loading ETL steps & plugins..");
        }
    }

    public Connection getConnection() throws ETLDatabaseException {
        Connection con = null;
        if (this.databaseMeta != null) {
            con = this.databaseMeta.connect();
        }
        return con;
    }

    private TransHelper() {
    }

    private void addTransMeta(TransMeta transMeta, List stepMetaList) {
        String stepid;
        StepMetaInterface stepMetaInterface;
        StepLoader steploader = StepLoader.getInstance();
        LogWriter log = LogWriter.getInstance();
        StepMeta fromStep = null;
        StepMeta toStep = null;
        Iterator it = stepMetaList.iterator();
        int stepCounter = 1;
        if (it.hasNext()) {
            stepMetaInterface = (StepMetaInterface)it.next();
            stepid = steploader.getStepPluginID(stepMetaInterface);
            fromStep = new StepMeta(log, stepid, "step" + stepCounter++, stepMetaInterface);
            transMeta.addStep(fromStep);
        }
        while (it.hasNext()) {
            stepMetaInterface = (StepMetaInterface)it.next();
            stepid = steploader.getStepPluginID(stepMetaInterface);
            toStep = new StepMeta(log, stepid, "step" + stepCounter++, stepMetaInterface);
            transMeta.addStep(toStep);
            TransHopMeta shi = new TransHopMeta(fromStep, toStep);
            transMeta.addTransHop(shi);
            fromStep = toStep;
        }
    }

    public TransMeta createTransMeta(String name, List stepMetaList) {
        TransMeta transMeta = new TransMeta();
        transMeta.setName(name);
        this.addTransMeta(transMeta, stepMetaList);
        return transMeta;
    }
}

