/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.addsequence;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.base.SQLStatement;
import com.kingdee.bos.ctrl.etl.database.Database;
import com.kingdee.bos.ctrl.etl.database.DatabaseMeta;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.addsequence.AddSequence;
import com.kingdee.bos.ctrl.etl.transformation.step.addsequence.AddSequenceData;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;

public class AddSequenceMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String valuename;
    private boolean useDatabase;
    private DatabaseMeta database;
    private String sequenceName;
    private boolean useCounter;
    private long startAt;
    private long incrementBy;
    private long maxValue;

    public DatabaseMeta getDatabase() {
        return this.database;
    }

    public void setDatabase(DatabaseMeta connection) {
        this.database = connection;
    }

    public long getIncrementBy() {
        return this.incrementBy;
    }

    public void setIncrementBy(long incrementBy) {
        this.incrementBy = incrementBy;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(long maxValue) {
        this.maxValue = maxValue;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public long getStartAt() {
        return this.startAt;
    }

    public void setStartAt(long startAt) {
        this.startAt = startAt;
    }

    public boolean isCounterUsed() {
        return this.useCounter;
    }

    public void setUseCounter(boolean useCounter) {
        this.useCounter = useCounter;
    }

    public boolean isDatabaseUsed() {
        return this.useDatabase;
    }

    public void setUseDatabase(boolean useDatabase) {
        this.useDatabase = useDatabase;
    }

    public String getValuename() {
        return this.valuename;
    }

    public void setValuename(String valuename) {
        this.valuename = valuename;
    }

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    private void readData(Node stepnode, List databases) throws ETLXMLException {
        try {
            this.valuename = XMLHandler.getTagValue(stepnode, "valuename");
            this.useDatabase = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "use_database"));
            String conn = XMLHandler.getTagValue(stepnode, "connection");
            this.database = Const.findDatabase(databases, conn);
            this.sequenceName = XMLHandler.getTagValue(stepnode, "seqname");
            this.useCounter = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "use_counter"));
            this.startAt = Const.toLong(XMLHandler.getTagValue(stepnode, "start_at"), 1L);
            this.incrementBy = Const.toLong(XMLHandler.getTagValue(stepnode, "increment_by"), 1L);
            this.maxValue = Const.toLong(XMLHandler.getTagValue(stepnode, "max_value"), 999999999L);
        }
        catch (Exception e) {
            throw new ETLXMLException("Error loading step info from XML", e);
        }
    }

    @Override
    public void setDefault() {
        this.valuename = "valuename";
        this.useDatabase = false;
        this.sequenceName = "SEQ_";
        this.database = null;
        this.useCounter = true;
        this.startAt = 1L;
        this.incrementBy = 1L;
        this.maxValue = 9999999L;
    }

    @Override
    public Row getFields(Row r, String name, Row info) {
        Row row = r == null ? new Row() : r;
        Value v = new Value(this.valuename, 5);
        v.setLength(9, 0);
        v.setOrigin(name);
        row.addValue(v);
        return row;
    }

    @Override
    public String getXML() {
        String retval = "";
        retval = retval + "      " + XMLHandler.addTagValue("valuename", this.valuename);
        retval = retval + "      " + XMLHandler.addTagValue("use_database", this.useDatabase);
        retval = retval + "      " + XMLHandler.addTagValue("connection", this.database == null ? "" : this.database.getName());
        retval = retval + "      " + XMLHandler.addTagValue("seqname", this.sequenceName);
        retval = retval + "      " + XMLHandler.addTagValue("use_counter", this.useCounter);
        retval = retval + "      " + XMLHandler.addTagValue("start_at", this.startAt);
        retval = retval + "      " + XMLHandler.addTagValue("increment_by", this.incrementBy);
        retval = retval + "      " + XMLHandler.addTagValue("max_value", this.maxValue);
        return retval;
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        try {
            this.valuename = rep.getStepAttributeString(id_step, "valuename");
            this.useDatabase = rep.getStepAttributeBoolean(id_step, "use_database");
            long id_connection = rep.getStepAttributeInteger(id_step, "id_connection");
            this.database = Const.findDatabase(databases, id_connection);
            this.sequenceName = rep.getStepAttributeString(id_step, "seqname");
            this.useCounter = rep.getStepAttributeBoolean(id_step, "use_counter");
            this.startAt = rep.getStepAttributeInteger(id_step, "start_at");
            this.incrementBy = rep.getStepAttributeInteger(id_step, "increment_by");
            this.maxValue = rep.getStepAttributeInteger(id_step, "max_value");
        }
        catch (Exception e) {
            throw new ETLException("Unable to read step information from the repository for id_step=" + id_step, e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "valuename", this.valuename);
            rep.saveStepAttribute(id_transformation, id_step, "use_database", this.useDatabase);
            rep.saveStepAttribute(id_transformation, id_step, "id_connection", this.database == null ? -1.0 : (double)this.database.getID());
            rep.saveStepAttribute(id_transformation, id_step, "seqname", this.sequenceName);
            rep.saveStepAttribute(id_transformation, id_step, "use_counter", this.useCounter);
            rep.saveStepAttribute(id_transformation, id_step, "start_at", this.startAt);
            rep.saveStepAttribute(id_transformation, id_step, "increment_by", this.incrementBy);
            rep.saveStepAttribute(id_transformation, id_step, "max_value", this.maxValue);
            if (this.database != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.database.getID());
            }
        }
        catch (Exception e) {
            throw new ETLException("Unable to save step info to the repository for id_step=" + id_step, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check(List remarks, StepMeta stepMeta, Row prev, String[] input, String[] output, Row info) {
        CheckResult cr;
        if (this.useDatabase) {
            Database db = new Database(this.database);
            try {
                db.connect();
                Value last = db.checkSequence(this.sequenceName);
                cr = last != null ? new CheckResult(1, "Sequence is at value " + last, stepMeta) : new CheckResult(4, "Last value of sequence couldn't be found", stepMeta);
            }
            catch (ETLException e) {
                cr = new CheckResult(4, "Unable to connect to database to verify sequence because of an error: " + Const.CR + e.getMessage(), stepMeta);
            }
            finally {
                db.disconnect();
            }
            remarks.add(cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Step is receiving info from other steps.", stepMeta);
            remarks.add(cr);
        } else {
            cr = new CheckResult(4, "No input received from other steps!", stepMeta);
            remarks.add(cr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLStatement getSQLStatements(TransMeta transMeta, StepMeta stepMeta, Row prev) {
        SQLStatement retval = new SQLStatement(stepMeta.getName(), this.database, null);
        if (this.useDatabase) {
            if (this.database != null) {
                Database db = new Database(this.database);
                try {
                    db.connect();
                    Value last = db.checkSequence(this.sequenceName);
                    if (last == null) {
                        String cr_table = db.getCreateSequenceStatement(this.sequenceName, this.startAt, this.incrementBy, this.maxValue, true);
                        retval.setSQL(cr_table);
                    }
                    retval.setSQL(null);
                }
                catch (ETLException e) {
                    retval.setError("I was unable to connect to the database to verify the status of the table." + Const.CR + e.getMessage());
                }
                finally {
                    db.disconnect();
                }
            } else {
                retval.setError("There is no connection defined in this step.");
            }
        }
        return retval;
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new AddSequence(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new AddSequenceData();
    }
}

