/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.dbproc;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.database.Database;
import com.kingdee.bos.ctrl.etl.database.DatabaseMeta;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.dbproc.DBProc;
import com.kingdee.bos.ctrl.etl.transformation.step.dbproc.DBProcData;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;

public class DBProcMeta
extends BaseStepMeta
implements StepMetaInterface {
    private DatabaseMeta database;
    private String procedure;
    private String[] argument;
    private String[] argumentDirection;
    private int[] argumentType;
    private String resultName;
    private int resultType;

    public String[] getArgument() {
        return this.argument;
    }

    public void setArgument(String[] argument) {
        this.argument = argument;
    }

    public String[] getArgumentDirection() {
        return this.argumentDirection;
    }

    public void setArgumentDirection(String[] argumentDirection) {
        this.argumentDirection = argumentDirection;
    }

    public int[] getArgumentType() {
        return this.argumentType;
    }

    public void setArgumentType(int[] argumentType) {
        this.argumentType = argumentType;
    }

    public DatabaseMeta getDatabase() {
        return this.database;
    }

    public void setDatabase(DatabaseMeta database) {
        this.database = database;
    }

    public String getProcedure() {
        return this.procedure;
    }

    public void setProcedure(String procedure) {
        this.procedure = procedure;
    }

    public String getResultName() {
        return this.resultName;
    }

    public void setResultName(String resultName) {
        this.resultName = resultName;
    }

    public int getResultType() {
        return this.resultType;
    }

    public void setResultType(int resultType) {
        this.resultType = resultType;
    }

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        this.readData(stepnode, databases);
    }

    public void allocate(int nrargs) {
        this.argument = new String[nrargs];
        this.argumentDirection = new String[nrargs];
        this.argumentType = new int[nrargs];
    }

    @Override
    public Object clone() {
        DBProcMeta retval = (DBProcMeta)super.clone();
        int nrargs = this.argument.length;
        retval.allocate(nrargs);
        for (int i = 0; i < nrargs; ++i) {
            retval.argument[i] = this.argument[i];
            retval.argumentDirection[i] = this.argumentDirection[i];
            retval.argumentType[i] = this.argumentType[i];
        }
        return retval;
    }

    private void readData(Node stepnode, List databases) throws ETLXMLException {
        try {
            String con = XMLHandler.getTagValue(stepnode, "connection");
            this.database = Const.findDatabase(databases, con);
            this.procedure = XMLHandler.getTagValue(stepnode, "procedure");
            Node lookup = XMLHandler.getSubNode(stepnode, "lookup");
            int nrargs = XMLHandler.countNodes(lookup, "arg");
            this.allocate(nrargs);
            for (int i = 0; i < nrargs; ++i) {
                Node anode = XMLHandler.getSubNodeByNr(lookup, "arg", i);
                this.argument[i] = XMLHandler.getTagValue(anode, "name");
                this.argumentDirection[i] = XMLHandler.getTagValue(anode, "direction");
                this.argumentType[i] = Value.getType(XMLHandler.getTagValue(anode, "type"));
            }
            this.resultName = XMLHandler.getTagValue(stepnode, "result", "name");
            this.resultType = Value.getType(XMLHandler.getTagValue(stepnode, "result", "type"));
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to read step information from XML", e);
        }
    }

    @Override
    public void setDefault() {
        this.database = null;
        int nrargs = 0;
        this.allocate(nrargs);
        for (int i = 0; i < nrargs; ++i) {
            this.argument[i] = "arg" + i;
            this.argumentDirection[i] = "IN";
            this.argumentType[i] = 1;
        }
        this.resultName = "result";
        this.resultType = 1;
    }

    @Override
    public Row getFields(Row r, String name, Row info) {
        Value v;
        Row row = r == null ? new Row() : r;
        for (int i = 0; i < this.argument.length; ++i) {
            if (!this.argumentDirection[i].equalsIgnoreCase("OUT") && !this.argumentDirection[i].equalsIgnoreCase("INOUT")) continue;
            v = new Value(this.argument[i], this.argumentType[i]);
            v.setOrigin(name);
            row.addValue(v);
        }
        if (this.resultName != null) {
            v = new Value(this.resultName, this.resultType);
            v.setOrigin(name);
            row.addValue(v);
        }
        return row;
    }

    @Override
    public String getXML() {
        String retval = "";
        retval = retval + "    " + XMLHandler.addTagValue("connection", this.database == null ? "" : this.database.getName());
        retval = retval + "    " + XMLHandler.addTagValue("procedure", this.procedure);
        retval = retval + "    <lookup>" + Const.CR;
        for (int i = 0; i < this.argument.length; ++i) {
            retval = retval + "      <arg>" + Const.CR;
            retval = retval + "        " + XMLHandler.addTagValue("name", this.argument[i]);
            retval = retval + "        " + XMLHandler.addTagValue("direction", this.argumentDirection[i]);
            retval = retval + "        " + XMLHandler.addTagValue("type", Value.getTypeDesc(this.argumentType[i]));
            retval = retval + "        </arg>" + Const.CR;
        }
        retval = retval + "      </lookup>" + Const.CR;
        retval = retval + "    <result>" + Const.CR;
        retval = retval + "      " + XMLHandler.addTagValue("name", this.resultName);
        retval = retval + "      " + XMLHandler.addTagValue("type", Value.getTypeDesc(this.resultType));
        retval = retval + "      </result>" + Const.CR;
        return retval;
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        try {
            long id_connection = rep.getStepAttributeInteger(id_step, "id_connection");
            this.database = Const.findDatabase(databases, id_connection);
            this.procedure = rep.getStepAttributeString(id_step, "procedure");
            int nrargs = rep.countNrStepAttributes(id_step, "arg_name");
            this.allocate(nrargs);
            for (int i = 0; i < nrargs; ++i) {
                this.argument[i] = rep.getStepAttributeString(id_step, i, "arg_name");
                this.argumentDirection[i] = rep.getStepAttributeString(id_step, i, "arg_direction");
                this.argumentType[i] = Value.getType(rep.getStepAttributeString(id_step, i, "arg_type"));
            }
            this.resultName = rep.getStepAttributeString(id_step, "result_name");
            this.resultType = Value.getType(rep.getStepAttributeString(id_step, "result_type"));
        }
        catch (Exception e) {
            throw new ETLException("Unexpected error reading step information from the repository", e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "id_connection", this.database == null ? -1.0 : (double)this.database.getID());
            rep.saveStepAttribute(id_transformation, id_step, "procedure", this.procedure);
            for (int i = 0; i < this.argument.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "arg_name", this.argument[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "arg_direction", this.argumentDirection[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "arg_type", Value.getTypeDesc(this.argumentType[i]));
            }
            rep.saveStepAttribute(id_transformation, id_step, "result_name", this.resultName);
            rep.saveStepAttribute(id_transformation, id_step, "result_type", Value.getTypeDesc(this.resultType));
            if (this.database != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.database.getID());
            }
        }
        catch (Exception e) {
            throw new ETLException("Unable to save step information to the repository for id_step=" + id_step, e);
        }
    }

    @Override
    public void check(List remarks, StepMeta stepMeta, Row prev, String[] input, String[] output, Row info) {
        CheckResult cr;
        block10: {
            String error_message = "";
            if (this.database != null) {
                Database db = new Database(this.database);
                try {
                    db.connect();
                    if (prev != null && prev.size() > 0) {
                        boolean first = true;
                        error_message = "";
                        boolean error_found = false;
                        for (int i = 0; i < this.argument.length; ++i) {
                            Value v = prev.searchValue(this.argument[i]);
                            if (v == null) {
                                if (first) {
                                    first = false;
                                    error_message = error_message + "Missing arguments, not found in input from previous steps:" + Const.CR;
                                }
                                error_found = true;
                                error_message = error_message + "\t\t" + this.argument[i] + Const.CR;
                                continue;
                            }
                            if (v.getType() == this.argumentType[i] || v.isNumeric() && Value.isNumeric(this.argumentType[i])) continue;
                            error_found = true;
                            error_message = error_message + "\t\t" + this.argument[i] + " (found but wrong type: " + v.getTypeDesc() + " vs. " + Value.getTypeDesc(this.argumentType[i]) + ")" + Const.CR;
                        }
                        cr = error_found ? new CheckResult(4, error_message, stepMeta) : new CheckResult(1, "All arguments found in the input stream.", stepMeta);
                        remarks.add(cr);
                        break block10;
                    }
                    error_message = "Couldn't read fields from the previous step." + Const.CR;
                    cr = new CheckResult(4, error_message, stepMeta);
                    remarks.add(cr);
                }
                catch (ETLException e) {
                    error_message = "A an error occurred: " + e.getMessage();
                    cr = new CheckResult(4, error_message, stepMeta);
                    remarks.add(cr);
                }
            } else {
                error_message = "Please select or create a connection!";
                cr = new CheckResult(4, error_message, stepMeta);
                remarks.add(cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Step is receiving info from other steps.", stepMeta);
            remarks.add(cr);
        } else {
            cr = new CheckResult(4, "No input received from other steps!", stepMeta);
            remarks.add(cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new DBProc(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new DBProcData();
    }
}

