/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.excelinput;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.excelinput.ExcelInputData;
import com.kingdee.bos.ctrl.etl.transformation.step.excelinput.ExcelInputMeta;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.io.File;
import jxl.BooleanCell;
import jxl.Cell;
import jxl.CellType;
import jxl.DateCell;
import jxl.LabelCell;
import jxl.NumberCell;
import jxl.Sheet;
import jxl.Workbook;

public class ExcelInput
extends BaseStep
implements StepInterface {
    private ExcelInputMeta meta;
    private ExcelInputData data;

    public ExcelInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private Row fillRow(Row baserow, Sheet sheet, Cell[] line, int startcolumn, int rownr) {
        this.debug = "fillRow start";
        Row r = new Row(baserow);
        for (int i = startcolumn; i < line.length && i - startcolumn < r.size(); ++i) {
            this.debug = "get cell #" + i;
            Cell cell = line[i];
            int rowcolumn = i - startcolumn;
            this.debug = "Rowcolumn = " + rowcolumn;
            Value v = r.getValue(rowcolumn);
            this.debug = "Value v = " + v;
            if (cell.getType().equals(CellType.BOOLEAN)) {
                v.setValue(((BooleanCell)cell).getValue());
            } else if (cell.getType().equals(CellType.DATE)) {
                v.setValue(((DateCell)cell).getDate());
            } else if (cell.getType().equals(CellType.LABEL)) {
                v.setValue(((LabelCell)cell).getString());
                switch (this.meta.getFieldTrimType()[rowcolumn]) {
                    case 1: {
                        v.ltrim();
                        break;
                    }
                    case 2: {
                        v.rtrim();
                        break;
                    }
                    case 3: {
                        v.trim();
                        break;
                    }
                }
            } else if (cell.getType().equals(CellType.NUMBER)) {
                v.setValue(((NumberCell)cell).getValue());
            } else {
                this.logDetailed("Unknown type : " + cell.getType().toString() + " : [" + cell.getContents() + "]");
                v.setNull();
            }
            v.setType(this.meta.getFieldType()[rowcolumn]);
            v.setLength(this.meta.getFieldLength()[rowcolumn], this.meta.getFieldPrecision()[rowcolumn]);
        }
        this.debug = "filename";
        if (this.meta.getFileField() != null && this.meta.getFileField().length() > 0) {
            Value value = new Value(this.meta.getFileField(), this.data.files[this.data.filenr]);
            value.setLength(this.data.maxfilelength);
            r.addValue(value);
        }
        this.debug = "sheetname";
        if (this.meta.getSheetField() != null && this.meta.getSheetField().length() > 0) {
            Value value = new Value(this.meta.getSheetField(), sheet.getName());
            value.setLength(this.data.maxsheetlength);
            r.addValue(value);
        }
        this.debug = "rownumber";
        if (this.meta.getRowNumberField() != null && this.meta.getRowNumberField().length() > 0) {
            Value value = new Value(this.meta.getRowNumberField(), this.linesWritten + 1L);
            r.addValue(value);
        }
        this.debug = "end of fillRow";
        return r;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        this.meta = (ExcelInputMeta)smi;
        this.data = (ExcelInputData)sdi;
        if (this.data.filenr >= this.data.files.length) {
            this.logDetailed("No more files to be processes! (" + this.data.filenr + " files done)");
            this.setOutputDone();
            return false;
        }
        Row r = this.getRowFromWorkbooks();
        if (r != null) {
            if (!r.isIgnored()) {
                if (this.data.previousRow != null) {
                    for (int i = 0; i < this.meta.getFieldRepeat().length; ++i) {
                        Value field = r.getValue(i);
                        if (!field.isNull() || !this.meta.getFieldRepeat()[i]) continue;
                        Value repeat = this.data.previousRow.getValue(i);
                        field.setValue(repeat);
                    }
                }
                this.data.previousRow = r;
                this.putRow(r);
            }
            return true;
        }
        return false;
    }

    public Row getRowFromWorkbooks() throws ETLException {
        this.debug = "processRow()";
        Row retval = new Row();
        retval.setIgnore();
        try {
            if (this.data.workbook == null) {
                this.debug = "open workbook #" + this.data.filenr + " : " + this.data.files[this.data.filenr];
                this.logDetailed("Opening workbook #" + this.data.filenr + " : " + this.data.files[this.data.filenr]);
                this.data.workbook = Workbook.getWorkbook((File)new File(this.data.files[this.data.filenr]));
                this.data.sheetnr = 0;
            }
            boolean nextsheet = false;
            this.debug = "Get sheet #" + this.data.filenr + "." + this.data.sheetnr;
            this.logDetailed(this.debug);
            Sheet sheet = this.data.workbook.getSheet(this.meta.getSheetName()[this.data.sheetnr]);
            if (sheet != null) {
                if (this.data.rownr < 0) {
                    this.data.rownr = this.meta.getStartRow()[this.data.sheetnr];
                    if (this.meta.startsWithHeader()) {
                        ++this.data.rownr;
                    }
                    this.debug = "startrow = " + this.data.rownr;
                }
                this.data.colnr = this.meta.getStartColumn()[this.data.sheetnr];
                this.debug = "startcol = " + this.data.colnr;
                try {
                    this.debug = "Get line #" + this.data.rownr + " from sheet #" + this.data.filenr + "." + this.data.sheetnr;
                    this.logRowlevel(this.debug);
                    Cell[] line = sheet.getRow(this.data.rownr);
                    this.logRowlevel("Read line with " + line.length + " cells");
                    Row r = this.fillRow(this.data.row, sheet, line, this.data.colnr, this.data.rownr);
                    this.logRowlevel("Converted line to row #" + this.data.rownr + " : " + r);
                    ++this.data.rownr;
                    if (line.length > 0 || !this.meta.ignoreEmptyRows()) {
                        retval = r;
                    }
                    if (line.length == 0 && this.meta.stopOnEmpty()) {
                        nextsheet = true;
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.logRowlevel("Out of index error: move to next sheet! (" + this.debug + ")");
                    nextsheet = true;
                }
            } else {
                nextsheet = true;
            }
            if (nextsheet) {
                ++this.data.sheetnr;
                this.data.rownr = -1;
                this.data.previousRow = null;
                if (this.data.sheetnr >= this.meta.getSheetName().length) {
                    this.data.workbook.close();
                    this.data.workbook = null;
                    ++this.data.filenr;
                }
            }
        }
        catch (Exception e) {
            this.logError("Error processing row in [" + this.debug + "] from Excel file [" + this.data.files[this.data.filenr] + "] : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
            return null;
        }
        return retval;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ExcelInputMeta)smi;
        this.data = (ExcelInputData)sdi;
        if (super.init(smi, sdi)) {
            this.data.files = this.meta.getFiles();
            if (this.data.files != null && this.data.files.length > 0) {
                this.data.row = this.meta.getEmptyFields();
                if (this.data.row.size() > 0) {
                    int i;
                    this.data.maxfilelength = -1;
                    for (i = 0; i < this.data.files.length; ++i) {
                        if (this.data.files[i].length() <= this.data.maxfilelength) continue;
                        this.data.maxfilelength = this.data.files[i].length();
                    }
                    this.data.maxsheetlength = -1;
                    for (i = 0; i < this.meta.getSheetName().length; ++i) {
                        if (this.meta.getSheetName()[i].length() <= this.data.maxsheetlength) continue;
                        this.data.maxsheetlength = this.meta.getSheetName()[i].length();
                    }
                    return true;
                }
                this.logError("No input fields defined!");
            } else {
                this.logError("No file specified! Stop processing.");
            }
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ExcelInputMeta)smi;
        this.data = (ExcelInputData)sdi;
        if (this.data.workbook != null) {
            this.data.workbook.close();
        }
        super.dispose(smi, sdi);
    }

    @Override
    public void run() {
        try {
            this.logBasic("Starting to run...");
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error in '" + this.debug + "' : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
        }
    }
}

