/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.groupby;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLFileException;
import com.kingdee.bos.ctrl.etl.exception.ETLValueException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.groupby.GroupByData;
import com.kingdee.bos.ctrl.etl.transformation.step.groupby.GroupByMeta;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;

public class GroupBy
extends BaseStep
implements StepInterface {
    private GroupByMeta meta = (GroupByMeta)this.getStepMeta().getStepMetaInterface();
    private GroupByData data;

    public GroupBy(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.data = (GroupByData)stepDataInterface;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        this.debug = "processRow";
        Row r = this.getRow();
        if (r == null) {
            if (this.meta.passAllRows()) {
                if (this.data.previous != null) {
                    this.calcAggregate(this.data.previous);
                    this.addToBuffer(this.data.previous);
                }
                this.data.groupResult = this.getAggregateResult();
                Row row = this.getRowFromBuffer();
                while (row != null) {
                    row.addRow(this.data.groupResult);
                    this.putRow(row);
                    row = this.getRowFromBuffer();
                }
                this.closeInput();
            } else if (this.data.previous != null) {
                this.calcAggregate(this.data.previous);
                Row result = this.buildResult(this.data.previous);
                this.putRow(result);
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            int i;
            this.data.counts = new long[this.meta.getSubjectField().length];
            this.data.subjectnrs = new int[this.meta.getSubjectField().length];
            for (i = 0; i < this.meta.getSubjectField().length; ++i) {
                this.data.subjectnrs[i] = r.searchValueIndex(this.meta.getSubjectField()[i]);
                if (this.data.subjectnrs[i] >= 0) continue;
                this.logError("Aggregate subject field [" + this.meta.getSubjectField()[i] + "] couldn't be found!");
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
            this.data.groupnrs = new int[this.meta.getGroupField().length];
            for (i = 0; i < this.meta.getGroupField().length; ++i) {
                this.data.groupnrs[i] = r.searchValueIndex(this.meta.getGroupField()[i]);
                if (this.data.groupnrs[i] >= 0) continue;
                this.logError("Grouping field [" + this.meta.getGroupField()[i] + "] couldn't be found!");
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
            this.data.previous = new Row(r);
            this.newAggregate(r);
            this.first = false;
        } else {
            this.calcAggregate(this.data.previous);
            if (this.meta.passAllRows()) {
                this.addToBuffer(this.data.previous);
            }
        }
        if (!this.sameGroup(this.data.previous, r)) {
            if (this.meta.passAllRows()) {
                this.closeOutput();
                this.data.groupResult = this.getAggregateResult();
                Row row = this.getRowFromBuffer();
                while (row != null) {
                    row.addRow(this.data.groupResult);
                    this.putRow(row);
                    row = this.getRowFromBuffer();
                }
                this.closeInput();
            } else {
                Row result = this.buildResult(this.data.previous);
                this.putRow(result);
            }
            this.newAggregate(r);
        }
        this.data.previous = new Row(r);
        if (this.linesRead > 0L && this.linesRead % 5000L == 0L) {
            this.logBasic("Linenr " + this.linesRead);
        }
        return true;
    }

    private boolean sameGroup(Row previous, Row r) {
        this.debug = "sameGroup";
        for (int i = 0; i < this.data.groupnrs.length; ++i) {
            Value curr;
            Value prev = previous.getValue(this.data.groupnrs[i]);
            if (prev.equals(curr = r.getValue(this.data.groupnrs[i]))) continue;
            return false;
        }
        return true;
    }

    private void calcAggregate(Row r) {
        this.debug = "calcAggregate start";
        block8: for (int i = 0; i < this.data.subjectnrs.length; ++i) {
            this.debug = "calcAggregate start loop";
            Value subj = r.getValue(this.data.subjectnrs[i]);
            Value value = this.data.agg.getValue(i);
            this.debug = "calcAggregate switch";
            switch (this.meta.getAggregateType()[i]) {
                case 1: {
                    value.plus(subj);
                    continue block8;
                }
                case 2: {
                    value.plus(subj);
                    int n = i;
                    this.data.counts[n] = this.data.counts[n] + 1L;
                    continue block8;
                }
                case 5: {
                    int n = i;
                    this.data.counts[n] = this.data.counts[n] + 1L;
                    continue block8;
                }
                case 3: {
                    if (subj.compare(value) >= 0) continue block8;
                    value.setValue(subj);
                    continue block8;
                }
                case 4: {
                    if (subj.compare(value) <= 0) continue block8;
                    value.setValue(subj);
                    continue block8;
                }
                case 6: {
                    if (subj.isNull()) continue block8;
                    if (value.getStringLength() > 0) {
                        value.setValue(value.getString() + ", ");
                    }
                    value.setValue(value.getString() + subj.getString());
                    continue block8;
                }
            }
        }
        this.debug = "calcAggregate end";
    }

    private void newAggregate(Row r) {
        int i;
        this.debug = "newAggregate";
        for (i = 0; i < this.data.counts.length; ++i) {
            this.data.counts[i] = 0L;
        }
        this.data.agg = new Row();
        for (i = 0; i < this.data.subjectnrs.length; ++i) {
            Value subj = r.getValue(this.data.subjectnrs[i]);
            Value v = null;
            block0 : switch (this.meta.getAggregateType()[i]) {
                case 1: 
                case 2: 
                case 5: {
                    v = new Value(this.meta.getAggregateField()[i], subj.isNumeric() ? subj.getType() : 1);
                    switch (subj.getType()) {
                        case 6: {
                            v.setValue(new BigDecimal(0.0));
                            break block0;
                        }
                        case 5: {
                            v.setValue(0L);
                            break block0;
                        }
                    }
                    v.setValue(0.0);
                    break;
                }
                case 3: 
                case 4: {
                    v = new Value(this.meta.getAggregateField()[i], subj.getType());
                    v.setValue(subj);
                    break;
                }
                case 6: {
                    v = new Value(this.meta.getAggregateField()[i], 2);
                    v.setValue("");
                    break;
                }
            }
            if (this.meta.getAggregateType()[i] != 5 && v != null) {
                v.setLength(subj.getLength(), subj.getPrecision());
            }
            if (v == null) continue;
            this.data.agg.addValue(v);
        }
    }

    private Row buildResult(Row r) throws ETLValueException {
        this.debug = "buildResult";
        Row result = new Row();
        this.debug = "buildResult 1";
        for (int i = 0; i < this.data.groupnrs.length; ++i) {
            Value gr = r.getValue(this.data.groupnrs[i]);
            result.addValue(gr);
        }
        this.debug = "buildResult 2";
        result.addRow(this.getAggregateResult());
        this.debug = "buildResult end";
        return result;
    }

    private Row getAggregateResult() throws ETLValueException {
        Row result = new Row();
        for (int i = 0; i < this.data.subjectnrs.length; ++i) {
            Value ag = this.data.agg.getValue(i);
            switch (this.meta.getAggregateType()[i]) {
                case 1: {
                    break;
                }
                case 2: {
                    ag.divide(new Value("c", this.data.counts[i]));
                    break;
                }
                case 5: {
                    ag.setValue(this.data.counts[i]);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
            }
            result.addValue(ag);
        }
        return result;
    }

    private void addToBuffer(Row row) throws ETLFileException {
        this.data.bufferList.add(row);
        if (this.data.bufferList.size() > 5000) {
            if (this.data.rowsOnFile == 0) {
                try {
                    this.data.tempFile = File.createTempFile(this.meta.getPrefix(), ".tmp", new File(FilenameUtils.normalize((String)Const.replEnv(this.meta.getDirectory()))));
                    this.data.fos = new FileOutputStream(this.data.tempFile);
                    this.data.dos = new DataOutputStream(this.data.fos);
                    this.data.firstRead = true;
                }
                catch (IOException e) {
                    throw new ETLFileException("Unable to create temporary file", e);
                }
            }
            Row oldest = (Row)this.data.bufferList.get(0);
            oldest.write(this.data.dos);
            this.data.bufferList.remove(0);
            ++this.data.rowsOnFile;
        }
    }

    private Row getRowFromBuffer() throws ETLFileException {
        if (this.data.rowsOnFile > 0) {
            if (this.data.firstRead) {
                try {
                    this.data.fis = new FileInputStream(this.data.tempFile);
                    this.data.dis = new DataInputStream(this.data.fis);
                    this.data.firstRead = false;
                }
                catch (IOException e) {
                    throw new ETLFileException("Unable to read back row from temporary file!", e);
                }
            }
            Row row = new Row(this.data.dis);
            --this.data.rowsOnFile;
            return row;
        }
        if (this.data.bufferList.size() > 0) {
            Row row = (Row)this.data.bufferList.get(0);
            this.data.bufferList.remove(0);
            return row;
        }
        return null;
    }

    private void closeOutput() throws ETLFileException {
        try {
            if (this.data.dos != null) {
                this.data.dos.close();
                this.data.dos = null;
            }
            if (this.data.fos != null) {
                this.data.fos.close();
                this.data.fos = null;
            }
            this.data.firstRead = true;
        }
        catch (IOException e) {
            throw new ETLFileException("Unable to close input stream!", e);
        }
    }

    private void closeInput() throws ETLFileException {
        try {
            if (this.data.fis != null) {
                this.data.fis.close();
                this.data.fis = null;
            }
            if (this.data.dis != null) {
                this.data.dis.close();
                this.data.dis = null;
            }
        }
        catch (IOException e) {
            throw new ETLFileException("Unable to close input stream!", e);
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (GroupByMeta)smi;
        this.data = (GroupByData)sdi;
        if (super.init(smi, sdi)) {
            this.data.bufferList = new ArrayList();
            this.data.rowsOnFile = 0;
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        try {
            this.logBasic("Starting to run...");
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error in '" + this.debug + "' : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            if (this.data.tempFile != null) {
                this.data.tempFile.delete();
            }
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
        }
    }
}

