/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.joinrows;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.base.RowSet;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLFileException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.joinrows.JoinRowsData;
import com.kingdee.bos.ctrl.etl.transformation.step.joinrows.JoinRowsMeta;
import com.kingdee.bos.ctrl.etl.util.Const;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;

public class JoinRows
extends BaseStep
implements StepInterface {
    private JoinRowsMeta meta;
    private JoinRowsData data;

    public JoinRows(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (JoinRowsMeta)smi;
        this.data = (JoinRowsData)sdi;
        if (super.init(smi, sdi)) {
            try {
                int i;
                this.data.caching = true;
                this.data.filenr = 1;
                for (i = 0; i < this.inputRowSets.size(); ++i) {
                    RowSet rs = (RowSet)this.inputRowSets.get(i);
                    if (!rs.getOriginStepName().equalsIgnoreCase(this.meta.getMainStepname())) continue;
                    RowSet zero = (RowSet)this.inputRowSets.get(0);
                    this.inputRowSets.set(0, rs);
                    this.inputRowSets.set(i, zero);
                }
                this.data.file = new File[this.inputRowSets.size()];
                this.data.fileInputStream = new FileInputStream[this.inputRowSets.size()];
                this.data.dataInputStream = new DataInputStream[this.inputRowSets.size()];
                this.data.size = new int[this.inputRowSets.size()];
                this.data.row = new Row[this.inputRowSets.size()];
                this.data.joinrow = new Row[this.inputRowSets.size()];
                this.data.rs = new RowSet[this.inputRowSets.size()];
                this.data.cache = new ArrayList[this.inputRowSets.size()];
                this.data.position = new int[this.inputRowSets.size()];
                this.data.fileOutputStream = new FileOutputStream[this.inputRowSets.size()];
                this.data.dataOutputStream = new DataOutputStream[this.inputRowSets.size()];
                this.data.restart = new boolean[this.inputRowSets.size()];
                for (i = 1; i < this.inputRowSets.size(); ++i) {
                    String directoryName = Const.replEnv(this.meta.getDirectory());
                    this.data.file[i] = File.createTempFile(this.meta.getPrefix(), ".tmp", new File(FilenameUtils.normalize((String)directoryName)));
                    this.data.file[i].deleteOnExit();
                    this.data.size[i] = 0;
                    this.data.rs[i] = (RowSet)this.inputRowSets.get(i);
                    this.data.cache[i] = null;
                    this.data.row[i] = null;
                    this.data.position[i] = 0;
                    this.data.dataInputStream[i] = null;
                    this.data.dataOutputStream[i] = null;
                    this.data.joinrow[i] = null;
                    this.data.restart[i] = false;
                }
                return true;
            }
            catch (IOException e) {
                this.logError("Error creating temporary file(s) : " + e.toString());
            }
        }
        return false;
    }

    public Row getRowData(int filenr) {
        this.data.restart[filenr] = false;
        Row r = null;
        if (filenr == 0) {
            this.debug = "Get row from rowset #" + filenr;
            r = this.getRowFrom(0);
            this.logRowlevel("Read row from stream #0 : " + (r == null ? "<null>" : r.toString()));
        } else if (this.data.cache[filenr] == null) {
            this.debug = "Get row from file #" + filenr;
            if (this.data.dataInputStream[filenr] == null) {
                try {
                    this.debug = "Open file input stream #" + filenr;
                    this.data.fileInputStream[filenr] = new FileInputStream(this.data.file[filenr]);
                    this.debug = "Open data input stream #" + filenr;
                    this.data.dataInputStream[filenr] = new DataInputStream(this.data.fileInputStream[filenr]);
                }
                catch (FileNotFoundException fnfe) {
                    this.logError("Unable to find/open temporary file [" + this.data.file[filenr] + "] : " + fnfe.toString());
                    this.setErrors(1L);
                    this.stopAll();
                    return null;
                }
            }
            this.debug = "Read row from the data input stream #" + filenr;
            if (this.data.size[filenr] == 0) {
                this.logBasic("No rows coming from step [" + this.data.rs[filenr].getOriginStepName() + "]");
                return null;
            }
            try {
                r = new Row(this.data.dataInputStream[filenr], this.data.row[filenr].size(), this.data.row[filenr]);
            }
            catch (ETLFileException e) {
                this.logError("Unable to read data from temporary file #" + filenr + " [" + this.data.file[filenr] + "]");
                this.setErrors(1L);
                this.stopAll();
                return null;
            }
            this.logRowlevel("Read row from file #" + filenr + " : " + r);
            int n = filenr;
            this.data.position[n] = this.data.position[n] + 1;
            if (this.data.position[filenr] >= this.data.size[filenr]) {
                this.debug = "Close stream #" + filenr;
                try {
                    this.data.dataInputStream[filenr].close();
                    this.data.fileInputStream[filenr].close();
                    this.data.dataInputStream[filenr] = null;
                    this.data.fileInputStream[filenr] = null;
                    this.data.position[filenr] = 0;
                    this.data.restart[filenr] = true;
                }
                catch (IOException ioe) {
                    this.logError("Unable to close input stream to file [" + this.data.file[filenr] + "] : " + ioe.toString());
                    this.setErrors(1L);
                    this.stopAll();
                    return null;
                }
            }
        } else {
            this.debug = "Get row from cache #" + filenr + " size=" + this.data.cache[filenr].size();
            if (this.data.size[filenr] == 0) {
                this.logBasic("No rows coming from step [" + this.data.rs[filenr].getOriginStepName() + "]");
                return null;
            }
            r = (Row)this.data.cache[filenr].get(this.data.position[this.data.filenr]);
            int n = filenr;
            this.data.position[n] = this.data.position[n] + 1;
            if (this.data.position[filenr] >= this.data.size[filenr]) {
                this.debug = "Position=0, restart=true for filenr=" + filenr;
                this.data.position[filenr] = 0;
                this.data.restart[filenr] = true;
            }
        }
        return r;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        this.meta = (JoinRowsMeta)smi;
        this.data = (JoinRowsData)sdi;
        this.debug = "data.caching=" + this.data.caching;
        if (this.data.caching) {
            if (this.data.filenr >= this.data.file.length) {
                this.data.caching = false;
                this.data.filenr = 0;
                return true;
            }
            if (this.data.dataOutputStream[this.data.filenr] == null) {
                this.debug = "Opening file outputstream #" + this.data.filenr;
                try {
                    this.debug = "Opening file outputstream #" + this.data.filenr + " file==null?" + (this.data.file[this.data.filenr] == null);
                    this.data.fileOutputStream[this.data.filenr] = new FileOutputStream(this.data.file[this.data.filenr]);
                    this.debug = "Opening data outputstream #" + this.data.filenr;
                    this.data.dataOutputStream[this.data.filenr] = new DataOutputStream(this.data.fileOutputStream[this.data.filenr]);
                }
                catch (FileNotFoundException fnfe) {
                    this.logError("Unable to open outputstream to temporary file [" + this.data.file[this.data.filenr].toString() + "] : " + fnfe.toString());
                    this.stopAll();
                    this.setErrors(1L);
                    return false;
                }
            }
            String fromStep = this.data.rs[this.data.filenr].getOriginStepName();
            this.debug = "Get row from step [" + fromStep + "]";
            Row r = this.getRowFrom(fromStep);
            if (r != null) {
                if (this.data.row[this.data.filenr] == null) {
                    this.data.row[this.data.filenr] = new Row(r);
                }
                this.debug = "Write the data to temp file #" + this.data.filenr;
                r.writeData(this.data.dataOutputStream[this.data.filenr]);
                int n = this.data.filenr;
                this.data.size[n] = this.data.size[n] + 1;
                this.logRowlevel(r.toString());
                if (this.data.size[this.data.filenr] <= this.meta.getCacheSize()) {
                    if (this.data.cache[this.data.filenr] == null) {
                        this.data.cache[this.data.filenr] = new ArrayList();
                    }
                    this.data.cache[this.data.filenr].add(r);
                } else {
                    this.logDetailed("More then " + this.meta.getCacheSize() + " rows found: clearing cache from step [" + this.data.rs[this.data.filenr].getOriginStepName() + "]");
                    this.data.cache[this.data.filenr] = null;
                }
            } else {
                this.debug = "Close outputstream #" + this.data.filenr;
                try {
                    this.data.dataOutputStream[this.data.filenr].close();
                    this.data.fileOutputStream[this.data.filenr].close();
                    this.data.dataOutputStream[this.data.filenr] = null;
                    this.data.fileOutputStream[this.data.filenr] = null;
                }
                catch (IOException ioe) {
                    this.logError("Error closing outputstream #" + this.data.filenr + " : [" + this.data.file[this.data.filenr].toString() + "] : " + ioe.toString());
                }
                ++this.data.filenr;
            }
        } else {
            this.data.joinrow[this.data.filenr] = this.getRowData(this.data.filenr);
            if (this.data.joinrow[this.data.filenr] == null) {
                this.setOutputDone();
                return false;
            }
            if (this.data.filenr >= this.data.file.length - 1) {
                this.debug = "Stich together #" + this.data.filenr;
                Row sum = new Row();
                for (int i = 0; i <= this.data.filenr; ++i) {
                    sum.addRow(this.data.joinrow[i]);
                }
                if (this.meta.getCondition() != null && !this.meta.getCondition().isEmpty()) {
                    if (this.meta.getCondition().evaluate(sum)) {
                        this.putRow(sum);
                    }
                } else {
                    this.putRow(sum);
                }
                while (this.data.restart[this.data.filenr]) {
                    this.debug = "Go back to file #" + (this.data.filenr - 1);
                    --this.data.filenr;
                }
            } else {
                ++this.data.filenr;
            }
        }
        return true;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (JoinRowsMeta)smi;
        this.data = (JoinRowsData)sdi;
        for (int i = 1; i < this.data.file.length; ++i) {
            this.data.file[i].delete();
        }
        super.dispose(this.meta, this.data);
    }

    @Override
    public void run() {
        try {
            this.logBasic("Starting to run...");
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error in '" + this.debug + "' : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
        }
    }
}

