/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.mappinginput;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLStepException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.mappinginput.MappingInput;
import com.kingdee.bos.ctrl.etl.transformation.step.mappinginput.MappingInputData;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;

public class MappingInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String[] fieldName;
    private int[] fieldType;
    private int[] fieldLength;
    private int[] fieldPrecision;

    public int[] getFieldLength() {
        return this.fieldLength;
    }

    public void setFieldLength(int[] fieldLength) {
        this.fieldLength = fieldLength;
    }

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public int[] getFieldPrecision() {
        return this.fieldPrecision;
    }

    public void setFieldPrecision(int[] fieldPrecision) {
        this.fieldPrecision = fieldPrecision;
    }

    public int[] getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(int[] fieldType) {
        this.fieldType = fieldType;
    }

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        MappingInputMeta retval = (MappingInputMeta)super.clone();
        int nrfields = this.fieldName.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.fieldName[i] = this.fieldName[i];
            retval.fieldType[i] = this.fieldType[i];
            this.fieldLength[i] = this.fieldLength[i];
            this.fieldPrecision[i] = this.fieldPrecision[i];
        }
        return retval;
    }

    public void allocate(int nrfields) {
        this.fieldName = new String[nrfields];
        this.fieldType = new int[nrfields];
        this.fieldLength = new int[nrfields];
        this.fieldPrecision = new int[nrfields];
    }

    private void readData(Node stepnode) throws ETLXMLException {
        try {
            Node fields = XMLHandler.getSubNode(stepnode, "fields");
            int nrfields = XMLHandler.countNodes(fields, "field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr(fields, "field", i);
                this.fieldName[i] = XMLHandler.getTagValue(fnode, "name");
                this.fieldType[i] = Value.getType(XMLHandler.getTagValue(fnode, "type"));
                String slength = XMLHandler.getTagValue(fnode, "length");
                String sprecision = XMLHandler.getTagValue(fnode, "precision");
                this.fieldLength[i] = Const.toInt(slength, -1);
                this.fieldPrecision[i] = Const.toInt(sprecision, -1);
            }
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load step info from XML", e);
        }
    }

    @Override
    public String getXML() {
        String retval = "";
        retval = retval + "    <fields>" + Const.CR;
        for (int i = 0; i < this.fieldName.length; ++i) {
            if (this.fieldName[i] == null || this.fieldName[i].length() == 0) continue;
            retval = retval + "      <field>" + Const.CR;
            retval = retval + "        " + XMLHandler.addTagValue("name", this.fieldName[i]);
            retval = retval + "        " + XMLHandler.addTagValue("type", Value.getTypeDesc(this.fieldType[i]));
            retval = retval + "        " + XMLHandler.addTagValue("length", this.fieldLength[i]);
            retval = retval + "        " + XMLHandler.addTagValue("precision", this.fieldPrecision[i]);
            retval = retval + "        </field>" + Const.CR;
        }
        retval = retval + "      </fields>" + Const.CR;
        return retval;
    }

    @Override
    public void setDefault() {
        int nrfields = 0;
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            this.fieldName[i] = "field" + i;
            this.fieldType[i] = 2;
            this.fieldLength[i] = 30;
            this.fieldPrecision[i] = -1;
        }
    }

    @Override
    public Row getFields(Row row, String name, Row info) throws ETLStepException {
        for (int i = 0; i < this.fieldName.length; ++i) {
            if (this.fieldName[i] == null || this.fieldName[i].length() == 0) continue;
            Value v = new Value(this.fieldName[i], this.fieldType[i]);
            if (v.getType() == 0) {
                v.setType(2);
            }
            v.setLength(this.fieldLength[i], this.fieldPrecision[i]);
            v.setOrigin(name);
            row.addValue(v);
        }
        return row;
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        try {
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.fieldName[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.fieldType[i] = Value.getType(rep.getStepAttributeString(id_step, i, "field_type"));
                this.fieldLength[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_length");
                this.fieldPrecision[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_precision");
            }
        }
        catch (Exception e) {
            throw new ETLException("Unexpected error reading step information from the repository", e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        try {
            for (int i = 0; i < this.fieldName.length; ++i) {
                if (this.fieldName[i] == null || this.fieldName[i].length() == 0) continue;
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", this.fieldName[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_type", Value.getTypeDesc(this.fieldType[i]));
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_length", this.fieldLength[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_precision", this.fieldPrecision[i]);
            }
        }
        catch (Exception e) {
            throw new ETLException("Unable to save step information to the repository for id_step=" + id_step, e);
        }
    }

    @Override
    public void check(List remarks, StepMeta stepinfo, Row prev, String[] input, String[] output, Row info) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(1, "Not receiving any fields from previous steps!", stepinfo);
            remarks.add(cr);
        } else {
            cr = new CheckResult(4, "Step is connected to previous one, receiving " + prev.size() + " fields", stepinfo);
            remarks.add(cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(4, "Step is receiving info from other steps.", stepinfo);
            remarks.add(cr);
        } else {
            cr = new CheckResult(1, "No input received from other steps!", stepinfo);
            remarks.add(cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new MappingInput(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new MappingInputData();
    }
}

