/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.mergerows;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLStepException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.mergerows.MergeRows;
import com.kingdee.bos.ctrl.etl.transformation.step.mergerows.MergeRowsData;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;

public class MergeRowsMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String referenceStepName;
    private StepMeta referenceStepMeta;
    private String compareStepName;
    private StepMeta compareStepMeta;
    private String flagField;
    private String[] keyFields;
    private String[] valueFields;

    public String[] getKeyFields() {
        return this.keyFields;
    }

    public void setKeyFields(String[] keyFields) {
        this.keyFields = keyFields;
    }

    public String[] getValueFields() {
        return this.valueFields;
    }

    public void setValueFields(String[] valueFields) {
        this.valueFields = valueFields;
    }

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        this.readData(stepnode);
    }

    public String getCompareStepName() {
        if (this.compareStepMeta != null && this.compareStepMeta.getName() != null && this.compareStepMeta.getName().length() > 0) {
            return this.compareStepMeta.getName();
        }
        return null;
    }

    public String getReferenceStepName() {
        if (this.referenceStepMeta != null && this.referenceStepMeta.getName() != null && this.referenceStepMeta.getName().length() > 0) {
            return this.referenceStepMeta.getName();
        }
        return null;
    }

    public void setCompareStepName(String sendFalseStepname) {
        this.compareStepName = sendFalseStepname;
    }

    public void setReferenceStepName(String sendTrueStepname) {
        this.referenceStepName = sendTrueStepname;
    }

    public StepMeta getCompareStepMeta() {
        return this.compareStepMeta;
    }

    public StepMeta getReferenceStepMeta() {
        return this.referenceStepMeta;
    }

    public void setCompareStepMeta(StepMeta sendFalseStep) {
        this.compareStepMeta = sendFalseStep;
    }

    public void setReferenceStepMeta(StepMeta sendTrueStep) {
        this.referenceStepMeta = sendTrueStep;
    }

    public String getFlagField() {
        return this.flagField;
    }

    public void setFlagField(String flagField) {
        this.flagField = flagField;
    }

    public void allocate(int nrKeys, int nrValues) {
        this.keyFields = new String[nrKeys];
        this.valueFields = new String[nrValues];
    }

    @Override
    public Object clone() {
        MergeRowsMeta retval = (MergeRowsMeta)super.clone();
        return retval;
    }

    @Override
    public String getXML() {
        int i;
        String retval = "";
        retval = retval + "    <keys>" + Const.CR;
        for (i = 0; i < this.keyFields.length; ++i) {
            retval = retval + "      " + XMLHandler.addTagValue("key", this.keyFields[i]);
        }
        retval = retval + "    </keys>" + Const.CR;
        retval = retval + "    <values>" + Const.CR;
        for (i = 0; i < this.valueFields.length; ++i) {
            retval = retval + "      " + XMLHandler.addTagValue("value", this.valueFields[i]);
        }
        retval = retval + "    </values>" + Const.CR;
        retval = retval + XMLHandler.addTagValue("flag_field", this.flagField);
        retval = retval + XMLHandler.addTagValue("reference", this.getReferenceStepName());
        retval = retval + XMLHandler.addTagValue("compare", this.getCompareStepName());
        retval = retval + "    <compare>" + Const.CR;
        retval = retval + "    </compare>" + Const.CR;
        return retval;
    }

    private void readData(Node stepnode) throws ETLXMLException {
        try {
            int i;
            Node keysnode = XMLHandler.getSubNode(stepnode, "keys");
            Node valuesnode = XMLHandler.getSubNode(stepnode, "values");
            int nrKeys = XMLHandler.countNodes(keysnode, "key");
            int nrValues = XMLHandler.countNodes(valuesnode, "value");
            this.allocate(nrKeys, nrValues);
            for (i = 0; i < nrKeys; ++i) {
                Node keynode = XMLHandler.getSubNodeByNr(keysnode, "key", i);
                this.keyFields[i] = XMLHandler.getNodeValue(keynode);
            }
            for (i = 0; i < nrValues; ++i) {
                Node valuenode = XMLHandler.getSubNodeByNr(valuesnode, "value", i);
                this.valueFields[i] = XMLHandler.getNodeValue(valuenode);
            }
            this.flagField = XMLHandler.getTagValue(stepnode, "flag_field");
            this.compareStepName = XMLHandler.getTagValue(stepnode, "compare");
            this.referenceStepName = XMLHandler.getTagValue(stepnode, "reference");
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load step info from XML", e);
        }
    }

    @Override
    public void setDefault() {
        this.allocate(0, 0);
    }

    @Override
    public String[] getInfoSteps() {
        return new String[]{this.referenceStepName, this.compareStepName};
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        try {
            int i;
            int nrKeys = rep.countNrStepAttributes(id_step, "key_field");
            int nrValues = rep.countNrStepAttributes(id_step, "value_field");
            this.allocate(nrKeys, nrValues);
            for (i = 0; i < nrKeys; ++i) {
                this.keyFields[i] = rep.getStepAttributeString(id_step, i, "key_field");
            }
            for (i = 0; i < nrValues; ++i) {
                this.valueFields[i] = rep.getStepAttributeString(id_step, i, "value_field");
            }
            this.flagField = rep.getStepAttributeString(id_step, "flag_field");
            this.referenceStepName = rep.getStepAttributeString(id_step, "reference");
            this.compareStepName = rep.getStepAttributeString(id_step, "compare");
        }
        catch (Exception e) {
            throw new ETLException("Unexpected error reading step information from the repository", e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        try {
            int i;
            for (i = 0; i < this.keyFields.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "key_field", this.keyFields[i]);
            }
            for (i = 0; i < this.valueFields.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "value_field", this.valueFields[i]);
            }
            rep.saveStepAttribute(id_transformation, id_step, "flag_field", this.flagField);
            rep.saveStepAttribute(id_transformation, id_step, "reference", this.getReferenceStepName());
            rep.saveStepAttribute(id_transformation, id_step, "compare", this.getCompareStepName());
        }
        catch (Exception e) {
            throw new ETLException("Unable to save step information to the repository for id_step=" + id_step, e);
        }
    }

    @Override
    public void searchInfoAndTargetSteps(List steps) {
        this.referenceStepMeta = TransMeta.findStep(steps, this.referenceStepName);
        this.compareStepMeta = TransMeta.findStep(steps, this.compareStepName);
    }

    @Override
    public boolean chosesTargetSteps() {
        return false;
    }

    @Override
    public String[] getTargetSteps() {
        return null;
    }

    @Override
    public Row getFields(Row r, String name, Row info) throws ETLStepException {
        Value flagFieldValue = new Value(this.flagField, 2);
        flagFieldValue.setOrigin(name);
        r.addValue(flagFieldValue);
        return r;
    }

    @Override
    public void check(List remarks, StepMeta stepinfo, Row prev, String[] input, String[] output, Row info) {
        CheckResult cr = new CheckResult(3, "This step is not yet verified: not yet implemented.", stepinfo);
        remarks.add(cr);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new MergeRows(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new MergeRowsData();
    }
}

