/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.scriptvalues;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.scriptvalues.ContextUtil;
import com.kingdee.bos.ctrl.etl.transformation.step.scriptvalues.ScriptValuesData;
import com.kingdee.bos.ctrl.etl.transformation.step.scriptvalues.ScriptValuesMeta;
import com.kingdee.bos.ctrl.etl.value.Value;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;

public class ScriptValues
extends BaseStep
implements StepInterface {
    private ScriptValuesMeta meta;
    private ScriptValuesData data;

    public ScriptValues(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private void determineUsedFields(Row row) {
        String valname;
        int i;
        int nr = 0;
        for (i = 0; i < row.size(); ++i) {
            valname = row.getValue(i).getName().toUpperCase();
            if (this.meta.getScript().toUpperCase().indexOf(valname) < 0) continue;
            ++nr;
        }
        this.data.fields_used = new int[nr];
        nr = 0;
        for (i = 0; i < row.size(); ++i) {
            valname = row.getValue(i).getName();
            if (this.meta.getScript().indexOf(valname) < 0) continue;
            this.logDetailed("Value #" + i + " -  [" + valname + "] is used in the script.");
            this.data.fields_used[nr] = i;
            ++nr;
        }
        this.logDetailed("This script is using " + this.data.fields_used.length + " values from the input stream(s)");
    }

    private synchronized boolean addValues(Row row) {
        if (this.first) {
            this.determineUsedFields(row);
            this.debug = "first row";
            this.data.cx = Context.enter();
            this.data.scope = this.data.cx.initStandardObjects(null);
            this.first = false;
            Scriptable jsvalue = Context.toObject((Object)this, (Scriptable)this.data.scope);
            this.data.scope.put("_step_", this.data.scope, (Object)jsvalue);
            try {
                this.debug = "compile reader";
                this.data.script = ContextUtil.compileString(this.data.cx, this.meta.getScript(), "script", 1, null);
            }
            catch (Exception e) {
                this.logError("Couldn't compile javascript: " + e.toString());
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
        }
        this.debug = "toObject row";
        Scriptable jsrow = Context.toObject((Object)row, (Scriptable)this.data.scope);
        this.data.scope.put("row", this.data.scope, (Object)jsrow);
        this.debug = "toObject row values";
        for (int i = 0; i < this.data.fields_used.length; ++i) {
            Value val = row.getValue(this.data.fields_used[i]);
            this.debug = "toObject row value #" + i;
            Scriptable jsarg = Context.toObject((Object)val, (Scriptable)this.data.scope);
            this.debug = "toObject row value #" + i + " name==null?" + (val.getName() == null) + " row=" + row;
            this.data.scope.put(val.getName(), this.data.scope, (Object)jsarg);
        }
        this.debug = "toObject Value class";
        Scriptable jsval = Context.toObject(Value.class, (Scriptable)this.data.scope);
        this.data.scope.put("Value", this.data.scope, (Object)jsval);
        try {
            this.debug = "exec";
            this.data.script.exec(this.data.cx, this.data.scope);
            StringBuffer message = new StringBuffer();
            for (int i = 0; i < this.meta.getName().length; ++i) {
                Value res = new Value();
                if (this.meta.getValue(this.data.scope, i, res, message)) {
                    this.logError(message.toString());
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
                row.addValue(res);
            }
        }
        catch (JavaScriptException jse) {
            this.logError("Javascript error: " + jse.toString());
            this.setErrors(1L);
            this.stopAll();
            return false;
        }
        catch (Exception e) {
            this.logError("Javascript error: " + e.toString());
            this.setErrors(1L);
            this.stopAll();
            return false;
        }
        return true;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        this.meta = (ScriptValuesMeta)smi;
        this.data = (ScriptValuesData)sdi;
        Row r = this.getRow();
        if (r == null) {
            this.debug = "end";
            if (this.data.cx != null) {
                Context.exit();
            }
            this.setOutputDone();
            return false;
        }
        if (!this.addValues(r)) {
            this.debug = "no more new values";
            if (this.data.cx != null) {
                Context.exit();
            }
            this.setOutputDone();
            return false;
        }
        this.putRow(r);
        if (this.linesRead > 0L && this.linesRead % 5000L == 0L) {
            this.logBasic("linenr " + this.linesRead);
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ScriptValuesMeta)smi;
        this.data = (ScriptValuesData)sdi;
        return super.init(smi, sdi);
    }

    @Override
    public void run() {
        try {
            this.logBasic("Starting to run...");
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error in '" + this.debug + "' : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
        }
    }
}

