/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.sql;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Result;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.database.Database;
import com.kingdee.bos.ctrl.etl.database.DatabaseMeta;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLStepException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.sql.ExecSQL;
import com.kingdee.bos.ctrl.etl.transformation.step.sql.ExecSQLData;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;

public class ExecSQLMeta
extends BaseStepMeta
implements StepMetaInterface {
    private DatabaseMeta databaseMeta;
    private String sql;
    private boolean executedEachInputRow;
    private String[] arguments;
    private String updateField;
    private String insertField;
    private String deleteField;
    private String readField;

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public void setArguments(String[] arguments) {
        this.arguments = arguments;
    }

    public boolean isExecutedEachInputRow() {
        return this.executedEachInputRow;
    }

    public void setExecutedEachInputRow(boolean executedEachInputRow) {
        this.executedEachInputRow = executedEachInputRow;
    }

    public String getDeleteField() {
        return this.deleteField;
    }

    public void setDeleteField(String deleteField) {
        this.deleteField = deleteField;
    }

    public String getInsertField() {
        return this.insertField;
    }

    public void setInsertField(String insertField) {
        this.insertField = insertField;
    }

    public String getReadField() {
        return this.readField;
    }

    public void setReadField(String readField) {
        this.readField = readField;
    }

    public String getUpdateField() {
        return this.updateField;
    }

    public void setUpdateField(String updateField) {
        this.updateField = updateField;
    }

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        ExecSQLMeta retval = (ExecSQLMeta)super.clone();
        return retval;
    }

    public void allocate(int nrargs) {
        this.arguments = new String[nrargs];
    }

    private void readData(Node stepnode, List databases) throws ETLXMLException {
        try {
            String con = XMLHandler.getTagValue(stepnode, "connection");
            this.databaseMeta = Const.findDatabase(databases, con);
            String eachRow = XMLHandler.getTagValue(stepnode, "execute_each_row");
            this.executedEachInputRow = "Y".equalsIgnoreCase(eachRow);
            this.sql = XMLHandler.getTagValue(stepnode, "sql");
            Node argsnode = XMLHandler.getSubNode(stepnode, "arguments");
            int nrArguments = XMLHandler.countNodes(argsnode, "argument");
            this.allocate(nrArguments);
            for (int i = 0; i < nrArguments; ++i) {
                Node argnode = XMLHandler.getSubNodeByNr(argsnode, "argument", i);
                this.arguments[i] = XMLHandler.getTagValue(argnode, "name");
            }
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load step info from XML", e);
        }
    }

    @Override
    public void setDefault() {
        this.databaseMeta = null;
        this.sql = "";
        this.arguments = new String[0];
    }

    @Override
    public Row getFields(Row r, String name, Row info) throws ETLStepException {
        Row row = r == null ? new Row() : r;
        if (this.databaseMeta == null) {
            return row;
        }
        Row add = ExecSQL.getResultRow(new Result(), this.getUpdateField(), this.getInsertField(), this.getDeleteField(), this.getReadField());
        row.addRow(add);
        return row;
    }

    @Override
    public String getXML() {
        String xml = "";
        xml = xml + "    " + XMLHandler.addTagValue("connection", this.databaseMeta == null ? "" : this.databaseMeta.getName());
        xml = xml + "    " + XMLHandler.addTagValue("execute_each_row", this.executedEachInputRow);
        xml = xml + "    " + XMLHandler.addTagValue("sql", this.sql);
        xml = xml + "    " + XMLHandler.addTagValue("insert_field", this.insertField);
        xml = xml + "    " + XMLHandler.addTagValue("update_field", this.updateField);
        xml = xml + "    " + XMLHandler.addTagValue("delete_field", this.deleteField);
        xml = xml + "    " + XMLHandler.addTagValue("read_field", this.readField);
        xml = xml + "    <arguments>" + Const.CR;
        for (int i = 0; i < this.arguments.length; ++i) {
            xml = xml + "       <argument>" + XMLHandler.addTagValue("name", this.arguments[i], false) + "</argument>" + Const.CR;
        }
        xml = xml + "    </arguments>" + Const.CR;
        return xml;
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        try {
            long id_connection = rep.getStepAttributeInteger(id_step, "id_connection");
            this.databaseMeta = Const.findDatabase(databases, id_connection);
            this.executedEachInputRow = rep.getStepAttributeBoolean(id_step, "execute_each_row");
            this.sql = rep.getStepAttributeString(id_step, "sql");
            this.insertField = rep.getStepAttributeString(id_step, "insert_field");
            this.updateField = rep.getStepAttributeString(id_step, "update_field");
            this.deleteField = rep.getStepAttributeString(id_step, "delete_field");
            this.readField = rep.getStepAttributeString(id_step, "read_field");
            int nrargs = rep.countNrStepAttributes(id_step, "arg_name");
            this.allocate(nrargs);
            for (int i = 0; i < nrargs; ++i) {
                this.arguments[i] = rep.getStepAttributeString(id_step, i, "arg_name");
            }
        }
        catch (Exception e) {
            throw new ETLException("Unexpected error reading step information from the repository", e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta == null ? -1.0 : (double)this.databaseMeta.getID());
            rep.saveStepAttribute(id_transformation, id_step, "sql", this.sql);
            rep.saveStepAttribute(id_transformation, id_step, "execute_each_row", this.executedEachInputRow);
            rep.saveStepAttribute(id_transformation, id_step, "insert_field", this.insertField);
            rep.saveStepAttribute(id_transformation, id_step, "update_field", this.updateField);
            rep.saveStepAttribute(id_transformation, id_step, "delete_field", this.deleteField);
            rep.saveStepAttribute(id_transformation, id_step, "read_field", this.readField);
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getID());
            }
            for (int i = 0; i < this.arguments.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "arg_name", this.arguments[i]);
            }
        }
        catch (Exception e) {
            throw new ETLException("Unable to save step information to the repository for id_step=" + id_step, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check(List remarks, StepMeta stepMeta, Row prev, String[] input, String[] output, Row info) {
        CheckResult cr;
        if (this.databaseMeta != null) {
            cr = new CheckResult(1, "Connection exists", stepMeta);
            remarks.add(cr);
            Database db = new Database(this.databaseMeta);
            this.databases = new Database[]{db};
            try {
                db.connect();
                cr = new CheckResult(1, "Connection to database OK", stepMeta);
                remarks.add(cr);
                if (this.sql != null && this.sql.length() != 0) {
                    cr = new CheckResult(1, "SQL statement is entered", stepMeta);
                    remarks.add(cr);
                }
                cr = new CheckResult(4, "SQL statement is missing.", stepMeta);
                remarks.add(cr);
            }
            catch (ETLException e) {
                cr = new CheckResult(4, "An error occurred: " + e.getMessage(), stepMeta);
                remarks.add(cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            cr = new CheckResult(4, "Please select or create a connection to use", stepMeta);
            remarks.add(cr);
        }
        if (this.executedEachInputRow) {
            if (input.length > 0) {
                cr = new CheckResult(1, "Step is receiving info from other steps.", stepMeta);
                remarks.add(cr);
            } else {
                cr = new CheckResult(4, "No input received from other steps!", stepMeta);
                remarks.add(cr);
            }
        } else if (input.length > 0) {
            cr = new CheckResult(4, "Step is receiving info from other steps but the SQL is only executed once!", stepMeta);
            remarks.add(cr);
        } else {
            cr = new CheckResult(1, "No input received from other steps. That's OK because the SQL is only executed once.", stepMeta);
            remarks.add(cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new ExecSQL(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new ExecSQLData();
    }
}

