/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.xmlinput;

import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLValueException;
import com.kingdee.bos.ctrl.etl.transformation.step.xmlinput.XMLInputFieldPosition;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import org.w3c.dom.Node;

public class XMLInputField
implements Cloneable {
    public static final int TYPE_TRIM_NONE = 0;
    public static final int TYPE_TRIM_LEFT = 1;
    public static final int TYPE_TRIM_RIGHT = 2;
    public static final int TYPE_TRIM_BOTH = 3;
    public static final String[] trimTypeDesc = new String[]{"none", "left", "right", "both"};
    public static final String POSITION_MARKER = ",";
    private String name;
    private XMLInputFieldPosition[] fieldPosition;
    private int type;
    private int length;
    private String format;
    private int trimtype;
    private int precision;
    private String currencySymbol;
    private String decimalSymbol;
    private String groupSymbol;
    private boolean repeat;
    private String[] samples;

    public XMLInputField(String fieldname, XMLInputFieldPosition[] xmlInputFieldPositions) {
        this.name = fieldname;
        this.fieldPosition = xmlInputFieldPositions;
        this.length = -1;
        this.type = 2;
        this.format = "";
        this.trimtype = 0;
        this.groupSymbol = "";
        this.decimalSymbol = "";
        this.currencySymbol = "";
        this.precision = -1;
        this.repeat = false;
    }

    public XMLInputField() {
        this(null, null);
    }

    public String getXML() {
        String retval = "";
        retval = retval + "      <field>" + Const.CR;
        retval = retval + "        " + XMLHandler.addTagValue("name", this.getName());
        retval = retval + "        " + XMLHandler.addTagValue("type", this.getTypeDesc());
        retval = retval + "        " + XMLHandler.addTagValue("format", this.getFormat());
        retval = retval + "        " + XMLHandler.addTagValue("currency", this.getCurrencySymbol());
        retval = retval + "        " + XMLHandler.addTagValue("decimal", this.getDecimalSymbol());
        retval = retval + "        " + XMLHandler.addTagValue("group", this.getGroupSymbol());
        retval = retval + "        " + XMLHandler.addTagValue("length", this.getLength());
        retval = retval + "        " + XMLHandler.addTagValue("precision", this.getPrecision());
        retval = retval + "        " + XMLHandler.addTagValue("trim_type", this.getTrimTypeDesc());
        retval = retval + "        " + XMLHandler.addTagValue("repeat", this.isRepeated());
        retval = retval + "        <positions>";
        for (int i = 0; i < this.fieldPosition.length; ++i) {
            retval = retval + XMLHandler.addTagValue("position", this.fieldPosition[i].toString(), false);
        }
        retval = retval + "        </positions>" + Const.CR;
        retval = retval + "        </field>" + Const.CR;
        return retval;
    }

    public XMLInputField(Node fnode) throws ETLValueException {
        this.setName(XMLHandler.getTagValue(fnode, "name"));
        this.setType(Value.getType(XMLHandler.getTagValue(fnode, "type")));
        this.setFormat(XMLHandler.getTagValue(fnode, "format"));
        this.setCurrencySymbol(XMLHandler.getTagValue(fnode, "currency"));
        this.setDecimalSymbol(XMLHandler.getTagValue(fnode, "decimal"));
        this.setGroupSymbol(XMLHandler.getTagValue(fnode, "group"));
        this.setLength(Const.toInt(XMLHandler.getTagValue(fnode, "length"), -1));
        this.setPrecision(Const.toInt(XMLHandler.getTagValue(fnode, "precision"), -1));
        this.setTrimType(XMLInputField.getTrimType(XMLHandler.getTagValue(fnode, "trim_type")));
        this.setRepeated(!"N".equalsIgnoreCase(XMLHandler.getTagValue(fnode, "repeat")));
        Node positions = XMLHandler.getSubNode(fnode, "positions");
        int nrPositions = XMLHandler.countNodes(positions, "position");
        this.fieldPosition = new XMLInputFieldPosition[nrPositions];
        for (int i = 0; i < nrPositions; ++i) {
            Node positionnode = XMLHandler.getSubNodeByNr(positions, "position", i);
            String encoded = XMLHandler.getNodeValue(positionnode);
            this.fieldPosition[i] = new XMLInputFieldPosition(encoded);
        }
    }

    public static final int getTrimType(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < trimTypeDesc.length; ++i) {
            if (!trimTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final String getTrimTypeDesc(int i) {
        if (i < 0 || i >= trimTypeDesc.length) {
            return trimTypeDesc[0];
        }
        return trimTypeDesc[i];
    }

    public Object clone() {
        try {
            XMLInputField retval = (XMLInputField)super.clone();
            if (this.fieldPosition != null) {
                XMLInputFieldPosition[] positions = new XMLInputFieldPosition[this.fieldPosition.length];
                for (int i = 0; i < this.fieldPosition.length; ++i) {
                    positions[i] = (XMLInputFieldPosition)this.fieldPosition[i].clone();
                }
                retval.setFieldPosition(positions);
            }
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public XMLInputFieldPosition[] getFieldPosition() {
        return this.fieldPosition;
    }

    public void setFieldPosition(XMLInputFieldPosition[] xmlInputFieldPositions) {
        this.fieldPosition = xmlInputFieldPositions;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String fieldname) {
        this.name = fieldname;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeDesc() {
        return Value.getTypeDesc(this.type);
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setSamples(String[] samples) {
        this.samples = samples;
    }

    public String[] getSamples() {
        return this.samples;
    }

    public int getTrimType() {
        return this.trimtype;
    }

    public String getTrimTypeDesc() {
        return XMLInputField.getTrimTypeDesc(this.trimtype);
    }

    public void setTrimType(int trimtype) {
        this.trimtype = trimtype;
    }

    public String getGroupSymbol() {
        return this.groupSymbol;
    }

    public void setGroupSymbol(String group_symbol) {
        this.groupSymbol = group_symbol;
    }

    public String getDecimalSymbol() {
        return this.decimalSymbol;
    }

    public void setDecimalSymbol(String decimal_symbol) {
        this.decimalSymbol = decimal_symbol;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currency_symbol) {
        this.currencySymbol = currency_symbol;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public boolean isRepeated() {
        return this.repeat;
    }

    public void setRepeated(boolean repeat) {
        this.repeat = repeat;
    }

    public void flipRepeated() {
        this.repeat = !this.repeat;
    }

    public String getFieldPositionsCode() {
        String enc = "";
        for (int i = 0; i < this.fieldPosition.length; ++i) {
            XMLInputFieldPosition pos = this.fieldPosition[i];
            if (i > 0) {
                enc = enc + POSITION_MARKER;
            }
            enc = enc + pos.toString();
        }
        return enc;
    }

    public void guess() {
    }

    public void setFieldPosition(String encoded) throws ETLException {
        try {
            String[] codes = encoded.split(POSITION_MARKER);
            this.fieldPosition = new XMLInputFieldPosition[codes.length];
            for (int i = 0; i < codes.length; ++i) {
                this.fieldPosition[i] = new XMLInputFieldPosition(codes[i]);
            }
        }
        catch (Exception e) {
            throw new ETLException("Unable to parse the field positions because of an error" + Const.CR + "Please use E=element or A=attribute in a comma separated list (code: " + encoded + ")", e);
        }
    }
}

