/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.xmlinput;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.xmlinput.XMLInput;
import com.kingdee.bos.ctrl.etl.transformation.step.xmlinput.XMLInputData;
import com.kingdee.bos.ctrl.etl.transformation.step.xmlinput.XMLInputField;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Node;

public class XMLInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String[] fileName;
    private String[] fileMask;
    private boolean includeFilename;
    private String filenameField;
    private boolean includeRowNumber;
    private String rowNumberField;
    private long rowLimit;
    private XMLInputField[] inputFields;
    private String[] inputPosition;

    public XMLInputField[] getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(XMLInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    public String[] getFileMask() {
        return this.fileMask;
    }

    public void setFileMask(String[] fileMask) {
        this.fileMask = fileMask;
    }

    public String[] getFileName() {
        return this.fileName;
    }

    public void setFileName(String[] fileName) {
        this.fileName = fileName;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public boolean includeFilename() {
        return this.includeFilename;
    }

    public void setIncludeFilename(boolean includeFilename) {
        this.includeFilename = includeFilename;
    }

    public boolean includeRowNumber() {
        return this.includeRowNumber;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        int i;
        XMLInputMeta retval = (XMLInputMeta)super.clone();
        int nrFiles = this.fileName.length;
        int nrFields = this.inputFields.length;
        int nrPositions = this.inputPosition.length;
        retval.allocate(nrFiles, nrFields, nrPositions);
        for (i = 0; i < nrFields; ++i) {
            if (this.inputFields[i] == null) continue;
            retval.inputFields[i] = (XMLInputField)this.inputFields[i].clone();
        }
        for (i = 0; i < nrPositions; ++i) {
            retval.inputPosition[i] = this.inputPosition[i];
        }
        return retval;
    }

    @Override
    public String getXML() {
        int i;
        String retval = "";
        retval = retval + "    " + XMLHandler.addTagValue("include", this.includeFilename);
        retval = retval + "    " + XMLHandler.addTagValue("include_field", this.filenameField);
        retval = retval + "    " + XMLHandler.addTagValue("rownum", this.includeRowNumber);
        retval = retval + "    " + XMLHandler.addTagValue("rownum_field", this.rowNumberField);
        retval = retval + "    <file>" + Const.CR;
        for (i = 0; i < this.fileName.length; ++i) {
            retval = retval + "      " + XMLHandler.addTagValue("name", this.fileName[i]);
            retval = retval + "      " + XMLHandler.addTagValue("filemask", this.fileMask[i]);
        }
        retval = retval + "      </file>" + Const.CR;
        retval = retval + "    <fields>" + Const.CR;
        for (i = 0; i < this.inputFields.length; ++i) {
            XMLInputField field = this.inputFields[i];
            retval = retval + field.getXML();
        }
        retval = retval + "      </fields>" + Const.CR;
        retval = retval + "    <positions>" + Const.CR;
        for (i = 0; i < this.inputPosition.length; ++i) {
            retval = retval + "      " + XMLHandler.addTagValue("position", this.inputPosition[i]);
        }
        retval = retval + "      </positions>" + Const.CR;
        retval = retval + "    " + XMLHandler.addTagValue("limit", this.rowLimit);
        return retval;
    }

    private void readData(Node stepnode) throws ETLXMLException {
        try {
            int i;
            this.includeFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "include"));
            this.filenameField = XMLHandler.getTagValue(stepnode, "include_field");
            this.includeRowNumber = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "rownum"));
            this.rowNumberField = XMLHandler.getTagValue(stepnode, "rownum_field");
            Node filenode = XMLHandler.getSubNode(stepnode, "file");
            Node fields = XMLHandler.getSubNode(stepnode, "fields");
            Node positions = XMLHandler.getSubNode(stepnode, "positions");
            int nrFiles = XMLHandler.countNodes(filenode, "name");
            int nrFields = XMLHandler.countNodes(fields, "field");
            int nrPositions = XMLHandler.countNodes(positions, "position");
            this.allocate(nrFiles, nrFields, nrPositions);
            for (i = 0; i < nrFiles; ++i) {
                Node filenamenode = XMLHandler.getSubNodeByNr(filenode, "name", i);
                Node filemasknode = XMLHandler.getSubNodeByNr(filenode, "filemask", i);
                this.fileName[i] = XMLHandler.getNodeValue(filenamenode);
                this.fileMask[i] = XMLHandler.getNodeValue(filemasknode);
            }
            for (i = 0; i < nrFields; ++i) {
                XMLInputField field;
                Node fnode = XMLHandler.getSubNodeByNr(fields, "field", i);
                this.inputFields[i] = field = new XMLInputField(fnode);
            }
            for (i = 0; i < nrPositions; ++i) {
                Node positionnode = XMLHandler.getSubNodeByNr(positions, "position", i);
                this.inputPosition[i] = XMLHandler.getNodeValue(positionnode);
            }
            String lim = XMLHandler.getTagValue(stepnode, "limit");
            this.rowLimit = Const.toLong(lim, 0L);
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load step info from XML", e);
        }
    }

    public void allocate(int nrfiles, int nrfields, int nrPositions) {
        this.fileName = new String[nrfiles];
        this.fileMask = new String[nrfiles];
        this.inputFields = new XMLInputField[nrfields];
        this.inputPosition = new String[nrPositions];
    }

    @Override
    public void setDefault() {
        int i;
        this.includeFilename = false;
        this.filenameField = "";
        this.includeRowNumber = false;
        this.rowNumberField = "";
        int nrFiles = 0;
        int nrFields = 0;
        int nrPositions = 0;
        this.allocate(nrFiles, nrFields, nrPositions);
        for (i = 0; i < nrFiles; ++i) {
            this.fileName[i] = "filename" + (i + 1);
            this.fileMask[i] = "";
        }
        for (i = 0; i < nrFields; ++i) {
            this.inputFields[i] = new XMLInputField("field" + (i + 1), null);
        }
        for (i = 0; i < nrPositions; ++i) {
            this.inputPosition[i] = "position" + (i + 1);
        }
        this.rowLimit = 0L;
    }

    @Override
    public Row getFields(Row r, String name, Row info) {
        Value v;
        Row row = r == null ? new Row() : r;
        for (int i = 0; i < this.inputFields.length; ++i) {
            XMLInputField field = this.inputFields[i];
            int type = field.getType();
            if (type == 0) {
                type = 2;
            }
            Value v2 = new Value(field.getName(), type);
            v2.setLength(field.getLength(), field.getPrecision());
            v2.setOrigin(name);
            row.addValue(v2);
        }
        if (this.includeFilename) {
            v = new Value(this.filenameField, 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValue(v);
        }
        if (this.includeRowNumber) {
            v = new Value(this.rowNumberField, 1);
            v.setLength(7, 0);
            v.setOrigin(name);
            row.addValue(v);
        }
        return row;
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        try {
            int i;
            this.includeFilename = rep.getStepAttributeBoolean(id_step, "include");
            this.filenameField = rep.getStepAttributeString(id_step, "include_field");
            this.includeRowNumber = rep.getStepAttributeBoolean(id_step, "rownum");
            this.rowNumberField = rep.getStepAttributeString(id_step, "rownum_field");
            this.rowLimit = (int)rep.getStepAttributeInteger(id_step, "limit");
            int nrFiles = rep.countNrStepAttributes(id_step, "file_name");
            int nrFields = rep.countNrStepAttributes(id_step, "field_name");
            int nrPositions = rep.countNrStepAttributes(id_step, "input_position");
            this.allocate(nrFiles, nrFields, nrPositions);
            for (i = 0; i < nrFiles; ++i) {
                this.fileName[i] = rep.getStepAttributeString(id_step, i, "file_name");
                this.fileMask[i] = rep.getStepAttributeString(id_step, i, "file_mask");
            }
            for (i = 0; i < nrFields; ++i) {
                XMLInputField field = new XMLInputField();
                field.setName(rep.getStepAttributeString(id_step, i, "field_name"));
                field.setType(Value.getType(rep.getStepAttributeString(id_step, i, "field_type")));
                field.setFormat(rep.getStepAttributeString(id_step, i, "field_format"));
                field.setCurrencySymbol(rep.getStepAttributeString(id_step, i, "field_currency"));
                field.setDecimalSymbol(rep.getStepAttributeString(id_step, i, "field_decimal"));
                field.setGroupSymbol(rep.getStepAttributeString(id_step, i, "field_group"));
                field.setLength((int)rep.getStepAttributeInteger(id_step, i, "field_length"));
                field.setPrecision((int)rep.getStepAttributeInteger(id_step, i, "field_precision"));
                field.setTrimType(XMLInputField.getTrimType(rep.getStepAttributeString(id_step, i, "field_trim_type")));
                field.setRepeated(rep.getStepAttributeBoolean(id_step, i, "field_repeat"));
                String fieldPositionCode = rep.getStepAttributeString(id_step, i, "field_position_code");
                if (fieldPositionCode != null) {
                    field.setFieldPosition(fieldPositionCode);
                }
                this.inputFields[i] = field;
            }
            for (i = 0; i < nrPositions; ++i) {
                this.inputPosition[i] = rep.getStepAttributeString(id_step, i, "input_position");
            }
        }
        catch (Exception e) {
            throw new ETLException("Unexpected error reading step information from the repository", e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "include", this.includeFilename);
            rep.saveStepAttribute(id_transformation, id_step, "include_field", this.filenameField);
            rep.saveStepAttribute(id_transformation, id_step, "rownum", this.includeRowNumber);
            rep.saveStepAttribute(id_transformation, id_step, "rownum_field", this.rowNumberField);
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.rowLimit);
            for (i = 0; i < this.fileName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "file_name", this.fileName[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "file_mask", this.fileMask[i]);
            }
            for (i = 0; i < this.inputFields.length; ++i) {
                XMLInputField field = this.inputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", field.getName());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_type", field.getTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_format", field.getFormat());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_currency", field.getCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_decimal", field.getDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_group", field.getGroupSymbol());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_length", field.getLength());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_precision", field.getPrecision());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_trim_type", field.getTrimTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_repeat", field.isRepeated());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_position_code", field.getFieldPositionsCode());
            }
            for (i = 0; i < this.inputPosition.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "input_position", this.inputPosition[i]);
            }
        }
        catch (Exception e) {
            throw new ETLException("Unable to save step information to the repository for id_step=" + id_step, e);
        }
    }

    public String[] getFiles() {
        Object files = null;
        String[] realfile = Const.replEnv(this.fileName);
        String[] realmask = Const.replEnv(this.fileMask);
        ArrayList<String> filelist = new ArrayList<String>();
        for (int i = 0; i < realfile.length; ++i) {
            File file;
            String onefile = realfile[i];
            final String onemask = realmask[i];
            if (onemask != null && onemask.length() > 0) {
                file = new File(FilenameUtils.normalize((String)onefile));
                try {
                    files = file.list(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return Pattern.matches(onemask, name);
                        }
                    });
                    for (int j = 0; j < ((String[])files).length; ++j) {
                        files[j] = !onefile.endsWith(Const.FILE_SEPARATOR) ? onefile + Const.FILE_SEPARATOR + files[j] : onefile + files[j];
                    }
                }
                catch (Exception e) {
                    files = null;
                }
            } else {
                file = new File(FilenameUtils.normalize((String)onefile));
                files = file.exists() && file.isFile() && file.canRead() ? new String[]{onefile} : null;
            }
            if (files == null) continue;
            for (int x = 0; x < ((String[])files).length; ++x) {
                filelist.add(files[x]);
            }
        }
        Collections.sort(filelist);
        files = filelist.toArray(new String[filelist.size()]);
        return files;
    }

    @Override
    public void check(List remarks, StepMeta stepinfo, Row prev, String[] input, String[] output, Row info) {
        CheckResult cr;
        if (input.length > 0) {
            cr = new CheckResult(4, "This step is not expecting nor reading any input", stepinfo);
            remarks.add(cr);
        } else {
            cr = new CheckResult(1, "Not receiving any input from other steps.", stepinfo);
            remarks.add(cr);
        }
        String[] files = this.getFiles();
        if (files == null || files.length == 0) {
            cr = new CheckResult(4, "No files can be found to read.", stepinfo);
            remarks.add(cr);
        } else {
            cr = new CheckResult(1, "This step is reading " + files.length + " files.", stepinfo);
            remarks.add(cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new XMLInput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new XMLInputData();
    }

    public String[] getInputPosition() {
        return this.inputPosition;
    }

    public void setInputPosition(String[] inputPosition) {
        this.inputPosition = inputPosition;
    }
}

