/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.xmloutput;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLStepException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.xmloutput.XMLField;
import com.kingdee.bos.ctrl.etl.transformation.step.xmloutput.XMLOutputData;
import com.kingdee.bos.ctrl.etl.transformation.step.xmloutput.XMLOutputMeta;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;

public class XMLOutput
extends BaseStep
implements StepInterface {
    private XMLOutputMeta meta;
    private XMLOutputData data;

    public XMLOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        this.meta = (XMLOutputMeta)smi;
        this.data = (XMLOutputData)sdi;
        boolean result = true;
        Row r = this.getRow();
        if (r != null && this.linesOutput > 0L && this.meta.getSplitEvery() > 0 && this.linesOutput % (long)this.meta.getSplitEvery() == 0L) {
            this.closeFile();
            if (r != null && !this.openNewFile()) {
                this.logError("Unable to open new file (split #" + this.data.splitnr + "...");
                this.setErrors(1L);
                return false;
            }
        }
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        result = this.writeRowToFile(r);
        if (!result) {
            this.setErrors(1L);
            this.stopAll();
            return false;
        }
        this.putRow(r);
        if (this.linesOutput > 0L && this.linesOutput % 5000L == 0L) {
            this.logBasic("linenr " + this.linesOutput);
        }
        return result;
    }

    private boolean writeRowToFile(Row r) {
        this.debug = "row to file";
        try {
            int i;
            this.debug = "Start";
            if (this.first) {
                this.first = false;
                this.data.fieldnrs = new int[this.meta.getOutputFields().length];
                this.debug = "Get fieldnrs... field_name.length=" + this.meta.getOutputFields().length;
                for (i = 0; i < this.meta.getOutputFields().length; ++i) {
                    this.data.fieldnrs[i] = r.searchValueIndex(this.meta.getOutputFields()[i].getFieldName());
                    if (this.data.fieldnrs[i] >= 0) continue;
                    this.logError("Field [" + this.meta.getOutputFields()[i].getFieldName() + "] couldn't be found in the input stream!");
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
            }
            if (this.meta.getOutputFields() == null || this.meta.getOutputFields().length == 0) {
                this.data.writer.write((" <" + this.meta.getRepeatElement() + ">").toCharArray());
                this.debug = "Loop fields 0.." + r.size();
                for (i = 0; i < r.size(); ++i) {
                    this.debug = "start for loop";
                    if (i > 0) {
                        this.data.writer.write(32);
                    }
                    this.debug = "Get value " + i + " of " + r.size();
                    Value v = r.getValue(i);
                    this.debug = "Write field to output stream: [" + v.toString() + "] of type [" + v.toStringMeta() + "]";
                    this.writeField(v, -1, v.getName());
                    this.debug = "Finished writing field #" + i + " [" + v + "/" + v.toStringMeta() + "] of row nr " + this.linesInput;
                }
            } else {
                this.data.writer.write((" <" + this.meta.getRepeatElement() + ">").toCharArray());
                this.debug = "Loop fields 0.." + this.meta.getOutputFields().length;
                for (i = 0; i < this.meta.getOutputFields().length; ++i) {
                    XMLField outputField = this.meta.getOutputFields()[i];
                    this.debug = "start for loop";
                    if (i > 0) {
                        this.data.writer.write(32);
                    }
                    this.debug = "Get value " + this.data.fieldnrs[i] + " of row ";
                    Value v = r.getValue(this.data.fieldnrs[i]);
                    v.setLength(outputField.getLength(), outputField.getPrecision());
                    String element = outputField.getElementName() != null && outputField.getElementName().length() > 0 ? outputField.getElementName() : v.getName();
                    this.writeField(v, i, element);
                    this.debug = "Finished writing field #" + i + " [" + v + "/" + v.toStringMeta() + "] of row nr " + this.linesInput;
                }
            }
            this.data.writer.write((" </" + this.meta.getRepeatElement() + ">").toCharArray());
            this.data.writer.write(Const.CR.toCharArray());
            this.debug = "Finished writing row #" + this.linesInput;
        }
        catch (Exception e) {
            this.logError("Error writing XML row in [" + this.debug + "] :" + e.toString() + Const.CR + "Row: " + r);
            return false;
        }
        ++this.linesOutput;
        return true;
    }

    private String formatField(Value v, int idx) {
        String retval = "";
        XMLField field = null;
        if (idx >= 0) {
            field = this.meta.getOutputFields()[idx];
        }
        if (v.isBigNumber()) {
            retval = retval + v.getString();
        } else if (v.isNumeric()) {
            this.debug = "Number is formatted?";
            if (idx >= 0 && field != null && field.getFormat() != null) {
                this.debug = "Number formatted!";
                if (v.isNull()) {
                    this.debug = "Number null";
                    if (field.getNullString() != null) {
                        retval = field.getNullString();
                    }
                } else {
                    this.debug = "Formatted number pattern, field=" + v.getName() + ", idx=" + idx;
                    this.data.df.applyPattern(field.getFormat());
                    if (field.getDecimalSymbol() != null && field.getDecimalSymbol().length() > 0) {
                        this.data.dfs.setDecimalSeparator(field.getDecimalSymbol().charAt(0));
                    }
                    if (field.getGroupingSymbol() != null && field.getGroupingSymbol().length() > 0) {
                        this.data.dfs.setGroupingSeparator(field.getGroupingSymbol().charAt(0));
                    }
                    if (field.getCurrencySymbol() != null) {
                        this.data.dfs.setCurrencySymbol(field.getCurrencySymbol());
                    }
                    this.data.df.setDecimalFormatSymbols(this.data.dfs);
                    retval = this.data.df.format(v.getNumber());
                }
            } else {
                this.debug = "Not formatted number";
                if (v.isNull()) {
                    if (idx >= 0 && field != null && field.getNullString() != null) {
                        retval = field.getNullString();
                    }
                } else {
                    retval = v.toString();
                }
            }
        } else if (v.isDate()) {
            this.debug = "Date is formatted?";
            if (idx >= 0 && field != null && field.getFormat() != null && v.getDate() != null) {
                this.debug = "Formatted date pattern, field=" + v.getName() + ", idx=" + idx;
                this.data.daf.applyPattern(field.getFormat());
                this.data.daf.setDateFormatSymbols(this.data.dafs);
                retval = this.data.daf.format(v.getDate());
            } else {
                this.debug = "Date is not formatted";
                if (v.isNull() || v.getDate() == null) {
                    this.debug = "nulliff date (field==null? " + (field == null) + ", idx=" + idx + ")";
                    if (idx >= 0 && field != null && field.getNullString() != null) {
                        retval = field.getNullString();
                    }
                    this.debug = "nulliff date finished";
                } else {
                    retval = v.toString();
                }
            }
        } else if (v.isString()) {
            this.debug = "String length=" + v.getLength() + ", value=" + v.toString();
            if (v.isNull() || v.getString() == null) {
                if (idx >= 0 && field != null && field.getNullString() != null) {
                    retval = field.getNullString();
                }
            } else {
                retval = v.toString();
            }
        } else {
            this.debug = "Boolean: " + v.getBoolean();
            if (v.isNull()) {
                if (idx >= 0 && field != null && field.getNullString() != null) {
                    retval = field.getNullString();
                }
            } else {
                retval = v.toString();
            }
        }
        this.debug = "End of formatField";
        return retval;
    }

    private void writeField(Value v, int idx, String element) throws ETLStepException {
        try {
            String str = XMLHandler.addTagValue(element, this.formatField(v, idx), false);
            if (str != null) {
                this.data.writer.write(str.toCharArray());
            }
            this.debug = "End of writeField";
        }
        catch (Exception e) {
            throw new ETLStepException("Error writing line in [" + this.debug + "] :", e);
        }
    }

    public String buildFilename(boolean ziparchive) {
        return this.meta.buildFilename(this.getCopy(), this.data.splitnr, ziparchive);
    }

    public boolean openNewFile() {
        boolean retval = false;
        this.data.writer = null;
        try {
            OutputStream outputStream;
            File file = new File(FilenameUtils.normalize((String)this.buildFilename(true)));
            if (this.meta.isZipped()) {
                FileOutputStream fos = new FileOutputStream(file);
                this.data.zip = new ZipOutputStream(fos);
                File entry = new File(FilenameUtils.normalize((String)this.buildFilename(false)));
                ZipEntry zipentry = new ZipEntry(entry.getName());
                zipentry.setComment("Compressed by Kettle");
                this.data.zip.putNextEntry(zipentry);
                outputStream = this.data.zip;
            } else {
                FileOutputStream fos;
                outputStream = fos = new FileOutputStream(file);
            }
            if (this.meta.getEncoding() != null && this.meta.getEncoding().length() > 0) {
                this.log.logBasic(this.toString(), "Opening output stream in encoding: " + this.meta.getEncoding());
                this.data.writer = new OutputStreamWriter(outputStream, this.meta.getEncoding());
                this.data.writer.write(XMLHandler.getXMLHeader(this.meta.getEncoding()).toCharArray());
            } else {
                this.log.logBasic(this.toString(), "Opening output stream in default encoding : UTF-8");
                this.data.writer = new OutputStreamWriter(outputStream);
                this.data.writer.write(XMLHandler.getXMLHeader("UTF-8").toCharArray());
            }
            this.data.writer.write(("<" + this.meta.getMainElement() + ">" + Const.CR).toCharArray());
            retval = true;
        }
        catch (Exception e) {
            this.logError("Error opening new file : " + e.toString());
        }
        ++this.data.splitnr;
        return retval;
    }

    private boolean closeFile() {
        boolean retval = false;
        try {
            this.data.writer.write(("</" + this.meta.getMainElement() + ">" + Const.CR).toCharArray());
            if (this.meta.isZipped()) {
                this.data.zip.closeEntry();
                this.data.zip.finish();
                this.data.zip.close();
            } else {
                this.data.writer.close();
            }
            retval = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (XMLOutputMeta)smi;
        this.data = (XMLOutputData)sdi;
        if (super.init(smi, sdi)) {
            this.data.splitnr = 0;
            if (this.openNewFile()) {
                this.debug = "start";
                return true;
            }
            this.logError("Couldn't open file " + this.meta.getFileName() + " [" + this.debug + "]");
            this.setErrors(1L);
            this.stopAll();
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (XMLOutputMeta)smi;
        this.data = (XMLOutputData)sdi;
        super.dispose(smi, sdi);
        this.closeFile();
    }

    @Override
    public void run() {
        try {
            this.logBasic("Starting to run...");
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error in '" + this.debug + "' : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
        }
    }
}

