/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.util;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.etl.logging.Log4jConsoleAppender;
import com.kingdee.bos.ctrl.etl.logging.Log4jETLLayout;
import com.kingdee.bos.ctrl.etl.logging.Log4jFileAppender;
import com.kingdee.bos.ctrl.etl.logging.Log4jMessage;
import com.kingdee.bos.ctrl.etl.logging.Log4jStringAppender;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;

public class LogWriter {
    private static LogWriter lastLog;
    private static Hashtable logs;
    public static final int LOG_LEVEL_NOTHING = 0;
    public static final int LOG_LEVEL_ERROR = 1;
    public static final int LOG_LEVEL_MINIMAL = 2;
    public static final int LOG_LEVEL_BASIC = 3;
    public static final int LOG_LEVEL_DETAILED = 4;
    public static final int LOG_LEVEL_DEBUG = 5;
    public static final int LOG_LEVEL_ROWLEVEL = 6;
    public static final String[] logLevelDescription;
    public static final String[] log_level_desc_long;
    private OutputStream stream;
    private String filename;
    private File file;
    private int type;
    private int level;
    private String filter;
    private boolean exact;
    private Logger rootLogger = Logger.getRootLogger();
    private Log4jFileAppender fileAppender;
    private Log4jConsoleAppender consoleAppender;
    private Log4jStringAppender stringAppender;
    private Log4jETLLayout layout = new Log4jETLLayout(true);
    private static final String NO_FILE_NAME = "-";
    private File realFilename;

    private static final LogWriter findLogWriter(String filename) {
        return (LogWriter)logs.get(filename);
    }

    public static final LogWriter getInstance() {
        if (lastLog != null) {
            return lastLog;
        }
        throw new RuntimeException("The logging system is not initialized!");
    }

    public static final LogWriter getInstance(int lvl) {
        LogWriter log = LogWriter.findLogWriter(NO_FILE_NAME);
        if (log != null) {
            return log;
        }
        lastLog = new LogWriter(lvl);
        logs.put(NO_FILE_NAME, lastLog);
        return lastLog;
    }

    private LogWriter() {
        this.consoleAppender = new Log4jConsoleAppender();
        this.consoleAppender.setLayout(this.layout);
        this.consoleAppender.setName("AppendToConsole");
        this.stringAppender = new Log4jStringAppender();
        this.stringAppender.setLayout(this.layout);
        this.stringAppender.setName("AppendToString");
    }

    private LogWriter(int lvl) {
        this();
        this.rootLogger.addAppender((Appender)this.consoleAppender);
        this.level = lvl;
        this.filter = null;
    }

    public static final LogWriter getInstance(int lvl, OutputStream stream) {
        LogWriter log = LogWriter.findLogWriter(NO_FILE_NAME);
        if (log != null) {
            return log;
        }
        lastLog = new LogWriter(lvl);
        LogWriter.lastLog.stream = stream;
        logs.put(NO_FILE_NAME, lastLog);
        return lastLog;
    }

    public static final LogWriter getInstance(String filename, boolean exact, int level) {
        LogWriter log = LogWriter.findLogWriter(filename);
        if (log != null) {
            return log;
        }
        lastLog = new LogWriter(filename, exact, level);
        logs.put(filename, lastLog);
        return lastLog;
    }

    private LogWriter(String filename, boolean exact, int level) {
        this();
        this.filename = filename;
        this.level = level;
        this.exact = exact;
        try {
            if (!exact) {
                this.file = File.createTempFile(filename + ".", ".log");
                this.file.deleteOnExit();
            } else {
                this.file = new File(filename);
            }
            this.realFilename = this.file.getAbsoluteFile();
            this.fileAppender = new Log4jFileAppender(this.realFilename);
            this.fileAppender.setLayout(this.layout);
            this.fileAppender.setName("AppendToFile");
            this.rootLogger.addAppender((Appender)this.fileAppender);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isExact() {
        return this.exact;
    }

    public boolean close() {
        boolean retval = true;
        try {
            this.stream.close();
            logs.remove(this.getFilename());
        }
        catch (Exception e) {
            retval = false;
        }
        return retval;
    }

    public void setLogLevel(int lvl) {
        this.level = lvl;
    }

    public void setLogLevel(String lvl) {
        this.level = LogWriter.getLogLevel(lvl);
    }

    public int getLogLevel() {
        return this.level;
    }

    public String getLogLevelDesc() {
        return logLevelDescription[this.level];
    }

    public void enableTime() {
        this.layout.setTimeAdded(true);
    }

    public void disableTime() {
        this.layout.setTimeAdded(false);
    }

    public boolean getTime() {
        return this.layout.isTimeAdded();
    }

    public void setTime(boolean tim) {
        this.layout.setTimeAdded(tim);
    }

    public String getFilename() {
        if (this.filename != null) {
            return this.filename;
        }
        return NO_FILE_NAME;
    }

    public void println(int lvl, String msg) {
        this.println(lvl, "General", msg);
    }

    public void println(int lvl, String subj, String msg) {
        String subject = subj;
        if (subject == null) {
            subject = "ETL";
        }
        if (this.filter != null && this.filter.length() > 0 && subject.indexOf(this.filter) < 0 && msg.indexOf(this.filter) < 0) {
            return;
        }
        if (this.level == 0) {
            return;
        }
        if (this.level < lvl) {
            return;
        }
        CommonLogger logger = CommonLogger.getLogger((String)subject);
        Log4jMessage message = new Log4jMessage(msg, subject, lvl);
        switch (this.level) {
            case 1: {
                logger.error((Object)message);
                break;
            }
            case 5: 
            case 6: {
                logger.debug((Object)message);
                break;
            }
            default: {
                logger.info((Object)message);
            }
        }
    }

    public void logBasic(String subject, String message) {
        this.println(3, subject, message);
    }

    public void logDetailed(String subject, String message) {
        this.println(4, subject, message);
    }

    public void logDebug(String subject, String message) {
        this.println(5, subject, message);
    }

    public void logRowlevel(String subject, String message) {
        this.println(6, subject, message);
    }

    public void logError(String subject, String message) {
        this.println(1, subject, message);
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getFilter() {
        return this.filter;
    }

    public static final int getLogLevel(String lvl) {
        int i;
        if (lvl == null) {
            return 1;
        }
        for (i = 0; i < logLevelDescription.length; ++i) {
            if (!logLevelDescription[i].equalsIgnoreCase(lvl)) continue;
            return i;
        }
        for (i = 0; i < log_level_desc_long.length; ++i) {
            if (!log_level_desc_long[i].equalsIgnoreCase(lvl)) continue;
            return i;
        }
        return 3;
    }

    public static final String getLogLevelDesc(int l) {
        if (l < 0 || l >= logLevelDescription.length) {
            return logLevelDescription[3];
        }
        return logLevelDescription[l];
    }

    public FileInputStream getFileInputStream() throws IOException {
        return new FileInputStream(this.fileAppender.getFile());
    }

    public boolean isBasic() {
        return this.level == 3;
    }

    public boolean isDetailed() {
        return this.level == 4;
    }

    public boolean isDebug() {
        return this.level == 5;
    }

    public boolean isRowLevel() {
        return this.level == 6;
    }

    public File getRealFilename() {
        return this.realFilename;
    }

    public void setRealFilename(File realFilename) {
        this.realFilename = realFilename;
    }

    public void startStringCapture() {
        Logger logger = Logger.getRootLogger();
        logger.addAppender((Appender)this.stringAppender);
    }

    public void endStringCapture() {
        Logger logger = Logger.getRootLogger();
        logger.removeAppender((Appender)this.stringAppender);
    }

    public String getString() {
        return this.stringAppender.getBuffer().toString();
    }

    public void setString(String string) {
        this.stringAppender.setBuffer(new StringBuffer(string));
    }

    static {
        logs = new Hashtable();
        logLevelDescription = new String[]{"Nothing", "Error", "Minimal", "Basic", "Detailed", "Debug", "Rowlevel"};
        log_level_desc_long = new String[]{"Nothing at all", "Error logging only", "Minimal logging", "Basic logging", "Detailed logging", "Debugging", "Rowlevel (very detailed)"};
    }
}

