/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.asn1.test;

import com.kingdee.bos.ctrl.cipher.asn1.ASN1InputStream;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1Sequence;
import com.kingdee.bos.ctrl.cipher.asn1.DERObjectIdentifier;
import com.kingdee.bos.ctrl.cipher.asn1.isismtt.x509.Admissions;
import com.kingdee.bos.ctrl.cipher.asn1.isismtt.x509.NamingAuthority;
import com.kingdee.bos.ctrl.cipher.asn1.isismtt.x509.ProfessionInfo;
import com.kingdee.bos.ctrl.cipher.asn1.test.ASN1UnitTest;
import com.kingdee.bos.ctrl.cipher.asn1.x500.DirectoryString;
import com.kingdee.bos.ctrl.cipher.asn1.x509.GeneralName;
import com.kingdee.bos.ctrl.cipher.asn1.x509.X509Name;
import java.io.IOException;

public class AdmissionsUnitTest
extends ASN1UnitTest {
    @Override
    public String getName() {
        return "Admissions";
    }

    @Override
    public void performTest() throws Exception {
        GeneralName name = new GeneralName(new X509Name("CN=hello world"));
        NamingAuthority auth = new NamingAuthority(new DERObjectIdentifier("1.2.3"), "url", new DirectoryString("fred"));
        Admissions admissions = new Admissions(name, auth, new ProfessionInfo[0]);
        this.checkConstruction(admissions, name, auth);
        admissions = Admissions.getInstance(null);
        if (admissions != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            Admissions.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(Admissions admissions, GeneralName name, NamingAuthority auth) throws IOException {
        this.checkValues(admissions, name, auth);
        admissions = Admissions.getInstance(admissions);
        this.checkValues(admissions, name, auth);
        ASN1InputStream aIn = new ASN1InputStream(admissions.toASN1Object().getEncoded());
        ASN1Sequence info = (ASN1Sequence)aIn.readObject();
        admissions = Admissions.getInstance(info);
        this.checkValues(admissions, name, auth);
    }

    private void checkValues(Admissions admissions, GeneralName name, NamingAuthority auth) {
        this.checkMandatoryField("admissionAuthority", name, admissions.getAdmissionAuthority());
        this.checkMandatoryField("namingAuthority", auth, admissions.getNamingAuthority());
    }

    public static void main(String[] args) {
        AdmissionsUnitTest.runTest(new AdmissionsUnitTest());
    }
}

