/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.asn1.test;

import com.kingdee.bos.ctrl.cipher.asn1.ASN1InputStream;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1OctetString;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1Sequence;
import com.kingdee.bos.ctrl.cipher.asn1.DERIA5String;
import com.kingdee.bos.ctrl.cipher.asn1.DERNull;
import com.kingdee.bos.ctrl.cipher.asn1.DEROctetString;
import com.kingdee.bos.ctrl.cipher.asn1.oiw.OIWObjectIdentifiers;
import com.kingdee.bos.ctrl.cipher.asn1.x509.AlgorithmIdentifier;
import com.kingdee.bos.ctrl.cipher.asn1.x509.qualified.BiometricData;
import com.kingdee.bos.ctrl.cipher.asn1.x509.qualified.TypeOfBiometricData;
import com.kingdee.bos.ctrl.cipher.util.test.SimpleTest;
import java.util.Random;

public class BiometricDataUnitTest
extends SimpleTest {
    @Override
    public String getName() {
        return "BiometricData";
    }

    private byte[] generateHash() {
        Random rand = new Random();
        byte[] bytes = new byte[20];
        rand.nextBytes(bytes);
        return bytes;
    }

    @Override
    public void performTest() throws Exception {
        TypeOfBiometricData dataType = new TypeOfBiometricData(1);
        AlgorithmIdentifier hashAlgorithm = new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, new DERNull());
        DEROctetString dataHash = new DEROctetString(this.generateHash());
        BiometricData bd = new BiometricData(dataType, hashAlgorithm, dataHash);
        this.checkConstruction(bd, dataType, hashAlgorithm, dataHash, null);
        DERIA5String dataUri = new DERIA5String("http://test");
        bd = new BiometricData(dataType, hashAlgorithm, dataHash, dataUri);
        this.checkConstruction(bd, dataType, hashAlgorithm, dataHash, dataUri);
        bd = BiometricData.getInstance(null);
        if (bd != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            BiometricData.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(BiometricData bd, TypeOfBiometricData dataType, AlgorithmIdentifier hashAlgorithm, ASN1OctetString dataHash, DERIA5String dataUri) throws Exception {
        this.checkValues(bd, dataType, hashAlgorithm, dataHash, dataUri);
        bd = BiometricData.getInstance(bd);
        this.checkValues(bd, dataType, hashAlgorithm, dataHash, dataUri);
        ASN1InputStream aIn = new ASN1InputStream(bd.toASN1Object().getEncoded());
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        bd = BiometricData.getInstance(seq);
        this.checkValues(bd, dataType, hashAlgorithm, dataHash, dataUri);
    }

    private void checkValues(BiometricData bd, TypeOfBiometricData dataType, AlgorithmIdentifier algID, ASN1OctetString dataHash, DERIA5String sourceDataURI) {
        if (!bd.getTypeOfBiometricData().equals(dataType)) {
            this.fail("types don't match.");
        }
        if (!bd.getHashAlgorithm().equals(algID)) {
            this.fail("hash algorithms don't match.");
        }
        if (!bd.getBiometricDataHash().equals(dataHash)) {
            this.fail("hash algorithms don't match.");
        }
        if (sourceDataURI != null) {
            if (!bd.getSourceDataUri().equals(sourceDataURI)) {
                this.fail("data uris don't match.");
            }
        } else if (bd.getSourceDataUri() != null) {
            this.fail("data uri found when none expected.");
        }
    }

    public static void main(String[] args) {
        BiometricDataUnitTest.runTest(new BiometricDataUnitTest());
    }
}

