/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.asn1.test;

import com.kingdee.bos.ctrl.cipher.asn1.ASN1Encodable;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1InputStream;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1Sequence;
import com.kingdee.bos.ctrl.cipher.asn1.DERObjectIdentifier;
import com.kingdee.bos.ctrl.cipher.asn1.DERSequence;
import com.kingdee.bos.ctrl.cipher.asn1.esf.CommitmentTypeIdentifier;
import com.kingdee.bos.ctrl.cipher.asn1.esf.CommitmentTypeIndication;
import com.kingdee.bos.ctrl.cipher.util.test.SimpleTest;
import java.io.IOException;

public class CommitmentTypeIndicationUnitTest
extends SimpleTest {
    @Override
    public String getName() {
        return "CommitmentTypeIndication";
    }

    @Override
    public void performTest() throws Exception {
        CommitmentTypeIndication cti = new CommitmentTypeIndication(CommitmentTypeIdentifier.proofOfOrigin);
        this.checkConstruction(cti, CommitmentTypeIdentifier.proofOfOrigin, null);
        DERSequence qualifier = new DERSequence(new DERObjectIdentifier("1.2"));
        cti = new CommitmentTypeIndication(CommitmentTypeIdentifier.proofOfOrigin, qualifier);
        this.checkConstruction(cti, CommitmentTypeIdentifier.proofOfOrigin, qualifier);
        cti = CommitmentTypeIndication.getInstance(null);
        if (cti != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            CommitmentTypeIndication.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(CommitmentTypeIndication mv, DERObjectIdentifier commitmenttTypeId, ASN1Encodable qualifier) throws IOException {
        this.checkStatement(mv, commitmenttTypeId, qualifier);
        mv = CommitmentTypeIndication.getInstance(mv);
        this.checkStatement(mv, commitmenttTypeId, qualifier);
        ASN1InputStream aIn = new ASN1InputStream(mv.toASN1Object().getEncoded());
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        mv = CommitmentTypeIndication.getInstance(seq);
        this.checkStatement(mv, commitmenttTypeId, qualifier);
    }

    private void checkStatement(CommitmentTypeIndication cti, DERObjectIdentifier commitmentTypeId, ASN1Encodable qualifier) {
        if (!cti.getCommitmentTypeId().equals(commitmentTypeId)) {
            this.fail("commitmentTypeIds don't match.");
        }
        if (qualifier != null) {
            if (!cti.getCommitmentTypeQualifier().equals(qualifier)) {
                this.fail("qualifiers don't match.");
            }
        } else if (cti.getCommitmentTypeQualifier() != null) {
            this.fail("qualifier found when none expected.");
        }
    }

    public static void main(String[] args) {
        CommitmentTypeIndicationUnitTest.runTest(new CommitmentTypeIndicationUnitTest());
    }
}

