/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.asn1.test;

import com.kingdee.bos.ctrl.cipher.asn1.DERGeneralizedTime;
import com.kingdee.bos.ctrl.cipher.util.test.SimpleTest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class GeneralizedTimeTest
extends SimpleTest {
    String[] input = new String[]{"20020122122220", "20020122122220Z", "20020122122220-1000", "20020122122220+00", "20020122122220.1", "20020122122220.1Z", "20020122122220.1-1000", "20020122122220.1+00", "20020122122220.01", "20020122122220.01Z", "20020122122220.01-1000", "20020122122220.01+00", "20020122122220.001", "20020122122220.001Z", "20020122122220.001-1000", "20020122122220.001+00", "20020122122220.0001", "20020122122220.0001Z", "20020122122220.0001-1000", "20020122122220.0001+00", "20020122122220.0001+1000"};
    String[] output = new String[]{"20020122122220", "20020122122220GMT+00:00", "20020122122220GMT-10:00", "20020122122220GMT+00:00", "20020122122220.1", "20020122122220.1GMT+00:00", "20020122122220.1GMT-10:00", "20020122122220.1GMT+00:00", "20020122122220.01", "20020122122220.01GMT+00:00", "20020122122220.01GMT-10:00", "20020122122220.01GMT+00:00", "20020122122220.001", "20020122122220.001GMT+00:00", "20020122122220.001GMT-10:00", "20020122122220.001GMT+00:00", "20020122122220.0001", "20020122122220.0001GMT+00:00", "20020122122220.0001GMT-10:00", "20020122122220.0001GMT+00:00", "20020122122220.0001GMT+10:00"};
    String[] zOutput = new String[]{"20020122122220Z", "20020122122220Z", "20020122222220Z", "20020122122220Z", "20020122122220Z", "20020122122220Z", "20020122222220Z", "20020122122220Z", "20020122122220Z", "20020122122220Z", "20020122222220Z", "20020122122220Z", "20020122122220Z", "20020122122220Z", "20020122222220Z", "20020122122220Z", "20020122122220Z", "20020122122220Z", "20020122222220Z", "20020122122220Z", "20020122022220Z"};

    @Override
    public String getName() {
        return "GeneralizedTime";
    }

    @Override
    public void performTest() throws Exception {
        SimpleDateFormat dateF = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        dateF.setTimeZone(new SimpleTimeZone(0, "Z"));
        for (int i = 0; i != this.input.length; ++i) {
            DERGeneralizedTime t = new DERGeneralizedTime(this.input[i]);
            if (this.output[i].indexOf(71) > 0) {
                if (!t.getTime().equals(this.output[i])) {
                    this.fail("failed conversion test");
                }
                if (dateF.format(t.getDate()).equals(this.zOutput[i])) continue;
                this.fail("failed date conversion test");
                continue;
            }
            String offset = this.calculateGMTOffset(t.getDate());
            if (t.getTime().equals(this.output[i] + offset)) continue;
            this.fail("failed conversion test");
        }
    }

    private String calculateGMTOffset(Date date) {
        String sign = "+";
        TimeZone timeZone = TimeZone.getDefault();
        int offset = timeZone.getRawOffset();
        if (offset < 0) {
            sign = "-";
            offset = -offset;
        }
        int hours = offset / 3600000;
        int minutes = (offset - hours * 60 * 60 * 1000) / 60000;
        if (timeZone.useDaylightTime() && timeZone.inDaylightTime(date)) {
            hours += sign.equals("+") ? 1 : -1;
        }
        return "GMT" + sign + this.convert(hours) + ":" + this.convert(minutes);
    }

    private String convert(int time) {
        if (time < 10) {
            return "0" + time;
        }
        return Integer.toString(time);
    }

    public static void main(String[] args) {
        GeneralizedTimeTest.runTest(new GeneralizedTimeTest());
    }
}

