/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.asn1.test;

import com.kingdee.bos.ctrl.cipher.asn1.ASN1InputStream;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1Sequence;
import com.kingdee.bos.ctrl.cipher.asn1.DERInteger;
import com.kingdee.bos.ctrl.cipher.asn1.isismtt.x509.ProcurationSyntax;
import com.kingdee.bos.ctrl.cipher.asn1.test.ASN1UnitTest;
import com.kingdee.bos.ctrl.cipher.asn1.x500.DirectoryString;
import com.kingdee.bos.ctrl.cipher.asn1.x509.GeneralName;
import com.kingdee.bos.ctrl.cipher.asn1.x509.GeneralNames;
import com.kingdee.bos.ctrl.cipher.asn1.x509.IssuerSerial;
import com.kingdee.bos.ctrl.cipher.asn1.x509.X509Name;
import java.io.IOException;

public class ProcurationSyntaxUnitTest
extends ASN1UnitTest {
    @Override
    public String getName() {
        return "ProcurationSyntax";
    }

    @Override
    public void performTest() throws Exception {
        String country = "AU";
        DirectoryString typeOfSubstitution = new DirectoryString("substitution");
        GeneralName thirdPerson = new GeneralName(new X509Name("CN=thirdPerson"));
        IssuerSerial certRef = new IssuerSerial(new GeneralNames(new GeneralName(new X509Name("CN=test"))), new DERInteger(1));
        ProcurationSyntax procuration = new ProcurationSyntax(country, typeOfSubstitution, thirdPerson);
        this.checkConstruction(procuration, country, typeOfSubstitution, thirdPerson, null);
        procuration = new ProcurationSyntax(country, typeOfSubstitution, certRef);
        this.checkConstruction(procuration, country, typeOfSubstitution, null, certRef);
        procuration = new ProcurationSyntax(null, typeOfSubstitution, certRef);
        this.checkConstruction(procuration, null, typeOfSubstitution, null, certRef);
        procuration = new ProcurationSyntax(country, null, certRef);
        this.checkConstruction(procuration, country, null, null, certRef);
        procuration = ProcurationSyntax.getInstance(null);
        if (procuration != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            ProcurationSyntax.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(ProcurationSyntax procuration, String country, DirectoryString typeOfSubstitution, GeneralName thirdPerson, IssuerSerial certRef) throws IOException {
        this.checkValues(procuration, country, typeOfSubstitution, thirdPerson, certRef);
        procuration = ProcurationSyntax.getInstance(procuration);
        this.checkValues(procuration, country, typeOfSubstitution, thirdPerson, certRef);
        ASN1InputStream aIn = new ASN1InputStream(procuration.toASN1Object().getEncoded());
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        procuration = ProcurationSyntax.getInstance(seq);
        this.checkValues(procuration, country, typeOfSubstitution, thirdPerson, certRef);
    }

    private void checkValues(ProcurationSyntax procuration, String country, DirectoryString typeOfSubstitution, GeneralName thirdPerson, IssuerSerial certRef) {
        this.checkOptionalField("country", country, procuration.getCountry());
        this.checkOptionalField("typeOfSubstitution", typeOfSubstitution, procuration.getTypeOfSubstitution());
        this.checkOptionalField("thirdPerson", thirdPerson, procuration.getThirdPerson());
        this.checkOptionalField("certRef", certRef, procuration.getCertRef());
    }

    public static void main(String[] args) {
        ProcurationSyntaxUnitTest.runTest(new ProcurationSyntaxUnitTest());
    }
}

