/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.asn1.test;

import com.kingdee.bos.ctrl.cipher.asn1.ASN1EncodableVector;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1InputStream;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1Sequence;
import com.kingdee.bos.ctrl.cipher.asn1.DERObjectIdentifier;
import com.kingdee.bos.ctrl.cipher.asn1.DERSequence;
import com.kingdee.bos.ctrl.cipher.asn1.x509.GeneralName;
import com.kingdee.bos.ctrl.cipher.asn1.x509.X509Name;
import com.kingdee.bos.ctrl.cipher.asn1.x509.qualified.SemanticsInformation;
import com.kingdee.bos.ctrl.cipher.util.test.SimpleTest;

public class SemanticsInformationUnitTest
extends SimpleTest {
    @Override
    public String getName() {
        return "SemanticsInformation";
    }

    @Override
    public void performTest() throws Exception {
        DERObjectIdentifier statementId = new DERObjectIdentifier("1.1");
        SemanticsInformation mv = new SemanticsInformation(statementId);
        this.checkConstruction(mv, statementId, null);
        GeneralName[] names = new GeneralName[]{new GeneralName(1, "test@test.org"), new GeneralName(new X509Name("cn=test"))};
        mv = new SemanticsInformation(statementId, names);
        this.checkConstruction(mv, statementId, names);
        mv = new SemanticsInformation(names);
        this.checkConstruction(mv, null, names);
        mv = SemanticsInformation.getInstance(null);
        if (mv != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            SemanticsInformation.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ASN1EncodableVector v = new ASN1EncodableVector();
            new SemanticsInformation(new DERSequence(v));
            this.fail("constructor failed to detect empty sequence.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(SemanticsInformation mv, DERObjectIdentifier semanticsIdentifier, GeneralName[] names) throws Exception {
        this.checkStatement(mv, semanticsIdentifier, names);
        mv = SemanticsInformation.getInstance(mv);
        this.checkStatement(mv, semanticsIdentifier, names);
        ASN1InputStream aIn = new ASN1InputStream(mv.toASN1Object().getEncoded());
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        mv = SemanticsInformation.getInstance(seq);
        this.checkStatement(mv, semanticsIdentifier, names);
    }

    private void checkStatement(SemanticsInformation si, DERObjectIdentifier id, GeneralName[] names) {
        if (id != null) {
            if (!si.getSemanticsIdentifier().equals(id)) {
                this.fail("ids don't match.");
            }
        } else if (si.getSemanticsIdentifier() != null) {
            this.fail("statementId found when none expected.");
        }
        if (names != null) {
            GeneralName[] siNames = si.getNameRegistrationAuthorities();
            for (int i = 0; i != siNames.length; ++i) {
                if (names[i].equals(siNames[i])) continue;
                this.fail("name registration authorities don't match.");
            }
        } else if (si.getNameRegistrationAuthorities() != null) {
            this.fail("name registration authorities found when none expected.");
        }
    }

    public static void main(String[] args) {
        SemanticsInformationUnitTest.runTest(new SemanticsInformationUnitTest());
    }
}

