/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.crypto.test;

import com.kingdee.bos.ctrl.cipher.crypto.BlockCipher;
import com.kingdee.bos.ctrl.cipher.crypto.DataLengthException;
import com.kingdee.bos.ctrl.cipher.crypto.params.KeyParameter;
import com.kingdee.bos.ctrl.cipher.util.test.SimpleTest;

public abstract class CipherTest
extends SimpleTest {
    private SimpleTest[] _tests;
    private BlockCipher _engine;
    private KeyParameter _validKey;

    protected CipherTest(SimpleTest[] tests, BlockCipher engine, KeyParameter validKey) {
        this._tests = tests;
        this._engine = engine;
        this._validKey = validKey;
    }

    @Override
    public abstract String getName();

    @Override
    public void performTest() throws Exception {
        for (int i = 0; i != this._tests.length; ++i) {
            this._tests[i].performTest();
        }
        if (this._engine != null) {
            byte[] buf = new byte[16];
            try {
                this._engine.processBlock(buf, 0, buf, 0);
                this.fail("failed initialisation check");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.bufferSizeCheck(this._engine);
        }
    }

    private void bufferSizeCheck(BlockCipher engine) {
        byte[] correctBuf = new byte[engine.getBlockSize()];
        byte[] shortBuf = new byte[correctBuf.length / 2];
        engine.init(true, this._validKey);
        try {
            engine.processBlock(shortBuf, 0, correctBuf, 0);
            this.fail("failed short input check");
        }
        catch (DataLengthException dataLengthException) {
            // empty catch block
        }
        try {
            engine.processBlock(correctBuf, 0, shortBuf, 0);
            this.fail("failed short output check");
        }
        catch (DataLengthException dataLengthException) {
            // empty catch block
        }
        engine.init(false, this._validKey);
        try {
            engine.processBlock(shortBuf, 0, correctBuf, 0);
            this.fail("failed short input check");
        }
        catch (DataLengthException dataLengthException) {
            // empty catch block
        }
        try {
            engine.processBlock(correctBuf, 0, shortBuf, 0);
            this.fail("failed short output check");
        }
        catch (DataLengthException dataLengthException) {
            // empty catch block
        }
    }
}

