/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.crypto.test;

import com.kingdee.bos.ctrl.cipher.crypto.InvalidCipherTextException;
import com.kingdee.bos.ctrl.cipher.crypto.engines.DESEngine;
import com.kingdee.bos.ctrl.cipher.crypto.paddings.BlockCipherPadding;
import com.kingdee.bos.ctrl.cipher.crypto.paddings.ISO10126d2Padding;
import com.kingdee.bos.ctrl.cipher.crypto.paddings.ISO7816d4Padding;
import com.kingdee.bos.ctrl.cipher.crypto.paddings.PKCS7Padding;
import com.kingdee.bos.ctrl.cipher.crypto.paddings.PaddedBufferedBlockCipher;
import com.kingdee.bos.ctrl.cipher.crypto.paddings.TBCPadding;
import com.kingdee.bos.ctrl.cipher.crypto.paddings.X923Padding;
import com.kingdee.bos.ctrl.cipher.crypto.paddings.ZeroBytePadding;
import com.kingdee.bos.ctrl.cipher.crypto.params.KeyParameter;
import com.kingdee.bos.ctrl.cipher.util.encoders.Hex;
import com.kingdee.bos.ctrl.cipher.util.test.SimpleTest;
import java.security.SecureRandom;

public class PaddingTest
extends SimpleTest {
    private void blockCheck(PaddedBufferedBlockCipher cipher, BlockCipherPadding padding, KeyParameter key, byte[] data) {
        byte[] out = new byte[data.length + 8];
        byte[] dec = new byte[data.length];
        try {
            cipher.init(true, key);
            int len = cipher.processBytes(data, 0, data.length, out, 0);
            len += cipher.doFinal(out, len);
            cipher.init(false, key);
            int decLen = cipher.processBytes(out, 0, len, dec, 0);
            decLen += cipher.doFinal(dec, decLen);
            if (!this.areEqual(data, dec)) {
                this.fail("failed to decrypt - i = " + data.length + ", padding = " + padding.getPaddingName());
            }
        }
        catch (Exception e) {
            this.fail("Exception - " + e.toString(), e);
        }
    }

    public void testPadding(BlockCipherPadding padding, SecureRandom rand, byte[] ffVector, byte[] ZeroVector) {
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new DESEngine(), padding);
        KeyParameter key = new KeyParameter(Hex.decode("0011223344556677"));
        byte[] data = new byte[]{-1, -1, -1, 0, 0, 0, 0, 0};
        if (ffVector != null) {
            padding.addPadding(data, 3);
            if (!this.areEqual(data, ffVector)) {
                this.fail("failed ff test for " + padding.getPaddingName());
            }
        }
        if (ZeroVector != null) {
            data = new byte[8];
            padding.addPadding(data, 4);
            if (!this.areEqual(data, ZeroVector)) {
                this.fail("failed zero test for " + padding.getPaddingName());
            }
        }
        for (int i = 1; i != 200; ++i) {
            data = new byte[i];
            rand.nextBytes(data);
            this.blockCheck(cipher, padding, key, data);
        }
    }

    @Override
    public void performTest() {
        SecureRandom rand;
        block2: {
            rand = new SecureRandom(new byte[20]);
            rand.setSeed(System.currentTimeMillis());
            this.testPadding(new PKCS7Padding(), rand, Hex.decode("ffffff0505050505"), Hex.decode("0000000004040404"));
            PKCS7Padding padder = new PKCS7Padding();
            try {
                padder.padCount(new byte[8]);
                this.fail("invalid padding not detected");
            }
            catch (InvalidCipherTextException e) {
                if ("pad block corrupted".equals(e.getMessage())) break block2;
                this.fail("wrong exception for corrupt padding: " + e);
            }
        }
        this.testPadding(new ISO10126d2Padding(), rand, null, null);
        this.testPadding(new X923Padding(), rand, null, null);
        this.testPadding(new TBCPadding(), rand, Hex.decode("ffffff0000000000"), Hex.decode("00000000ffffffff"));
        this.testPadding(new ZeroBytePadding(), rand, Hex.decode("ffffff0000000000"), null);
        this.testPadding(new ISO7816d4Padding(), rand, Hex.decode("ffffff8000000000"), Hex.decode("0000000080000000"));
    }

    @Override
    public String getName() {
        return "PaddingTest";
    }

    public static void main(String[] args) {
        PaddingTest.runTest(new PaddingTest());
    }
}

