/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.crypto.test;

import com.kingdee.bos.ctrl.cipher.crypto.macs.VMPCMac;
import com.kingdee.bos.ctrl.cipher.crypto.params.KeyParameter;
import com.kingdee.bos.ctrl.cipher.crypto.params.ParametersWithIV;
import com.kingdee.bos.ctrl.cipher.util.Arrays;
import com.kingdee.bos.ctrl.cipher.util.encoders.Hex;
import com.kingdee.bos.ctrl.cipher.util.test.SimpleTest;

public class VMPCMacTest
extends SimpleTest {
    static byte[] output1 = Hex.decode("9BDA16E2AD0E284774A3ACBC8835A8326C11FAAD");

    @Override
    public String getName() {
        return "VMPC-MAC";
    }

    public static void main(String[] args) {
        VMPCMacTest.runTest(new VMPCMacTest());
    }

    @Override
    public void performTest() throws Exception {
        KeyParameter kp = new KeyParameter(Hex.decode("9661410AB797D8A9EB767C21172DF6C7"));
        ParametersWithIV kpwiv = new ParametersWithIV(kp, Hex.decode("4B5C2F003E67F39557A8D26F3DA2B155"));
        byte[] m = new byte[256];
        for (int i = 0; i < 256; ++i) {
            m[i] = (byte)i;
        }
        VMPCMac mac = new VMPCMac();
        mac.init(kpwiv);
        mac.update(m, 0, m.length);
        byte[] out = new byte[20];
        mac.doFinal(out, 0);
        if (!Arrays.areEqual(out, output1)) {
            this.fail("Fail", new String(Hex.encode(output1)), new String(Hex.encode(out)));
        }
    }
}

