/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.crypto.tls;

import com.kingdee.bos.ctrl.cipher.crypto.digests.SHA1Digest;
import com.kingdee.bos.ctrl.cipher.crypto.engines.AESFastEngine;
import com.kingdee.bos.ctrl.cipher.crypto.engines.DESedeEngine;
import com.kingdee.bos.ctrl.cipher.crypto.modes.CBCBlockCipher;
import com.kingdee.bos.ctrl.cipher.crypto.tls.TlsBlockCipherCipherSuite;
import com.kingdee.bos.ctrl.cipher.crypto.tls.TlsCipherSuite;
import com.kingdee.bos.ctrl.cipher.crypto.tls.TlsProtocolHandler;
import com.kingdee.bos.ctrl.cipher.crypto.tls.TlsUtils;
import java.io.IOException;
import java.io.OutputStream;

public class TlsCipherSuiteManager {
    private static final int TLS_RSA_WITH_3DES_EDE_CBC_SHA = 10;
    private static final int TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA = 19;
    private static final int TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA = 22;
    private static final int TLS_RSA_WITH_AES_128_CBC_SHA = 47;
    private static final int TLS_DHE_DSS_WITH_AES_128_CBC_SHA = 50;
    private static final int TLS_DHE_RSA_WITH_AES_128_CBC_SHA = 51;
    private static final int TLS_RSA_WITH_AES_256_CBC_SHA = 53;
    private static final int TLS_DHE_DSS_WITH_AES_256_CBC_SHA = 56;
    private static final int TLS_DHE_RSA_WITH_AES_256_CBC_SHA = 57;

    protected static void writeCipherSuites(OutputStream os) throws IOException {
        int[] suites = new int[]{57, 56, 51, 50, 22, 19, 53, 47, 10};
        TlsUtils.writeUint16(2 * suites.length, os);
        for (int i = 0; i < suites.length; ++i) {
            TlsUtils.writeUint16(suites[i], os);
        }
    }

    protected static TlsCipherSuite getCipherSuite(int number, TlsProtocolHandler handler) throws IOException {
        switch (number) {
            case 10: {
                return new TlsBlockCipherCipherSuite(new CBCBlockCipher(new DESedeEngine()), new CBCBlockCipher(new DESedeEngine()), new SHA1Digest(), new SHA1Digest(), 24, 1);
            }
            case 19: {
                return new TlsBlockCipherCipherSuite(new CBCBlockCipher(new DESedeEngine()), new CBCBlockCipher(new DESedeEngine()), new SHA1Digest(), new SHA1Digest(), 24, 3);
            }
            case 22: {
                return new TlsBlockCipherCipherSuite(new CBCBlockCipher(new DESedeEngine()), new CBCBlockCipher(new DESedeEngine()), new SHA1Digest(), new SHA1Digest(), 24, 5);
            }
            case 47: {
                return new TlsBlockCipherCipherSuite(new CBCBlockCipher(new AESFastEngine()), new CBCBlockCipher(new AESFastEngine()), new SHA1Digest(), new SHA1Digest(), 16, 1);
            }
            case 50: {
                return new TlsBlockCipherCipherSuite(new CBCBlockCipher(new AESFastEngine()), new CBCBlockCipher(new AESFastEngine()), new SHA1Digest(), new SHA1Digest(), 16, 3);
            }
            case 51: {
                return new TlsBlockCipherCipherSuite(new CBCBlockCipher(new AESFastEngine()), new CBCBlockCipher(new AESFastEngine()), new SHA1Digest(), new SHA1Digest(), 16, 5);
            }
            case 53: {
                return new TlsBlockCipherCipherSuite(new CBCBlockCipher(new AESFastEngine()), new CBCBlockCipher(new AESFastEngine()), new SHA1Digest(), new SHA1Digest(), 32, 1);
            }
            case 56: {
                return new TlsBlockCipherCipherSuite(new CBCBlockCipher(new AESFastEngine()), new CBCBlockCipher(new AESFastEngine()), new SHA1Digest(), new SHA1Digest(), 32, 3);
            }
            case 57: {
                return new TlsBlockCipherCipherSuite(new CBCBlockCipher(new AESFastEngine()), new CBCBlockCipher(new AESFastEngine()), new SHA1Digest(), new SHA1Digest(), 32, 5);
            }
        }
        handler.failWithError((short)2, (short)40);
        return null;
    }
}

