/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.crypto.tls.test;

import com.kingdee.bos.ctrl.cipher.crypto.tls.AlwaysValidVerifyer;
import com.kingdee.bos.ctrl.cipher.crypto.tls.TlsInputStream;
import com.kingdee.bos.ctrl.cipher.crypto.tls.TlsOuputStream;
import com.kingdee.bos.ctrl.cipher.crypto.tls.TlsProtocolHandler;
import com.kingdee.bos.ctrl.cipher.crypto.tls.test.HTTPSServerThread;
import com.kingdee.bos.ctrl.cipher.util.Arrays;
import com.kingdee.bos.ctrl.cipher.util.encoders.Hex;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class BasicTlsTest
extends TestCase {
    private static final int PORT_NO = 8003;
    private static final String CLIENT = "client";
    private static final char[] CLIENT_PASSWORD = "clientPassword".toCharArray();
    private static final char[] SERVER_PASSWORD = "serverPassword".toCharArray();
    private static final char[] TRUST_STORE_PASSWORD = "trustPassword".toCharArray();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnection() throws Exception {
        HTTPSServerThread server = new HTTPSServerThread();
        server.start();
        Thread.yield();
        AlwaysValidVerifyer verifyer = new AlwaysValidVerifyer();
        Socket s = null;
        for (int i = 0; s == null && i != 3; ++i) {
            Thread.sleep(1000L);
            try {
                s = new Socket("localhost", 8003);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (s == null) {
            throw new IOException("unable to connect");
        }
        try {
            TlsProtocolHandler handler = new TlsProtocolHandler(s.getInputStream(), s.getOutputStream());
            handler.connect(verifyer);
            TlsInputStream is = handler.getTlsInputStream();
            TlsOuputStream os = handler.getTlsOuputStream();
            os.write("GET / HTTP/1.1\r\n\r\n".getBytes());
            byte[] buf = new byte[4096];
            int read = 0;
            int total = 0;
            while ((read = ((InputStream)is).read(buf, total, buf.length - total)) > 0) {
                total += read;
            }
            ((InputStream)is).close();
            byte[] expected = Hex.decode("485454502f312e3120323030204f4b0d0a436f6e74656e742d547970653a20746578742f68746d6c0d0a0d0a3c68746d6c3e0d0a3c626f64793e0d0a48656c6c6f20576f726c64210d0a3c2f626f64793e0d0a3c2f68746d6c3e0d0a");
            BasicTlsTest.assertEquals((int)total, (int)expected.length);
            byte[] tmp = new byte[expected.length];
            System.arraycopy(buf, 0, tmp, 0, total);
            BasicTlsTest.assertTrue((boolean)Arrays.areEqual(expected, tmp));
        }
        finally {
            if (!s.isClosed()) {
                s.close();
            }
        }
    }

    public static TestSuite suite() {
        return new TestSuite(BasicTlsTest.class);
    }

    public static void main(String[] args) throws Exception {
        TestRunner.run((Test)BasicTlsTest.suite());
    }
}

