/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.crypto.util;

import com.kingdee.bos.ctrl.cipher.asn1.ASN1InputStream;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1Object;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1Sequence;
import com.kingdee.bos.ctrl.cipher.asn1.DEREncodable;
import com.kingdee.bos.ctrl.cipher.asn1.DERInteger;
import com.kingdee.bos.ctrl.cipher.asn1.DERObject;
import com.kingdee.bos.ctrl.cipher.asn1.DERObjectIdentifier;
import com.kingdee.bos.ctrl.cipher.asn1.nist.NISTNamedCurves;
import com.kingdee.bos.ctrl.cipher.asn1.oiw.ElGamalParameter;
import com.kingdee.bos.ctrl.cipher.asn1.oiw.OIWObjectIdentifiers;
import com.kingdee.bos.ctrl.cipher.asn1.pkcs.DHParameter;
import com.kingdee.bos.ctrl.cipher.asn1.pkcs.PKCSObjectIdentifiers;
import com.kingdee.bos.ctrl.cipher.asn1.pkcs.PrivateKeyInfo;
import com.kingdee.bos.ctrl.cipher.asn1.pkcs.RSAPrivateKeyStructure;
import com.kingdee.bos.ctrl.cipher.asn1.sec.ECPrivateKeyStructure;
import com.kingdee.bos.ctrl.cipher.asn1.sec.SECNamedCurves;
import com.kingdee.bos.ctrl.cipher.asn1.teletrust.TeleTrusTNamedCurves;
import com.kingdee.bos.ctrl.cipher.asn1.x509.AlgorithmIdentifier;
import com.kingdee.bos.ctrl.cipher.asn1.x509.DSAParameter;
import com.kingdee.bos.ctrl.cipher.asn1.x9.X962NamedCurves;
import com.kingdee.bos.ctrl.cipher.asn1.x9.X962Parameters;
import com.kingdee.bos.ctrl.cipher.asn1.x9.X9ECParameters;
import com.kingdee.bos.ctrl.cipher.asn1.x9.X9ObjectIdentifiers;
import com.kingdee.bos.ctrl.cipher.crypto.params.AsymmetricKeyParameter;
import com.kingdee.bos.ctrl.cipher.crypto.params.DHParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.DHPrivateKeyParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.DSAParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.DSAPrivateKeyParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.ECDomainParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.ECPrivateKeyParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.ElGamalParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.ElGamalPrivateKeyParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.RSAPrivateCrtKeyParameters;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class PrivateKeyFactory {
    public static AsymmetricKeyParameter createKey(byte[] privateKeyInfoData) throws IOException {
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(ASN1Object.fromByteArray(privateKeyInfoData)));
    }

    public static AsymmetricKeyParameter createKey(InputStream inStr) throws IOException {
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(new ASN1InputStream(inStr).readObject()));
    }

    public static AsymmetricKeyParameter createKey(PrivateKeyInfo keyInfo) throws IOException {
        AlgorithmIdentifier algId = keyInfo.getAlgorithmId();
        if (algId.getObjectId().equals(PKCSObjectIdentifiers.rsaEncryption)) {
            RSAPrivateKeyStructure keyStructure = new RSAPrivateKeyStructure((ASN1Sequence)keyInfo.getPrivateKey());
            return new RSAPrivateCrtKeyParameters(keyStructure.getModulus(), keyStructure.getPublicExponent(), keyStructure.getPrivateExponent(), keyStructure.getPrime1(), keyStructure.getPrime2(), keyStructure.getExponent1(), keyStructure.getExponent2(), keyStructure.getCoefficient());
        }
        if (algId.getObjectId().equals(PKCSObjectIdentifiers.dhKeyAgreement)) {
            DHParameter params = new DHParameter((ASN1Sequence)keyInfo.getAlgorithmId().getParameters());
            DERInteger derX = (DERInteger)keyInfo.getPrivateKey();
            BigInteger lVal = params.getL();
            int l = lVal == null ? 0 : lVal.intValue();
            DHParameters dhParams = new DHParameters(params.getP(), params.getG(), null, l);
            return new DHPrivateKeyParameters(derX.getValue(), dhParams);
        }
        if (algId.getObjectId().equals(OIWObjectIdentifiers.elGamalAlgorithm)) {
            ElGamalParameter params = new ElGamalParameter((ASN1Sequence)keyInfo.getAlgorithmId().getParameters());
            DERInteger derX = (DERInteger)keyInfo.getPrivateKey();
            return new ElGamalPrivateKeyParameters(derX.getValue(), new ElGamalParameters(params.getP(), params.getG()));
        }
        if (algId.getObjectId().equals(X9ObjectIdentifiers.id_dsa)) {
            DERInteger derX = (DERInteger)keyInfo.getPrivateKey();
            DEREncodable de = keyInfo.getAlgorithmId().getParameters();
            DSAParameters parameters = null;
            if (de != null) {
                DSAParameter params = DSAParameter.getInstance(de.getDERObject());
                parameters = new DSAParameters(params.getP(), params.getQ(), params.getG());
            }
            return new DSAPrivateKeyParameters(derX.getValue(), parameters);
        }
        if (algId.getObjectId().equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            X962Parameters params = new X962Parameters((DERObject)keyInfo.getAlgorithmId().getParameters());
            ECDomainParameters dParams = null;
            if (params.isNamedCurve()) {
                DERObjectIdentifier oid = (DERObjectIdentifier)params.getParameters();
                X9ECParameters ecP = X962NamedCurves.getByOID(oid);
                if (ecP == null && (ecP = SECNamedCurves.getByOID(oid)) == null && (ecP = NISTNamedCurves.getByOID(oid)) == null) {
                    ecP = TeleTrusTNamedCurves.getByOID(oid);
                }
                dParams = new ECDomainParameters(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
            } else {
                X9ECParameters ecP = new X9ECParameters((ASN1Sequence)params.getParameters());
                dParams = new ECDomainParameters(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
            }
            ECPrivateKeyStructure ec = new ECPrivateKeyStructure((ASN1Sequence)keyInfo.getPrivateKey());
            return new ECPrivateKeyParameters(ec.getKey(), dParams);
        }
        throw new RuntimeException("algorithm identifier in key not recognised");
    }
}

