/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.math.ec.test;

import com.kingdee.bos.ctrl.cipher.asn1.sec.SECNamedCurves;
import com.kingdee.bos.ctrl.cipher.asn1.x9.X9ECParameters;
import com.kingdee.bos.ctrl.cipher.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.SecureRandom;
import junit.framework.TestCase;

public class ECPointPerformanceTest
extends TestCase {
    public static final int NUM_ROUNDS = 100;

    private void randMult(String curveName) throws Exception {
        X9ECParameters spec = SECNamedCurves.getByName(curveName);
        BigInteger n = spec.getN();
        ECPoint g = spec.getG();
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG", "SUN");
        BigInteger k = new BigInteger(n.bitLength() - 1, random);
        ECPoint qMultiply = null;
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            qMultiply = g.multiply(k);
        }
        long endTime = System.currentTimeMillis();
        double avgDuration = (double)(endTime - startTime) / 100.0;
        System.out.println(curveName);
        System.out.print("Millis   : ");
        System.out.println(avgDuration);
        System.out.println();
    }

    public void testMultiply() throws Exception {
        this.randMult("sect163r2");
        this.randMult("sect233r1");
        this.randMult("sect283r1");
        this.randMult("sect409r1");
        this.randMult("sect571r1");
        this.randMult("secp224r1");
        this.randMult("secp256r1");
        this.randMult("secp521r1");
    }
}

