/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.fulfil;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.fulfil.ExportUtil;
import com.kingdee.bos.ctrl.ext.fulfil.ExtGuiExecutor;
import com.kingdee.bos.ctrl.ext.fulfil.SnapReportControlModel;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ctrl.kdf.util.kdfsax.KDFSAXException;
import com.kingdee.bos.ctrl.kds.exec.ExecutionContext;
import com.kingdee.bos.ctrl.kds.expans.model.ExtConst;
import com.kingdee.bos.ctrl.kds.expans.model.ExtProps;
import com.kingdee.bos.ctrl.kds.expans.model.collection.SortedExtPropFormulasArray;
import com.kingdee.bos.ctrl.kds.expans.model.data.ETTargets;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtTransitionTarget;
import com.kingdee.bos.ctrl.kds.expans.model.data.HyperlinkCalculableProps;
import com.kingdee.bos.ctrl.kds.expans.model.data.ICalculableProps;
import com.kingdee.bos.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.bos.ctrl.kds.expans.model.data.ParameterImpl;
import com.kingdee.bos.ctrl.kds.io.BookIOUtil;
import com.kingdee.bos.ctrl.kds.io.htm.serial.Variant2String;
import com.kingdee.bos.ctrl.kds.model.expr.Expr;
import com.kingdee.bos.ctrl.kds.model.expr.ExprMethod;
import com.kingdee.bos.ctrl.kds.model.expr.IExprNode;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.Chart;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.ChartDataNode;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.ChartModel;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChart;
import com.kingdee.bos.ctrl.kds.model.struct.embed.image.DynamicAccessImageModel;
import com.kingdee.bos.ctrl.kds.model.struct.embed.image.EmbedImage;
import com.kingdee.bos.ctrl.kds.model.struct.embed.image.EmbedImageType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.image.EmbededImageModel;
import com.kingdee.bos.ctrl.kds.model.struct.embed.image.IImageModel;
import com.kingdee.bos.ctrl.kds.model.struct.filter.AlgorithmUtil;
import com.kingdee.bos.ctrl.kds.model.struct.node.NamedObjectNode;
import com.kingdee.bos.ctrl.kds.model.struct.node.SortedNamedObjectNodeArray;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ExecutorUtil {
    static Logger logger = CommonLogger.getLogger(ExecutorUtil.class);

    public static String buildStringFromDim2Array(double[][] data) {
        if (data == null || data.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(data.length * data[0].length << 3);
        sb.append("ARRAY(");
        for (int i = 0; i < data.length; ++i) {
            sb.append("{");
            double[] rowData = data[i];
            int jEnd = data[i].length;
            for (int j = 0; j < jEnd; ++j) {
                sb.append(rowData[j]).append(',');
            }
            sb.setCharAt(sb.length() - 1, '}');
            sb.append(',');
        }
        sb.setCharAt(sb.length() - 1, ')');
        return sb.toString();
    }

    public static String buildStringFromDim1Array(String[] data) {
        if (data == null || data.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(data.length << 3);
        sb.append("ARRAY(");
        for (int i = 0; i < data.length; ++i) {
            sb.append('\"').append(data[i]).append("\",");
        }
        sb.setCharAt(sb.length() - 1, ')');
        return sb.toString();
    }

    public static byte[] generateShapShot(Book _book, SnapReportControlModel control) throws IOException, KDFException, KDFSAXException, Exception {
        Sheet dstSheet;
        int sh;
        if (_book == null) {
            throw new NullPointerException("\u5f85\u751f\u6210\u5feb\u7167\u7684_book\u4e3a\u7a7a");
        }
        _book.setUserObject("isSnapReportSaveHyperLink", control.isSaveHyplink());
        Book dstBook = BookIOUtil.unpack(BookIOUtil.pack(_book));
        MiscUtil.capacitateFiCalculation(dstBook);
        ExportUtil.setEmbedModel(dstBook, _book);
        ExecutionContext ctx = _book.getDataSetManager().getExecutionContext();
        ExecutionContext dstCtx = dstBook.getDataSetManager().getExecutionContext();
        dstCtx.registerDataSetFactories(ctx.getDataSetFactories());
        for (sh = dstBook.getSheetCount() - 1; sh >= 0; --sh) {
            dstSheet = dstBook.getSheet(sh);
            Sheet.ICellsIterator it = dstSheet.getCellsIterator(null, false, false);
            while (it.hasNext()) {
                Cell dstCell = it.next();
                if (dstCell.getHyperLink() == null || control.isSaveHyplink() && !dstCell.getHyperLink().getLinkTo().startsWith("rptInner:")) continue;
                dstCell.clearExtObject("inner_hyperlink");
            }
        }
        for (sh = dstBook.getSheetCount() - 1; sh >= 0; --sh) {
            boolean isSecurity;
            dstSheet = dstBook.getSheet(sh);
            Sheet srcSheet = _book.getSheet(sh);
            EmbedhLayer dstLayer = dstSheet.getEmbedments(false);
            if (dstLayer != null) {
                EmbedhLayer srcLayer = srcSheet.getEmbedments(false);
                int iEnd = dstLayer.size();
                for (int i = 0; i < iEnd; ++i) {
                    EmbedObject dstEO = dstLayer.getEmbed(i);
                    EmbedObject srcEO = srcLayer.getEmbed(i);
                    if (dstEO instanceof EmbedImage) {
                        EmbedImage dstImage = (EmbedImage)dstEO;
                        EmbedImage srcImage = (EmbedImage)srcLayer.getEmbed(i);
                        if (dstImage.getType() == EmbedImageType.Embeded_Image) continue;
                        IImageModel model = srcImage.getModel();
                        dstImage._placeImageAt(srcImage.getCellPosition());
                        dstImage.setModel(new EmbededImageModel(model.getImageData()));
                        continue;
                    }
                    if (dstEO instanceof Chart) {
                        ChartModel dstChartModel = ((Chart)dstEO).getModel();
                        ChartModel srcChartModel = ((Chart)srcLayer.getEmbed(i)).getModel();
                        ChartDataNode srcNode = srcChartModel.getDataNode();
                        srcNode.setDirty(true);
                        ChartDataNode dstNode = new ChartDataNode(dstSheet);
                        String refersTo = srcNode.getCategoryAxisTitle();
                        if (!StringUtil.isEmptyString((String)refersTo)) {
                            refersTo = "\"" + refersTo + "\"";
                        }
                        dstNode.setCategoryAxisTitleFormula(refersTo);
                        refersTo = srcNode.getChartTitle();
                        if (!StringUtil.isEmptyString((String)refersTo)) {
                            refersTo = "\"" + refersTo + "\"";
                        }
                        dstNode.setChartTitleFormula(refersTo);
                        refersTo = srcNode.getValueAxisTitle();
                        if (!StringUtil.isEmptyString((String)refersTo)) {
                            refersTo = "\"" + refersTo + "\"";
                        }
                        dstNode.setValueAxisTitleFormula(refersTo);
                        dstNode.setDataFormula(ExecutorUtil.buildStringFromDim2Array((double[][])srcNode.getData()));
                        dstNode.setGroupFormula(ExecutorUtil.buildStringFromDim1Array(srcNode.getGroupKeys()));
                        dstNode.setSeriesKeysFormula(ExecutorUtil.buildStringFromDim1Array((String[])srcNode.getSeriesKeys()));
                        dstNode.setSerialByCol(srcNode.isSerialByCol());
                        dstNode.setAngle(srcNode.getAngle());
                        dstChartModel.setDataNode(dstNode);
                        dstChartModel.setChartType(srcChartModel.getChartType());
                        continue;
                    }
                    if (!(dstEO instanceof FlashChart)) continue;
                    ((FlashChart)dstEO).setModel(((FlashChart)srcEO).getModel());
                    ((FlashChart)dstEO).enableExport4Snap();
                }
            }
            if (dstBook.isAutoCalculate()) {
                dstBook.setAutoCalculate(false);
                Sheet.ICellsIterator it = dstSheet.getCellsIterator(null, false, false);
                while (it.hasNext()) {
                    Object obj;
                    Cell dstCell = it.next();
                    if (dstCell.getHyperLink() == null || !control.isSaveHyplink()) {
                        dstCell.clearExtObject("inner_hyperlink");
                    }
                    Cell srcCell = srcSheet.getCell(dstCell.getRow(), dstCell.getCol(), false);
                    dstCell.setExtProps(srcCell.getExtProps(false));
                    if (!ExecutorUtil.handleHyperLink(dstSheet, dstCell)) continue;
                    Expr expr = dstCell.getExpr();
                    boolean setFormula = false;
                    if (expr != null) {
                        IExprNode[] children = expr.getAllNodes();
                        for (int i = 0; i < children.length; ++i) {
                            if (ExecutorUtil.isAllExcelFuncNodes(children[i])) continue;
                            dstCell.setFormula(dstCell.getText());
                            setFormula = true;
                            break;
                        }
                    }
                    Variant value = dstCell.getValue();
                    if (srcCell != null) {
                        value = new Variant(srcCell.getValue().getValue(), srcCell.getValue().getVt());
                    }
                    if (value.isObject() && (obj = value.getValue()) instanceof DynamicAccessImageModel) {
                        value = Variant.nullVariant;
                    }
                    if (setFormula) continue;
                    dstCell.setValue(value);
                }
                dstBook.setAutoCalculate(true);
            }
            ExecutorUtil.calcDisplayValue(srcSheet, dstSheet);
            if (!dstBook.isAutoCalculate() || !(isSecurity = ExtGuiExecutor.isSecurityHidedRowsOrCols(_book))) continue;
            int[] hiddenRows = srcSheet.getSecHidedRows();
            int[] hiddenCols = srcSheet.getSecHidedCols();
            AlgorithmUtil.delHideRowsAndCols(hiddenRows, hiddenCols, dstSheet);
        }
        ExecutorUtil.parseParamFromNamedObject(dstBook);
        return BookIOUtil.pack(dstBook);
    }

    public static void parseParamFromNamedObject(Book _book) {
        SortedNamedObjectNodeArray nameArray = _book.getNames();
        if (nameArray != null && !nameArray.isEmpty()) {
            ArrayList datasetParams = ExecutorUtil.getDatasetParams(nameArray, _book);
            HashMap<String, ParameterImpl> params = new HashMap<String, ParameterImpl>();
            int len = nameArray.size();
            for (int i = 0; i < len; ++i) {
                NamedObjectNode namedNode;
                String name;
                Object objNamed = nameArray.getAt(i);
                if (!(objNamed instanceof NamedObjectNode) || (name = (namedNode = (NamedObjectNode)objNamed).getName()) == null || !name.startsWith("@") || namedNode.isEmpty()) continue;
                ParameterImpl p = new ParameterImpl();
                p.setName(name.substring(1, name.length()));
                p.setValue(namedNode.getValue());
                ExecutorUtil.setDateValue(datasetParams, p);
                params.put(p.getName(), p);
            }
            if (!params.isEmpty()) {
                ExecutionContext eCtx = _book.getDataSetManager().getExecutionContext();
                Map ps = eCtx.getDataSetParameters();
                if (ps != null && !ps.isEmpty()) {
                    ps.putAll(params);
                } else {
                    eCtx.setDataSetParameters(params);
                }
            }
        }
    }

    private static ArrayList getDatasetParams(SortedNamedObjectNodeArray nameArray, Book _book) {
        ArrayList allUnionParam = new ArrayList();
        ExtDataSetManager dm = _book.getDataSetManager();
        int dsSize = dm.size();
        if (dsSize <= 0) {
            return allUnionParam;
        }
        ExtDataSet[] datasets = new ExtDataSet[dsSize];
        for (int i = 0; i < dsSize; ++i) {
            datasets[i] = dm.getAt(i);
        }
        String define = datasets[0].getDefine();
        Map mapDefine = new HashMap(1);
        mapDefine = define.indexOf("rZns4x88ShmCrA4shCy6yENOfX0=\u3010\u6c47\u603b\u4e0a\u62a5\u4e13\u7528\u3011") != -1 ? RunReportParam.splitDefine2Map((String)define) : RunReportParam.splitDefineToMap((String)define);
        String sourceReportOrgID = CtrlReportUtil.getObjectString(mapDefine.get("OrgID"));
        ArrayList reportDBModel = new ArrayList();
        try {
            RunReportParam.cacheDbSourceModel(null, (ExtDataSet[])datasets, reportDBModel, allUnionParam, null, (String)sourceReportOrgID, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return allUnionParam;
    }

    private static void setDateValue(ArrayList datasetParams, ParameterImpl p) {
        if (!datasetParams.isEmpty()) {
            int length = datasetParams.size();
            for (int j = 0; j < length; ++j) {
                DesignParameter dp;
                Object oParam = datasetParams.get(j);
                if (!(oParam instanceof DesignParameter) || !(dp = (DesignParameter)oParam).getName().equals(p.getName())) continue;
                switch (dp.getDesignDataType().intValue()) {
                    case 2: {
                        ExecutorUtil.setDateValue(2, p);
                        break;
                    }
                    case 4: {
                        ExecutorUtil.setDateValue(4, p);
                        break;
                    }
                    case 5: {
                        ExecutorUtil.setDateValue(5, p);
                    }
                }
                break;
            }
        }
    }

    private static void setDateValue(int type, ParameterImpl p) {
        if (p.getValue() != null && p.getValue().getValue() instanceof BigDecimal) {
            p.setDataType(type);
            p.setValue(new Variant(Variant.decimalToCalender((BigDecimal)p.getValue().getValue()), 13));
        }
    }

    public static boolean handleHyperLink(Sheet dstSheet, Cell dstCell) {
        ExtProps ep = dstCell.getExtProps(false);
        if (ep == null) {
            return false;
        }
        SortedExtPropFormulasArray formulas = ep.getFormulas(false);
        if (formulas == null) {
            return false;
        }
        ep.setFormulas((SortedExtPropFormulasArray)formulas.clone());
        formulas = ep.getFormulas(false);
        ICalculableProps prop = formulas.get(ExtConst.FORMULA_HYPERLINK);
        if (dstCell.getHyperLink() != null && prop != null) {
            prop = (ICalculableProps)prop.clone();
            formulas.set(formulas.search(ExtConst.FORMULA_HYPERLINK), prop);
            HyperlinkCalculableProps hyperLinkCalProps = (HyperlinkCalculableProps)prop;
            HashMap tars = hyperLinkCalProps.getTargets();
            tars = (HashMap)tars.clone();
            hyperLinkCalProps.setTargets(tars);
            ETTargets repTars = (ETTargets)tars.get("EXTRPT");
            if (repTars != null) {
                repTars = (ETTargets)repTars.clone();
                tars.put("EXTRPT", repTars);
                List targets = repTars.getTargets();
                ArrayList<ExtTransitionTarget> cTargets = new ArrayList<ExtTransitionTarget>();
                repTars.setTargets(cTargets);
                for (ExtTransitionTarget target : targets) {
                    target = target.getDeepCopy();
                    Map params = target.getParameters();
                    ep.executeParams(params);
                    for (Map.Entry next : params.entrySet()) {
                        ICalculableProps p = (ICalculableProps)next.getValue();
                        p.setExpr(null);
                        if (p instanceof ParameterImpl) {
                            String formula = Variant2String.toString(((IParameter)((Object)p)).getValue());
                            if (!StringUtil.isEmptyString((String)formula)) {
                                p.setExpr(dstSheet.getExpr(dstCell, "=\"" + formula + "\""));
                            } else {
                                p.setExpr(null);
                            }
                            logger.error((Object)("trasition target new formula is:" + formula));
                        }
                        logger.error((Object)("trasition target param values is:" + Variant2String.toString(((IParameter)((Object)p)).getValue())));
                    }
                    cTargets.add(target);
                }
            }
        }
        return true;
    }

    public static void calcDisplayValue(Sheet oldSheet, Sheet sheet) {
        Sheet.ICellsIterator iter = sheet.getCellsIterator(0, 0, 1048575, 65535, false, true);
        while (iter.hasNext()) {
            Cell oldCell;
            SortedExtPropFormulasArray formulas;
            Cell cell = iter.next();
            ExtProps props = cell.getExtProps(false);
            if (props == null || (formulas = props.getFormulas(false)) == null || formulas.get(ExtConst.FORMULA_DISP_VALUE) == null || (oldCell = oldSheet.getCell(cell.getRow(), cell.getCol(), false)) == null) continue;
            if (oldSheet != sheet) {
                cell.setFormula(oldCell.getText());
                cell.setValue(new Variant(oldCell.getText(), 11));
            }
            formulas.insert(ExtConst.FORMULA_DISP_VALUE, "\"" + oldCell.getText() + "\"");
        }
    }

    public static boolean isAllExcelFuncNodes(IExprNode node) {
        int nodeType = node.getExprType();
        if (nodeType == 8) {
            NamedObjectNode no = (NamedObjectNode)node;
            Expr expr = no.getExpr();
            if (expr != null) {
                IExprNode[] children = expr.getAllNodes();
                for (int i = 0; i < children.length; ++i) {
                    if (ExecutorUtil.isAllExcelFuncNodes(children[i])) continue;
                    return false;
                }
            }
            return true;
        }
        if (node instanceof ExprMethod) {
            return ((ExprMethod)node).isExcelMethod();
        }
        return true;
    }

    public static byte[] generateShapShot(Book _book) throws IOException, KDFException, KDFSAXException, Exception {
        return ExecutorUtil.generateShapShot(_book, new SnapReportControlModel());
    }
}

