/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.fulfil.mobile.webapps.model;

import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.ext.fulfil.mobile.webapps.model.Constants;
import com.kingdee.bos.ctrl.ext.fulfil.mobile.webapps.model.MetaTypeEnum;
import com.kingdee.bos.ctrl.ext.fulfil.mobile.webapps.model.SourceObject;
import com.kingdee.bos.ctrl.ext.fulfil.mobile.webapps.model.SourceTypeEnum;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class PackageMeta {
    private String version = "20240101";
    private String type = MetaTypeEnum.mobile.name();
    private List<SourceObject> sourceObjects = new ArrayList<SourceObject>(128);
    private Map<String, SourceObject> sourceFileNameMappingObject = new HashMap<String, SourceObject>();

    public List<SourceObject> getSourceObjects() {
        return this.sourceObjects;
    }

    public void setSourceObjects(List<SourceObject> sourceObjects) {
        this.sourceObjects = sourceObjects;
    }

    public Element toXml() {
        Element metaElement = XmlUtil.createNode((String)"Meta");
        metaElement.setAttribute("type", this.type);
        metaElement.setAttribute("version", this.version);
        this.sourceObjectToElement(metaElement);
        return metaElement;
    }

    private void sourceObjectToElement(Element metaElement) {
        if (this.sourceObjects != null && !this.sourceObjects.isEmpty()) {
            Element element = null;
            String fileType = null;
            for (SourceObject sourceObject : this.sourceObjects) {
                String sourceName = sourceObject.getName();
                if (sourceName.endsWith(".css")) {
                    fileType = SourceTypeEnum.css.name();
                } else if (sourceName.endsWith(".html")) {
                    fileType = SourceTypeEnum.html.name();
                } else if (sourceName.endsWith(".jar")) {
                    fileType = SourceTypeEnum.jar.name();
                } else if (sourceName.endsWith(".jpg")) {
                    fileType = SourceTypeEnum.jpg.name();
                } else if (sourceName.endsWith(".js")) {
                    fileType = SourceTypeEnum.js.name();
                } else if (sourceName.endsWith(".png")) {
                    fileType = SourceTypeEnum.png.name();
                } else if (sourceName.endsWith(".xml")) {
                    fileType = SourceTypeEnum.xml.name();
                } else if (sourceName.endsWith(".gif")) {
                    fileType = SourceTypeEnum.gif.name();
                }
                element = XmlUtil.createNode((String)fileType);
                sourceObject.toXml(element);
                metaElement.addContent((Content)element);
            }
        }
    }

    public void exportToZip(ZipOutputStream zos) throws IOException {
        this.exportMetaXml(zos);
        this.exportMetaFile(zos);
    }

    private void exportMetaXml(ZipOutputStream zos) throws IOException {
        zos.putNextEntry(new ZipEntry("package-meta.xml"));
        Element metaElement = this.toXml();
        Format format = Format.getPrettyFormat();
        format.setIndent("\t");
        format.setEncoding("UTF-8");
        format.setTextMode(Format.TextMode.TRIM_FULL_WHITE);
        XMLOutputter outter = new XMLOutputter(format);
        outter.output(metaElement, (OutputStream)zos);
        zos.flush();
    }

    private void exportMetaFile(ZipOutputStream zos) throws IOException {
        for (SourceObject sourceObject : this.sourceObjects) {
            sourceObject.exportFile(zos);
        }
    }

    public void fromXml(Element metaElement) {
        List sourceElements = metaElement.getChildren();
        for (Element element : sourceElements) {
            SourceObject sourceObject = new SourceObject();
            sourceObject.fromXml(element);
            this.sourceFileNameMappingObject.put(sourceObject.getUid(), sourceObject);
        }
    }

    public void write(ZipInputStream in) {
        try {
            ZipEntry entry = in.getNextEntry();
            while (null != entry) {
                String fileName = entry.getName();
                File newFile = new File(FilenameUtils.normalize((String)(Constants.RUNTIME_UNPACK_EXTWEB_FILE_PATH + File.separator + fileName)));
                if (entry.isDirectory()) {
                    newFile.mkdirs();
                } else {
                    newFile.getParentFile().mkdirs();
                    this.writeSourcefile(in, newFile);
                }
                entry = in.getNextEntry();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeSourcefile(ZipInputStream in, File file) {
        SourceObject sourceObject = this.sourceFileNameMappingObject.get(file.getName().subSequence(0, file.getName().lastIndexOf(".")));
        sourceObject.write(in, file);
    }
}

