/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.rd.ui.views.peview;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.ext.KDExt;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtColumn;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDynamicDataSet;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.model.struct.Range;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FormulaShortcutPanel
extends JPanel {
    public static final String KEY_GROUP = "group";
    public static final String KEY_LIST = "list";
    public static final String KEY_VALUE = "value";
    public static final String KEY_STAT = "stat";
    public static final String KEY_SUM = "sum";
    public static final String KEY_COUNT = "count";
    public static final String KEY_MAX = "max";
    public static final String KEY_MIN = "min";
    public static final String KEY_AVG = "avg";
    private ButtonGroup buttonGroup1;
    private KDComboBox jComboBox1;
    private KDPanel jPanel1;
    private KDRadioButton jRadioButton1;
    private KDRadioButton jRadioButton2;
    private KDRadioButton jRadioButton3;
    private KDRadioButton jRadioButton4;
    private KDTreeView treeView;
    private KDExt _ext;

    public FormulaShortcutPanel() {
        this.initComponents();
        this.initListeners();
    }

    public void setExt(KDExt ext) {
        this._ext = ext;
    }

    private void initListeners() {
        this.jRadioButton4.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FormulaShortcutPanel.this.jComboBox1.setEnabled(true);
                } else {
                    FormulaShortcutPanel.this.jComboBox1.setEnabled(false);
                }
            }
        });
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new KDPanel();
        this.jRadioButton1 = new KDRadioButton();
        this.jRadioButton2 = new KDRadioButton();
        this.jRadioButton3 = new KDRadioButton();
        this.jRadioButton4 = new KDRadioButton();
        this.jRadioButton1.setSelected(true);
        this.buttonGroup1.add((AbstractButton)this.jRadioButton1);
        this.buttonGroup1.add((AbstractButton)this.jRadioButton2);
        this.buttonGroup1.add((AbstractButton)this.jRadioButton3);
        this.buttonGroup1.add((AbstractButton)this.jRadioButton4);
        this.jComboBox1 = new KDComboBox();
        this.jComboBox1.setEnabled(false);
        this.setLayout(new GridBagLayout());
        TableLayout2 layout = new TableLayout2(4, 3);
        layout.setColSpacing(0, 20);
        layout.setFixedWidth(0, 50);
        layout.setFixedWidth(1, 120);
        layout.setRatableWidth(2, 1);
        layout.setRowsSpacing(new int[]{0, 1, 2}, 5);
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setCustomInsets(new Insets(5, 5, 5, 5));
        this.jPanel1.setLayout((LayoutManager)layout);
        this.jRadioButton1.setText(FormulaShortcutPanel.getLocalText(KEY_GROUP));
        this.jPanel1.add((Component)this.jRadioButton1, (Object)TableLayout2.param((int)0, (int)0));
        this.jRadioButton2.setText(FormulaShortcutPanel.getLocalText(KEY_LIST));
        this.jPanel1.add((Component)this.jRadioButton2, (Object)TableLayout2.param((int)1, (int)0));
        this.jRadioButton3.setText(FormulaShortcutPanel.getLocalText(KEY_VALUE));
        this.jPanel1.add((Component)this.jRadioButton3, (Object)TableLayout2.param((int)2, (int)0));
        this.jRadioButton4.setText(FormulaShortcutPanel.getLocalText(KEY_STAT));
        this.jPanel1.add((Component)this.jRadioButton4, (Object)TableLayout2.param((int)3, (int)0));
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{FormulaShortcutPanel.getLocalText(KEY_SUM), FormulaShortcutPanel.getLocalText(KEY_COUNT), FormulaShortcutPanel.getLocalText(KEY_MAX), FormulaShortcutPanel.getLocalText(KEY_MIN), FormulaShortcutPanel.getLocalText(KEY_AVG)}));
        this.jPanel1.add((Component)this.jComboBox1, (Object)TableLayout2.param((int)3, (int)1));
        TableLayout2 layout2 = new TableLayout2(2, 1);
        layout2.setRowSpacing(0, 5);
        layout2.setFixedHeight(0, 90);
        layout2.setRatableHeight(1, 1);
        this.setLayout((LayoutManager)layout2);
        this.add((Component)this.jPanel1, TableLayout2.param((int)0, (int)0));
        this.treeView = new KDTreeView();
        this.treeView.setBorder(BorderFactory.createEtchedBorder());
        this.treeView.setShowButton(false);
        this.add((Component)this.treeView, TableLayout2.param((int)1, (int)0));
    }

    public static String getLocalText(String key) {
        return LanguageManager.getLangMessage((String)key, FormulaShortcutPanel.class, (String)"NotFound");
    }

    void refreshDatasetTree() {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"root");
        final KDTree tree = new KDTree((TreeModel)new KingdeeTreeModel((TreeNode)root, true), false);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.getSelectionModel().setSelectionMode(1);
        ExtDataSetManager dsm = MiscUtil.getActiveSpreadContext(this._ext).getBook().getDataSetManager();
        int size = dsm.size();
        for (int i = 0; i < size; ++i) {
            Object[] cols;
            int colSize;
            ExtDataSet ds = dsm.getAt(i);
            if (ds instanceof ExtDynamicDataSet || (colSize = (cols = MiscUtil.sortColumnsByIndex(ds.getColumns())).length) == 0) continue;
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)ds.getAlias());
            node.setAllowsChildren(true);
            tree.addNodeInto((MutableTreeNode)node, (MutableTreeNode)root);
            for (int j = 0; j < colSize; ++j) {
                ExtColumn col = (ExtColumn)cols[j];
                DefaultKingdeeTreeNode sub = new DefaultKingdeeTreeNode((Object)col.getAlias());
                sub.setUserObject((Object)ds.getAlias());
                sub.setAllowsChildren(false);
                tree.addNodeInto((MutableTreeNode)sub, (MutableTreeNode)node);
            }
        }
        tree.expandAllNodes(true, (TreeNode)root);
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() != 1 || e.getClickCount() != 2) {
                    return;
                }
                TreePath treePath = tree.getSelectionPath();
                if (treePath == null) {
                    return;
                }
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)treePath.getLastPathComponent();
                if (!node.isLeaf()) {
                    return;
                }
                SpreadContext context = MiscUtil.getActiveSpreadContext(FormulaShortcutPanel.this._ext);
                Sheet sheet = context.getBook().getActiveSheet();
                if (sheet == null) {
                    return;
                }
                context.getStateManager().stopEditing();
                Range range = context.getRangeManager().getRange(sheet.getActiveRow(), sheet.getActiveCol());
                if (FormulaShortcutPanel.this.buttonGroup1.getSelection() == FormulaShortcutPanel.this.jRadioButton1.getModel()) {
                    range.setFormula(FormulaShortcutPanel.this.buildFormula(new String[]{"=group(", (String)node.getUserObject(), " , ", node.getText(), ", false)"}));
                } else if (FormulaShortcutPanel.this.buttonGroup1.getSelection() == FormulaShortcutPanel.this.jRadioButton2.getModel()) {
                    range.setFormula(FormulaShortcutPanel.this.buildFormula(new String[]{"=select(", (String)node.getUserObject(), " , ", node.getText(), ")"}));
                } else if (FormulaShortcutPanel.this.buttonGroup1.getSelection() == FormulaShortcutPanel.this.jRadioButton3.getModel()) {
                    range.setFormula(FormulaShortcutPanel.this.buildFormula(new String[]{"=field(", (String)node.getUserObject(), " , ", node.getText(), ")"}));
                } else if (FormulaShortcutPanel.this.buttonGroup1.getSelection() == FormulaShortcutPanel.this.jRadioButton4.getModel()) {
                    switch (FormulaShortcutPanel.this.jComboBox1.getSelectedIndex()) {
                        case 0: {
                            range.setFormula(FormulaShortcutPanel.this.buildFormula(new String[]{"=sum(select(", (String)node.getUserObject(), " , ", node.getText(), "))"}));
                            break;
                        }
                        case 1: {
                            range.setFormula(FormulaShortcutPanel.this.buildFormula(new String[]{"=counta(select(", (String)node.getUserObject(), " , ", node.getText(), "))"}));
                            break;
                        }
                        case 2: {
                            range.setFormula(FormulaShortcutPanel.this.buildFormula(new String[]{"=max(select(", (String)node.getUserObject(), " , ", node.getText(), "))"}));
                            break;
                        }
                        case 3: {
                            range.setFormula(FormulaShortcutPanel.this.buildFormula(new String[]{"=min(select(", (String)node.getUserObject(), " , ", node.getText(), "))"}));
                            break;
                        }
                        case 4: {
                            range.setFormula(FormulaShortcutPanel.this.buildFormula(new String[]{"=average(select(", (String)node.getUserObject(), " , ", node.getText(), "))"}));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("impossible arguments");
                        }
                    }
                }
            }
        });
        this.treeView.setTree(tree);
    }

    private String buildFormula(String[] ele) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ele.length; ++i) {
            sb.append(ele[i]);
        }
        return sb.toString();
    }
}

