/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.reporting;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.reporting.model.CommitType;
import com.kingdee.bos.ctrl.ext.reporting.model.UpdateType;
import com.kingdee.bos.ctrl.ext.reporting.model.design.IReportingModel;
import com.kingdee.bos.ctrl.ext.reporting.model.design.IUpdateConstraint;
import com.kingdee.bos.ctrl.ext.reporting.model.design.IUpdateProperty;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class ReportingModelLoader {
    private static Logger logger = CommonLogger.getLogger(ReportingModelLoader.class);

    public IReportingModel load(IReportingModel emptyModel, Book book, String modelString) throws JDOMException, IOException {
        if (StringUtil.isEmptyString((String)modelString)) {
            emptyModel.setSheet(book.getActiveSheet());
            return emptyModel;
        }
        IReportingModel model = emptyModel;
        Element modelElement = new SAXBuilder().build((InputStream)new ByteArrayInputStream(modelString.getBytes("UTF-8"))).getRootElement();
        try {
            model.setSheet(book.getSheetByName(modelElement.getAttributeValue("sheetName")));
        }
        catch (SyntaxErrorException e) {
            logger.error((Object)"can not find correct sheet! loading stopped!", (Throwable)e);
            return model;
        }
        model.setCommitType(CommitType.getInstance(modelElement.getAttributeValue("commitType")));
        model.setEnabled(Boolean.valueOf(modelElement.getAttributeValue("enabled")));
        model.setFastInvalid(Boolean.valueOf(modelElement.getAttributeValue("isFastInvalid")));
        List updates = modelElement.getChildren("UpdateConstrant");
        if (updates != null) {
            for (int i = 0; i < updates.size(); ++i) {
                Element consElement = (Element)updates.get(i);
                IUpdateConstraint constraint = model.createEmptyUpdateConstraint();
                constraint.setProperty(consElement.getAttributeValue("property"));
                constraint.setDBID(consElement.getAttributeValue("dbID"));
                constraint.setUpdateType(UpdateType.getInstance(consElement.getAttributeValue("updateType")));
                constraint.setUserDefineName(consElement.getAttributeValue("userDefineName"));
                List properties = consElement.getChildren("UpdateProperty");
                if (properties == null) continue;
                for (int j = 0; j < properties.size(); ++j) {
                    Element propElement = (Element)properties.get(j);
                    IUpdateProperty property = constraint.createEmptytUpdateProperties();
                    property.setFormula(propElement.getAttributeValue("formula"));
                    property.setPropertyName(propElement.getAttributeValue("propertyName"));
                    property.setJdbcDataType(Integer.parseInt(propElement.getAttributeValue("jdbcDataType")));
                    property.setPrimaryKey(Boolean.valueOf(propElement.getAttributeValue("isPrimaryKey")));
                }
            }
        }
        return model;
    }
}

