/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.reporting;

import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.ext.reporting.model.design.IReportingModel;
import com.kingdee.bos.ctrl.ext.reporting.model.design.IUpdateConstraint;
import com.kingdee.bos.ctrl.ext.reporting.model.design.IUpdateProperty;
import java.io.IOException;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class ReportingModelSaver {
    public String save(IReportingModel model) throws IOException {
        if (model == null) {
            return null;
        }
        Element modelElement = new Element("ReportingModel");
        modelElement.setAttribute("sheetName", model.getSheetName());
        modelElement.setAttribute("commitType", model.getCommitType().getType());
        modelElement.setAttribute("enabled", String.valueOf(model.isEnabled()));
        modelElement.setAttribute("isFastInvalid", String.valueOf(model.isFastInvalid()));
        model.refreshCellConstraints();
        IUpdateConstraint[] updates = model.getUpdateConstraintList();
        if (updates != null) {
            for (int i = 0; i < updates.length; ++i) {
                IUpdateConstraint constraint = updates[i];
                Element consElement = new Element("UpdateConstrant");
                modelElement.addContent((Content)consElement);
                consElement.setAttribute("property", constraint.getProperty());
                consElement.setAttribute("dbID", constraint.getDBID());
                consElement.setAttribute("updateType", constraint.getUpdateType().getType());
                consElement.setAttribute("userDefineName", constraint.getUserDefineName());
                List properties = constraint.getUpdateProperties();
                if (properties == null) continue;
                for (int j = 0; j < properties.size(); ++j) {
                    IUpdateProperty property = (IUpdateProperty)properties.get(j);
                    Element propElement = new Element("UpdateProperty");
                    consElement.addContent((Content)propElement);
                    propElement.setAttribute("formula", property.getFormula());
                    propElement.setAttribute("propertyName", property.getPropertyName());
                    propElement.setAttribute("jdbcDataType", String.valueOf(property.getJdbcDataType()));
                    propElement.setAttribute("isPrimaryKey", String.valueOf(property.isPrimaryKey()));
                }
            }
        }
        return new String(XmlUtil.saveXmlBytes((Element)modelElement), "UTF-8");
    }
}

